/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

class TestLifecycleException {
    TestLifecycleException() {
    }

    @Test
    void shouldMakeNoneToStoppedIntoHumanReadableInitMessage() {
        MatcherAssert.assertThat((Object)this.exceptionFor(LifecycleStatus.NONE, LifecycleStatus.STOPPED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to initialize."));
    }

    @Test
    void shouldMakeStoppedToStartedIntoHumanReadableStartingMessage() {
        MatcherAssert.assertThat((Object)this.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.STARTED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' was successfully initialized, but failed to start."));
    }

    @Test
    void shouldMakeStartedToStoppedIntoHumanReadableStoppingMessage() {
        MatcherAssert.assertThat((Object)this.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to stop."));
    }

    @Test
    void shouldMakeShutdownIntoHumanReadableShutdownMessage() {
        MatcherAssert.assertThat((Object)this.exceptionFor(LifecycleStatus.STOPPED, LifecycleStatus.SHUTDOWN).getMessage(), (Matcher)Is.is((Object)"Component 'SomeComponent' failed to shut down."));
    }

    @Test
    void shouldIncludeRootCauseMessageInExceptionMessage() {
        Exception root = new Exception("big bad root cause");
        Exception intermediate = new Exception("intermediate exception", root);
        MatcherAssert.assertThat((Object)this.exceptionFor(LifecycleStatus.STARTED, LifecycleStatus.STOPPED, intermediate).getMessage(), (Matcher)Matchers.containsString((String)root.getMessage()));
    }

    private LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to) {
        return this.exceptionFor(from, to, null);
    }

    private LifecycleException exceptionFor(LifecycleStatus from, LifecycleStatus to, Throwable cause) {
        return new LifecycleException(new Object(){

            public String toString() {
                return "SomeComponent";
            }
        }, from, to, cause);
    }
}

