/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.neo4j.test.extension.Inject;

public abstract class StatefullFieldExtension<T>
implements TestInstancePostProcessor,
AfterAllCallback {
    protected abstract String getFieldKey();

    protected abstract Class<T> getFieldType();

    protected abstract T createField(ExtensionContext var1);

    protected abstract ExtensionContext.Namespace getNameSpace();

    public void afterAll(ExtensionContext context) {
        this.removeStoredValue(context);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Class<?> clazz = testInstance.getClass();
        Object instance = this.createInstance(context);
        List<Field> declaredFields = StatefullFieldExtension.getAllFields(clazz);
        for (Field declaredField : declaredFields) {
            if (!declaredField.isAnnotationPresent(Inject.class) || !this.getFieldType().equals(declaredField.getType())) continue;
            declaredField.setAccessible(true);
            declaredField.set(testInstance, instance);
        }
    }

    protected T getStoredValue(ExtensionContext context) {
        return (T)this.getLocalStore(context).get((Object)this.getFieldKey(), this.getFieldType());
    }

    void removeStoredValue(ExtensionContext context) {
        this.getLocalStore(context).remove((Object)this.getFieldKey(), this.getFieldType());
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext, ExtensionContext.Namespace namespace) {
        return extensionContext.getRoot().getStore(namespace);
    }

    private ExtensionContext.Store getLocalStore(ExtensionContext extensionContext) {
        return StatefullFieldExtension.getStore(extensionContext, this.getNameSpace());
    }

    private Object createInstance(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.getLocalStore(extensionContext);
        return store.getOrComputeIfAbsent((Object)this.getFieldKey(), s -> this.createField(extensionContext));
    }

    private static List<Field> getAllFields(Class<?> baseClazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = baseClazz;
        do {
            Collections.addAll(fields, clazz.getDeclaredFields());
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }
}

