/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.scheduler.JobHandle;

public class JobHandles {
    public static <T> List<T> getAllResults(Collection<JobHandle<T>> handles) throws ExecutionException {
        ArrayList<T> result = new ArrayList<T>(handles.size());
        Throwable finalError = null;
        for (JobHandle<T> handle : handles) {
            try {
                result.add(handle.get());
            }
            catch (Throwable e) {
                finalError = Exceptions.chain(finalError, e);
            }
        }
        if (finalError != null) {
            throw new ExecutionException(finalError);
        }
        return result;
    }
}

