/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryPool;

class MemoryPoolTracker
implements MemoryTracker {
    private final ScopedMemoryPool pool;

    MemoryPoolTracker(ScopedMemoryPool pool) {
        this.pool = pool;
    }

    @Override
    public long usedNativeMemory() {
        return this.pool.usedNative();
    }

    @Override
    public long estimatedHeapMemory() {
        return this.pool.usedHeap();
    }

    @Override
    public void allocateNative(long bytes) {
        this.pool.reserveNative(bytes);
    }

    @Override
    public void releaseNative(long bytes) {
        this.pool.releaseNative(bytes);
    }

    @Override
    public void allocateHeap(long bytes) {
        this.pool.reserveHeap(bytes);
    }

    @Override
    public void releaseHeap(long bytes) {
        this.pool.releaseHeap(bytes);
    }

    @Override
    public long heapHighWaterMark() {
        return -1L;
    }

    @Override
    public void reset() {
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new DefaultScopedMemoryTracker(this);
    }
}

