/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.csv.reader.SourceTraceability;

public interface Source
extends Closeable {
    public static final Chunk EMPTY_CHUNK = new GivenChunk(null, 0, 0, SourceTraceability.EMPTY.sourceDescription(), 0, 0);

    public Chunk nextChunk(int var1) throws IOException;

    public static Source singleChunk(final Chunk chunk) {
        return new Source(){
            private boolean returned;

            @Override
            public void close() {
            }

            @Override
            public Chunk nextChunk(int seekStartPos) {
                if (!this.returned) {
                    this.returned = true;
                    return chunk;
                }
                return EMPTY_CHUNK;
            }
        };
    }

    public static interface Chunk {
        public char[] data();

        public int length();

        public int maxFieldSize();

        public String sourceDescription();

        public int startPosition();

        public int backPosition();
    }

    public record GivenChunk(char[] data, int length, int maxFieldSize, String sourceDescription, int startPosition, int backPosition) implements Chunk
    {
    }
}

