/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1;

import org.neo4j.cypher.internal.compiler.v3_1.CRS;
import org.neo4j.cypher.internal.compiler.v3_1.CRS$;
import org.neo4j.cypher.internal.compiler.v3_1.CartesianPoint;
import org.neo4j.cypher.internal.compiler.v3_1.GeographicPoint;
import org.neo4j.cypher.internal.compiler.v3_1.Point;
import org.neo4j.cypher.internal.frontend.v3_1.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_1.CypherTypeException$;
import org.neo4j.cypher.internal.frontend.v3_1.InvalidArgumentException;
import org.neo4j.cypher.internal.frontend.v3_1.InvalidArgumentException$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;

public final class Points$ {
    public static final Points$ MODULE$;

    static {
        new Points$();
    }

    /*
     * WARNING - void declaration
     */
    public Point fromMap(Map<String, Object> map) {
        block4: {
            void var12_10;
            block5: {
                GeographicPoint geographicPoint;
                block3: {
                    String crsName;
                    block2: {
                        CRS crs;
                        Set allowedKeys = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y", "longitude", "latitude", "crs"}));
                        map.keys().foreach((Function1)new Serializable(allowedKeys){
                            public static final long serialVersionUID = 0L;
                            private final Set allowedKeys$1;

                            public final void apply(String k) {
                                if (this.allowedKeys$1.contains((Object)k)) {
                                    return;
                                }
                                throw new InvalidArgumentException(String.format("Unknown key '%s' for creating new point", k), InvalidArgumentException$.MODULE$.$lessinit$greater$default$2());
                            }
                            {
                                this.allowedKeys$1 = allowedKeys$1;
                            }
                        });
                        if (!map.contains((Object)"x") || !map.contains((Object)"y")) break block2;
                        double x = this.safeToDouble(map.apply((Object)"x"));
                        double y = this.safeToDouble(map.apply((Object)"y"));
                        String crsName2 = (String)map.getOrElse((Object)"crs", (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return CRS$.MODULE$.Cartesian().name();
                            }
                        });
                        CRS cRS = crs = CRS$.MODULE$.fromName(crsName2);
                        CRS cRS2 = CRS$.MODULE$.WGS84();
                        CRS cRS3 = cRS;
                        Point point = !(cRS2 != null ? !((Object)cRS2).equals(cRS3) : cRS3 != null) ? new GeographicPoint(x, y, crs) : new CartesianPoint(x, y, crs);
                        geographicPoint = point;
                        break block3;
                    }
                    if (!map.contains((Object)"latitude") || !map.contains((Object)"longitude")) break block4;
                    String string = crsName = (String)map.getOrElse((Object)"crs", (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return CRS$.MODULE$.WGS84().name();
                        }
                    });
                    String string2 = CRS$.MODULE$.WGS84().name();
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                    double latitude = this.safeToDouble(map.apply((Object)"latitude"));
                    double longitude = this.safeToDouble(map.apply((Object)"longitude"));
                    geographicPoint = new GeographicPoint(longitude, latitude, CRS$.MODULE$.fromName(crsName));
                }
                return geographicPoint;
            }
            throw new InvalidArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is not a supported coordinate reference system for geographic points, supported CRS are: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_10, CRS$.MODULE$.WGS84().name()})), InvalidArgumentException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new InvalidArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'", InvalidArgumentException$.MODULE$.$lessinit$greater$default$2());
    }

    private double safeToDouble(Object value) {
        Object object = value;
        if (object instanceof Number) {
            Number number = (Number)object;
            double d = number.doubleValue();
            return d;
        }
        throw new CypherTypeException(new StringBuilder().append((Object)object.getClass().getSimpleName()).append((Object)" is not a valid coordinate type.").toString(), CypherTypeException$.MODULE$.$lessinit$greater$default$2());
    }

    private Points$() {
        MODULE$ = this;
    }
}

