/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ExecutionModel;
import org.neo4j.cypher.internal.compiler.ExecutionModel$VolcanoBatchSize$;
import org.neo4j.cypher.internal.compiler.helpers.PropertyAccessHelper;
import org.neo4j.cypher.internal.compiler.planner.logical.CardinalityCostModel;
import org.neo4j.cypher.internal.compiler.planner.logical.CardinalityCostModel$;
import org.neo4j.cypher.internal.compiler.planner.logical.CardinalityCostModel$HashJoin$;
import org.neo4j.cypher.internal.expressions.AndedPropertyInequalities;
import org.neo4j.cypher.internal.expressions.Ands;
import org.neo4j.cypher.internal.expressions.CachedHasProperty;
import org.neo4j.cypher.internal.expressions.CachedProperty;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.HasLabelsOrTypes;
import org.neo4j.cypher.internal.expressions.HasTypes;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.ir.ordering.ProvidedOrder;
import org.neo4j.cypher.internal.logical.plans.AbstractLetSemiApply;
import org.neo4j.cypher.internal.logical.plans.AbstractSemiApply;
import org.neo4j.cypher.internal.logical.plans.AggregatingPlan;
import org.neo4j.cypher.internal.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.logical.plans.ApplyPlan;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.AssertSameNode;
import org.neo4j.cypher.internal.logical.plans.AssertSameRelationship;
import org.neo4j.cypher.internal.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.logical.plans.DirectedAllRelationshipsScan;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByElementIdSeek;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipIndexContainsScan;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipIndexEndsWithScan;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipIndexScan;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipIndexSeek;
import org.neo4j.cypher.internal.logical.plans.DirectedRelationshipTypeScan;
import org.neo4j.cypher.internal.logical.plans.DirectedUnionRelationshipTypesScan;
import org.neo4j.cypher.internal.logical.plans.ExhaustiveLimit;
import org.neo4j.cypher.internal.logical.plans.ExhaustiveLogicalPlan;
import org.neo4j.cypher.internal.logical.plans.Expand;
import org.neo4j.cypher.internal.logical.plans.FindShortestPaths;
import org.neo4j.cypher.internal.logical.plans.ForeachApply;
import org.neo4j.cypher.internal.logical.plans.IntersectionNodeByLabelsScan;
import org.neo4j.cypher.internal.logical.plans.LeftOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.Limit;
import org.neo4j.cypher.internal.logical.plans.LimitingLogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalBinaryPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalLeafPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanExtension;
import org.neo4j.cypher.internal.logical.plans.LogicalUnaryPlan;
import org.neo4j.cypher.internal.logical.plans.NodeByElementIdSeek;
import org.neo4j.cypher.internal.logical.plans.NodeByIdSeek;
import org.neo4j.cypher.internal.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.logical.plans.NodeHashJoin;
import org.neo4j.cypher.internal.logical.plans.NodeIndexContainsScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexEndsWithScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexScan;
import org.neo4j.cypher.internal.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.logical.plans.NodeUniqueIndexSeek;
import org.neo4j.cypher.internal.logical.plans.Optional;
import org.neo4j.cypher.internal.logical.plans.OptionalExpand;
import org.neo4j.cypher.internal.logical.plans.OrderedUnion;
import org.neo4j.cypher.internal.logical.plans.PartialSort;
import org.neo4j.cypher.internal.logical.plans.PartitionedScanPlan;
import org.neo4j.cypher.internal.logical.plans.ProcedureCall;
import org.neo4j.cypher.internal.logical.plans.ProjectEndpoints;
import org.neo4j.cypher.internal.logical.plans.RightOuterHashJoin;
import org.neo4j.cypher.internal.logical.plans.Selection;
import org.neo4j.cypher.internal.logical.plans.SingleFromRightLogicalPlan;
import org.neo4j.cypher.internal.logical.plans.Skip;
import org.neo4j.cypher.internal.logical.plans.Sort;
import org.neo4j.cypher.internal.logical.plans.StatefulShortestPath;
import org.neo4j.cypher.internal.logical.plans.Trail;
import org.neo4j.cypher.internal.logical.plans.UndirectedAllRelationshipsScan;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByElementIdSeek;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipByIdSeek;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipIndexContainsScan;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipIndexEndsWithScan;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipIndexScan;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipIndexSeek;
import org.neo4j.cypher.internal.logical.plans.UndirectedRelationshipTypeScan;
import org.neo4j.cypher.internal.logical.plans.UndirectedUnionRelationshipTypesScan;
import org.neo4j.cypher.internal.logical.plans.Union;
import org.neo4j.cypher.internal.logical.plans.UnionNodeByLabelsScan;
import org.neo4j.cypher.internal.logical.plans.UnwindCollection;
import org.neo4j.cypher.internal.logical.plans.ValueHashJoin;
import org.neo4j.cypher.internal.logical.plans.VarExpand;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.Cardinality$;
import org.neo4j.cypher.internal.util.CostPerRow;
import org.neo4j.cypher.internal.util.CostPerRow$;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.Multiplier;
import org.neo4j.cypher.internal.util.Multiplier$;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.cypher.internal.util.WorkReduction;
import org.neo4j.cypher.internal.util.WorkReduction$;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CardinalityCostModel$
implements Serializable {
    public static final CardinalityCostModel$ MODULE$ = new CardinalityCostModel$();
    private static final CostPerRow DEFAULT_COST_PER_ROW = CostPerRow$.MODULE$.lift(0.1);
    private static final CostPerRow PROBE_BUILD_COST = CostPerRow$.MODULE$.lift(3.1);
    private static final CostPerRow PROBE_SEARCH_COST = CostPerRow$.MODULE$.lift(2.4);
    private static final int PROPERTY_ACCESS_DB_HITS = 2;
    private static final int LABEL_CHECK_DB_HITS = 1;
    private static final CostPerRow EXPAND_INTO_COST = CostPerRow$.MODULE$.lift(6.4);
    private static final CostPerRow EXPAND_ALL_COST = CostPerRow$.MODULE$.lift(1.5);
    private static final double ALL_SCAN_COST_PER_ROW = 1.2;
    private static final double SHORTEST_INTO_COST = 12.0;
    private static final double SHORTEST_PRODUCT_GRAPH_COST = 18.0;
    private static final double INDEX_SCAN_COST_PER_ROW = 1.0;
    private static final double INDEX_SEEK_COST_PER_ROW = 1.9;
    private static final double STORE_LOOKUP_COST_PER_ROW = 6.2;
    private static final double DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW = MODULE$.INDEX_SCAN_COST_PER_ROW() + MODULE$.STORE_LOOKUP_COST_PER_ROW();
    private static final double PARTIAL_SORT_WORK_INCREASE = 0.1;

    public CostPerRow DEFAULT_COST_PER_ROW() {
        return DEFAULT_COST_PER_ROW;
    }

    public CostPerRow PROBE_BUILD_COST() {
        return PROBE_BUILD_COST;
    }

    public CostPerRow PROBE_SEARCH_COST() {
        return PROBE_SEARCH_COST;
    }

    public int PROPERTY_ACCESS_DB_HITS() {
        return PROPERTY_ACCESS_DB_HITS;
    }

    public int LABEL_CHECK_DB_HITS() {
        return LABEL_CHECK_DB_HITS;
    }

    public CostPerRow EXPAND_INTO_COST() {
        return EXPAND_INTO_COST;
    }

    public CostPerRow EXPAND_ALL_COST() {
        return EXPAND_ALL_COST;
    }

    public double ALL_SCAN_COST_PER_ROW() {
        return ALL_SCAN_COST_PER_ROW;
    }

    public double SHORTEST_INTO_COST() {
        return SHORTEST_INTO_COST;
    }

    public double SHORTEST_PRODUCT_GRAPH_COST() {
        return SHORTEST_PRODUCT_GRAPH_COST;
    }

    public double INDEX_SCAN_COST_PER_ROW() {
        return INDEX_SCAN_COST_PER_ROW;
    }

    public double INDEX_SEEK_COST_PER_ROW() {
        return INDEX_SEEK_COST_PER_ROW;
    }

    public double STORE_LOOKUP_COST_PER_ROW() {
        return STORE_LOOKUP_COST_PER_ROW;
    }

    public double DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW() {
        return DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW;
    }

    public double PARTIAL_SORT_WORK_INCREASE() {
        return PARTIAL_SORT_WORK_INCREASE;
    }

    public CostPerRow costPerRowFor(Expression expression, SemanticTable semanticTable) {
        int noOfStoreAccesses = this.calculateNumberOfStoreAccesses(expression, semanticTable);
        if (noOfStoreAccesses > 0) {
            return new CostPerRow((double)noOfStoreAccesses);
        }
        return this.DEFAULT_COST_PER_ROW();
    }

    public int calculateNumberOfStoreAccesses(Expression expression, SemanticTable semanticTable) {
        return BoxesRunTime.unboxToInt((Object)expression.folder().treeFold((Object)BoxesRunTime.boxToInteger((int)0), (PartialFunction)new Serializable(semanticTable){
            private static final long serialVersionUID = 0L;
            private final SemanticTable semanticTable$3;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CachedHasProperty cachedHasProperty;
                CachedProperty cachedProperty;
                Property property;
                AndedPropertyInequalities andedPropertyInequalities;
                A1 A1 = x1;
                if (A1 instanceof AndedPropertyInequalities && (andedPropertyInequalities = (AndedPropertyInequalities)A1).variable() != null && andedPropertyInequalities.property() != null && andedPropertyInequalities.inequalities() != null) {
                    return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$1(BoxesRunTime.unboxToInt((Object)count));
                }
                if (A1 instanceof Property && this.semanticTable$3.typeFor((property = (Property)A1).map()).isAnyOf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTNode(), package$.MODULE$.CTRelationship()}))) {
                    return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$2(BoxesRunTime.unboxToInt((Object)count));
                }
                if (A1 instanceof CachedProperty && (cachedProperty = (CachedProperty)A1).knownToAccessStore()) {
                    return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$3(BoxesRunTime.unboxToInt((Object)count));
                }
                if (A1 instanceof CachedHasProperty && (cachedHasProperty = (CachedHasProperty)A1).knownToAccessStore()) {
                    return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$4(BoxesRunTime.unboxToInt((Object)count));
                }
                if (A1 instanceof HasLabels ? true : (A1 instanceof HasTypes ? true : A1 instanceof HasLabelsOrTypes)) {
                    return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$5(BoxesRunTime.unboxToInt((Object)count));
                }
                return (B1)(Function1 & Serializable)count -> anonfun.calculateNumberOfStoreAccesses.1.$anonfun$applyOrElse$6(BoxesRunTime.unboxToInt((Object)count));
            }

            public final boolean isDefinedAt(Object x1) {
                CachedHasProperty cachedHasProperty;
                CachedProperty cachedProperty;
                Property property;
                AndedPropertyInequalities andedPropertyInequalities;
                Object object = x1;
                if (object instanceof AndedPropertyInequalities && (andedPropertyInequalities = (AndedPropertyInequalities)object).variable() != null && andedPropertyInequalities.property() != null && andedPropertyInequalities.inequalities() != null) {
                    return true;
                }
                if (object instanceof Property && this.semanticTable$3.typeFor((property = (Property)object).map()).isAnyOf((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTNode(), package$.MODULE$.CTRelationship()}))) {
                    return true;
                }
                if (object instanceof CachedProperty && (cachedProperty = (CachedProperty)object).knownToAccessStore()) {
                    return true;
                }
                if (object instanceof CachedHasProperty && (cachedHasProperty = (CachedHasProperty)object).knownToAccessStore()) {
                    return true;
                }
                if (object instanceof HasLabels ? true : (object instanceof HasTypes ? true : object instanceof HasLabelsOrTypes)) {
                    return true;
                }
                return true;
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$1(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)(count - CardinalityCostModel$.MODULE$.PROPERTY_ACCESS_DB_HITS())));
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$2(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)(count + CardinalityCostModel$.MODULE$.PROPERTY_ACCESS_DB_HITS())));
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$3(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)(count + CardinalityCostModel$.MODULE$.PROPERTY_ACCESS_DB_HITS())));
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$4(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)(count + CardinalityCostModel$.MODULE$.PROPERTY_ACCESS_DB_HITS())));
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$5(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)(count + CardinalityCostModel$.MODULE$.LABEL_CHECK_DB_HITS())));
            }

            public static final /* synthetic */ Foldable.TraverseChildren $anonfun$applyOrElse$6(int count) {
                return new Foldable.TraverseChildren((Object)BoxesRunTime.boxToInteger((int)count));
            }
            {
                this.semanticTable$3 = semanticTable$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.Object ), $anonfun$applyOrElse$2$adapted(java.lang.Object ), $anonfun$applyOrElse$3$adapted(java.lang.Object ), $anonfun$applyOrElse$4$adapted(java.lang.Object ), $anonfun$applyOrElse$5$adapted(java.lang.Object ), $anonfun$applyOrElse$6$adapted(java.lang.Object )}, serializedLambda);
            }
        }));
    }

    public double hackyRelTypeScanCost(Set<PropertyAccessHelper.PropertyAccess> propertyAccess, LogicalVariable relVariable, boolean directed) {
        if (propertyAccess.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CardinalityCostModel$.$anonfun$hackyRelTypeScanCost$1(relVariable, x$1)))) {
            double multiplier = directed ? 1.0 : 0.5;
            return this.DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW() * multiplier;
        }
        double allNodeScanCostMultiplier = directed ? 2.2 : 1.3;
        return this.ALL_SCAN_COST_PER_ROW() * allNodeScanCostMultiplier;
    }

    public CostPerRow org$neo4j$cypher$internal$compiler$planner$logical$CardinalityCostModel$$costPerRow(LogicalPlan plan, Cardinality cardinality, SemanticTable semanticTable, Set<PropertyAccessHelper.PropertyAccess> propertyAccess) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof NodeByLabelScan ? true : (logicalPlan instanceof UnionNodeByLabelsScan ? true : logicalPlan instanceof NodeIndexScan)) {
            return CostPerRow$.MODULE$.lift(this.INDEX_SCAN_COST_PER_ROW());
        }
        if (logicalPlan instanceof IntersectionNodeByLabelsScan) {
            IntersectionNodeByLabelsScan intersectionNodeByLabelsScan = (IntersectionNodeByLabelsScan)logicalPlan;
            if (propertyAccess.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CardinalityCostModel$.$anonfun$costPerRow$1(intersectionNodeByLabelsScan, x$2)))) {
                return CostPerRow$.MODULE$.lift(this.INDEX_SCAN_COST_PER_ROW() + this.STORE_LOOKUP_COST_PER_ROW());
            }
            return CostPerRow$.MODULE$.lift(this.INDEX_SCAN_COST_PER_ROW());
        }
        if (logicalPlan instanceof ProjectEndpoints) {
            return CostPerRow$.MODULE$.lift(this.STORE_LOOKUP_COST_PER_ROW());
        }
        if (logicalPlan instanceof Selection) {
            Selection selection = (Selection)logicalPlan;
            Ands predicate = selection.predicate();
            return this.costPerRowFor((Expression)predicate, semanticTable);
        }
        if (logicalPlan instanceof AllNodesScan) {
            return CostPerRow$.MODULE$.lift(this.ALL_SCAN_COST_PER_ROW());
        }
        if (logicalPlan instanceof OptionalExpand) {
            OptionalExpand optionalExpand = (OptionalExpand)logicalPlan;
            Expand.ExpansionMode expansionMode = optionalExpand.mode();
            Expand.ExpandInto$ expandInto$ = Expand.ExpandInto$.MODULE$;
            if (!(expansionMode != null ? !expansionMode.equals(expandInto$) : expandInto$ != null)) {
                return this.EXPAND_INTO_COST();
            }
        }
        if (logicalPlan instanceof Expand) {
            Expand expand2 = (Expand)logicalPlan;
            Expand.ExpansionMode expansionMode = expand2.mode();
            Expand.ExpandInto$ expandInto$ = Expand.ExpandInto$.MODULE$;
            if (!(expansionMode != null ? !expansionMode.equals(expandInto$) : expandInto$ != null)) {
                return this.EXPAND_INTO_COST();
            }
        }
        if (logicalPlan instanceof VarExpand) {
            VarExpand varExpand = (VarExpand)logicalPlan;
            Expand.ExpansionMode expansionMode = varExpand.mode();
            Expand.ExpandInto$ expandInto$ = Expand.ExpandInto$.MODULE$;
            if (!(expansionMode != null ? !expansionMode.equals(expandInto$) : expandInto$ != null)) {
                return this.EXPAND_INTO_COST();
            }
        }
        if (logicalPlan instanceof Expand ? true : (logicalPlan instanceof VarExpand ? true : logicalPlan instanceof OptionalExpand)) {
            return this.EXPAND_ALL_COST();
        }
        if (logicalPlan instanceof NodeUniqueIndexSeek ? true : (logicalPlan instanceof NodeIndexSeek ? true : (logicalPlan instanceof NodeIndexContainsScan ? true : logicalPlan instanceof NodeIndexEndsWithScan))) {
            return CostPerRow$.MODULE$.lift(this.INDEX_SEEK_COST_PER_ROW());
        }
        if (logicalPlan instanceof NodeByIdSeek ? true : (logicalPlan instanceof NodeByElementIdSeek ? true : (logicalPlan instanceof DirectedRelationshipByIdSeek ? true : logicalPlan instanceof DirectedRelationshipByElementIdSeek))) {
            return CostPerRow$.MODULE$.lift(this.STORE_LOOKUP_COST_PER_ROW());
        }
        if (logicalPlan instanceof UndirectedRelationshipByIdSeek ? true : logicalPlan instanceof UndirectedRelationshipByElementIdSeek) {
            return CostPerRow$.MODULE$.lift(this.STORE_LOOKUP_COST_PER_ROW() / (double)2);
        }
        if (logicalPlan instanceof DirectedAllRelationshipsScan) {
            return CostPerRow$.MODULE$.lift(this.ALL_SCAN_COST_PER_ROW());
        }
        if (logicalPlan instanceof UndirectedAllRelationshipsScan) {
            return CostPerRow$.MODULE$.lift(this.ALL_SCAN_COST_PER_ROW() / (double)2);
        }
        if (logicalPlan instanceof DirectedRelationshipTypeScan) {
            DirectedRelationshipTypeScan directedRelationshipTypeScan = (DirectedRelationshipTypeScan)logicalPlan;
            return CostPerRow$.MODULE$.lift(this.hackyRelTypeScanCost(propertyAccess, directedRelationshipTypeScan.idName(), true));
        }
        if (logicalPlan instanceof UndirectedRelationshipTypeScan) {
            UndirectedRelationshipTypeScan undirectedRelationshipTypeScan = (UndirectedRelationshipTypeScan)logicalPlan;
            return CostPerRow$.MODULE$.lift(this.hackyRelTypeScanCost(propertyAccess, undirectedRelationshipTypeScan.idName(), false));
        }
        if (logicalPlan instanceof DirectedUnionRelationshipTypesScan) {
            DirectedUnionRelationshipTypesScan directedUnionRelationshipTypesScan = (DirectedUnionRelationshipTypesScan)logicalPlan;
            return CostPerRow$.MODULE$.lift(this.hackyRelTypeScanCost(propertyAccess, directedUnionRelationshipTypesScan.idName(), true));
        }
        if (logicalPlan instanceof UndirectedUnionRelationshipTypesScan) {
            UndirectedUnionRelationshipTypesScan undirectedUnionRelationshipTypesScan = (UndirectedUnionRelationshipTypesScan)logicalPlan;
            return CostPerRow$.MODULE$.lift(this.hackyRelTypeScanCost(propertyAccess, undirectedUnionRelationshipTypesScan.idName(), false));
        }
        if (logicalPlan instanceof DirectedRelationshipIndexScan) {
            return CostPerRow$.MODULE$.lift(this.DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW());
        }
        if (logicalPlan instanceof UndirectedRelationshipIndexScan) {
            return CostPerRow$.MODULE$.lift(this.DIRECTED_RELATIONSHIP_INDEX_SCAN_COST_PER_ROW() / (double)2);
        }
        if (logicalPlan instanceof DirectedRelationshipIndexSeek ? true : (logicalPlan instanceof DirectedRelationshipIndexContainsScan ? true : logicalPlan instanceof DirectedRelationshipIndexEndsWithScan)) {
            return CostPerRow$.MODULE$.lift(this.INDEX_SEEK_COST_PER_ROW() + this.STORE_LOOKUP_COST_PER_ROW());
        }
        if (logicalPlan instanceof UndirectedRelationshipIndexSeek ? true : (logicalPlan instanceof UndirectedRelationshipIndexContainsScan ? true : logicalPlan instanceof UndirectedRelationshipIndexEndsWithScan)) {
            return CostPerRow$.MODULE$.lift((this.INDEX_SEEK_COST_PER_ROW() + this.STORE_LOOKUP_COST_PER_ROW()) / (double)2);
        }
        if (logicalPlan instanceof NodeHashJoin ? true : (logicalPlan instanceof AggregatingPlan ? true : (logicalPlan instanceof AbstractLetSemiApply ? true : (logicalPlan instanceof Limit ? true : (logicalPlan instanceof ExhaustiveLimit ? true : (logicalPlan instanceof Optional ? true : (logicalPlan instanceof Argument ? true : (logicalPlan instanceof LeftOuterHashJoin ? true : (logicalPlan instanceof RightOuterHashJoin ? true : (logicalPlan instanceof AbstractSemiApply ? true : (logicalPlan instanceof Skip ? true : (logicalPlan instanceof Union ? true : (logicalPlan instanceof ValueHashJoin ? true : (logicalPlan instanceof UnwindCollection ? true : logicalPlan instanceof ProcedureCall)))))))))))))) {
            return this.DEFAULT_COST_PER_ROW();
        }
        if (logicalPlan instanceof Sort) {
            return this.DEFAULT_COST_PER_ROW().$times(Multiplier$.MODULE$.lift(Math.log(cardinality.amount() + 1.0)));
        }
        if (logicalPlan instanceof FindShortestPaths) {
            return CostPerRow$.MODULE$.lift(this.SHORTEST_INTO_COST());
        }
        if (logicalPlan instanceof StatefulShortestPath) {
            return CostPerRow$.MODULE$.lift(this.SHORTEST_PRODUCT_GRAPH_COST());
        }
        if (logicalPlan instanceof PartitionedScanPlan) {
            throw new IllegalStateException("partitioned scans should only be planned at physical planning");
        }
        return this.DEFAULT_COST_PER_ROW();
    }

    private Cardinality inputCardinality(LogicalPlan plan, PlanningAttributes.Cardinalities cardinalities) {
        return (Cardinality)plan.lhs().map((Function1 & Serializable)p -> (Cardinality)cardinalities.get(p.id())).getOrElse((Function0 & Serializable)() -> MODULE$.outputCardinality(plan, cardinalities));
    }

    private Cardinality outputCardinality(LogicalPlan plan, PlanningAttributes.Cardinalities cardinalities) {
        return (Cardinality)cardinalities.get(plan.id());
    }

    public Selectivity limitingPlanSelectivity(Cardinality inputCardinality, Cardinality outputCardinality, Selectivity parentLimitSelectivity) {
        return this.limitingPlanWorkReduction(inputCardinality, outputCardinality, new WorkReduction(parentLimitSelectivity, WorkReduction$.MODULE$.apply$default$2())).fraction();
    }

    public WorkReduction limitingPlanWorkReduction(Cardinality inputCardinality, Cardinality outputCardinality, WorkReduction parentWorkReduction) {
        Cardinality reducedOutput = parentWorkReduction.calculate(outputCardinality, parentWorkReduction.calculate$default$2());
        Selectivity fraction = (Selectivity)reducedOutput.$div(inputCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
        return parentWorkReduction.withFraction(fraction);
    }

    public CardinalityCostModel.EffectiveCardinalities effectiveCardinalities(LogicalPlan plan, WorkReduction workReduction, ExecutionModel.SelectedBatchSize batchSize, PlanningAttributes.Cardinalities cardinalities) {
        Tuple2<WorkReduction, WorkReduction> tuple2 = this.childrenWorkReduction(plan, workReduction, batchSize, cardinalities);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WorkReduction lhsWorkReduction = (WorkReduction)tuple2._1();
        WorkReduction rhsWorkReduction = (WorkReduction)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lhsWorkReduction, (Object)rhsWorkReduction);
        WorkReduction lhsWorkReduction2 = (WorkReduction)tuple22._1();
        WorkReduction rhsWorkReduction2 = (WorkReduction)tuple22._2();
        LogicalPlan logicalPlan = plan;
        boolean outputCardinalityUseMinimum = logicalPlan instanceof Argument;
        boolean inputCardinalityUseMinimum = outputCardinalityUseMinimum || plan.lhs().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CardinalityCostModel$.$anonfun$effectiveCardinalities$1(x0$1)));
        return new CardinalityCostModel.EffectiveCardinalities(workReduction.calculate(this.outputCardinality(plan, cardinalities), outputCardinalityUseMinimum), lhsWorkReduction2.calculate(this.inputCardinality(plan, cardinalities), inputCardinalityUseMinimum), (Cardinality)plan.lhs().map((Function1 & Serializable)p -> lhsWorkReduction2.calculate((Cardinality)cardinalities.get(p.id()), lhsWorkReduction2.calculate$default$2())).getOrElse((Function0 & Serializable)() -> Cardinality$.MODULE$.EMPTY()), (Cardinality)plan.rhs().map((Function1 & Serializable)p -> rhsWorkReduction2.calculate((Cardinality)cardinalities.get(p.id()), rhsWorkReduction2.calculate$default$2())).getOrElse((Function0 & Serializable)() -> Cardinality$.MODULE$.EMPTY()), lhsWorkReduction2, rhsWorkReduction2);
    }

    public Tuple2<WorkReduction, WorkReduction> childrenWorkReduction(LogicalPlan plan, WorkReduction parentWorkReduction, ExecutionModel.SelectedBatchSize batchSize, PlanningAttributes.Cardinalities cardinalities) {
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof LimitingLogicalPlan) {
            LimitingLogicalPlan limitingLogicalPlan = (LimitingLogicalPlan)logicalPlan;
            Cardinality inputCardinality = (Cardinality)cardinalities.get(((LogicalUnaryPlan)limitingLogicalPlan).source().id());
            Cardinality outputCardinality = (Cardinality)cardinalities.get(((LogicalPlan)limitingLogicalPlan).id());
            WorkReduction reduction = this.limitingPlanWorkReduction(inputCardinality, outputCardinality, parentWorkReduction);
            return new Tuple2((Object)reduction, (Object)reduction);
        }
        if (logicalPlan instanceof SingleFromRightLogicalPlan) {
            SingleFromRightLogicalPlan singleFromRightLogicalPlan = (SingleFromRightLogicalPlan)logicalPlan;
            Cardinality rhsCardinality = (Cardinality)cardinalities.get(singleFromRightLogicalPlan.inner().id());
            WorkReduction qual$1 = this.limitingPlanWorkReduction(rhsCardinality, Cardinality$.MODULE$.SINGLE(), WorkReduction$.MODULE$.NoReduction());
            Some x$1 = new Some((Object)Cardinality$.MODULE$.SINGLE());
            Selectivity x$2 = qual$1.copy$default$1();
            WorkReduction rhsReduction = qual$1.copy(x$2, (Option)x$1);
            return new Tuple2((Object)parentWorkReduction, (Object)rhsReduction);
        }
        WorkReduction workReduction = parentWorkReduction;
        WorkReduction workReduction2 = WorkReduction$.MODULE$.NoReduction();
        if (!(workReduction != null ? !workReduction.equals(workReduction2) : workReduction2 != null)) {
            return new Tuple2((Object)parentWorkReduction, (Object)parentWorkReduction);
        }
        if (logicalPlan instanceof ForeachApply) {
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof Trail) {
            Trail trail = (Trail)logicalPlan;
            return this.trailChildrenWorkReduction(trail, parentWorkReduction, cardinalities);
        }
        if (logicalPlan instanceof ApplyPlan) {
            ApplyPlan applyPlan = (ApplyPlan)logicalPlan;
            return this.nestedLoopChildrenWorkReduction((LogicalBinaryPlan)applyPlan, parentWorkReduction, ExecutionModel$VolcanoBatchSize$.MODULE$, cardinalities);
        }
        if (logicalPlan instanceof CartesianProduct) {
            CartesianProduct cartesianProduct = (CartesianProduct)logicalPlan;
            return this.nestedLoopChildrenWorkReduction((LogicalBinaryPlan)cartesianProduct, parentWorkReduction, batchSize, cardinalities);
        }
        if (logicalPlan instanceof AssertSameNode) {
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof AssertSameRelationship) {
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof Union) {
            Tuple2 tuple2;
            Union union = (Union)logicalPlan;
            Cardinality lhsCardinality = (Cardinality)cardinalities.get(union.left().id());
            Cardinality rhsCardinality = (Cardinality)cardinalities.get(union.right().id());
            Cardinality parentEffectiveCardinality = ((Cardinality)cardinalities.get(union.id())).$times(parentWorkReduction.fraction());
            Tuple2 tuple22 = tuple2 = lhsCardinality.$greater((Object)parentEffectiveCardinality) ? new Tuple2((Object)parentEffectiveCardinality, (Object)Cardinality$.MODULE$.EMPTY()) : new Tuple2((Object)lhsCardinality, (Object)parentEffectiveCardinality.$minus(lhsCardinality));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Cardinality lhsEffectiveCardinality = (Cardinality)tuple2._1();
            Cardinality rhsEffectiveCardinality = (Cardinality)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)lhsEffectiveCardinality, (Object)rhsEffectiveCardinality);
            Cardinality lhsEffectiveCardinality2 = (Cardinality)tuple23._1();
            Cardinality rhsEffectiveCardinality2 = (Cardinality)tuple23._2();
            Selectivity lhsFraction = (Selectivity)lhsEffectiveCardinality2.$div(lhsCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
            Selectivity rhsFraction = (Selectivity)rhsEffectiveCardinality2.$div(rhsCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
            return new Tuple2((Object)parentWorkReduction.withFraction(lhsFraction), (Object)parentWorkReduction.withFraction(rhsFraction));
        }
        if (logicalPlan instanceof OrderedUnion) {
            return new Tuple2((Object)parentWorkReduction, (Object)parentWorkReduction);
        }
        if (logicalPlan != null && CardinalityCostModel$HashJoin$.MODULE$.unapply(logicalPlan)) {
            return new Tuple2((Object)WorkReduction$.MODULE$.NoReduction(), (Object)parentWorkReduction);
        }
        if (logicalPlan instanceof PartialSort) {
            double parentFraction = parentWorkReduction.fraction().factor();
            double childFraction = Math.min(1.0, parentFraction * (1.0 + this.PARTIAL_SORT_WORK_INCREASE()));
            return new Tuple2((Object)parentWorkReduction.withFraction(Selectivity$.MODULE$.apply(childFraction)), (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof ExhaustiveLogicalPlan) {
            return new Tuple2((Object)WorkReduction$.MODULE$.NoReduction(), (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof LogicalUnaryPlan) {
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof LogicalLeafPlan) {
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof LogicalBinaryPlan) {
            LogicalBinaryPlan logicalBinaryPlan = (LogicalBinaryPlan)logicalPlan;
            if (AssertionRunner.ASSERTIONS_ENABLED && !false) {
                throw new AssertionError((Object)("childrenWorkReduction: No case for " + logicalBinaryPlan.getClass().getSimpleName() + " added."));
            }
            return new Tuple2((Object)parentWorkReduction, (Object)WorkReduction$.MODULE$.NoReduction());
        }
        if (logicalPlan instanceof LogicalPlanExtension) {
            LogicalPlanExtension logicalPlanExtension = (LogicalPlanExtension)logicalPlan;
            throw new IllegalArgumentException("Did not expect this plan here: " + logicalPlanExtension);
        }
        throw new MatchError((Object)logicalPlan);
    }

    private Tuple2<WorkReduction, WorkReduction> nestedLoopChildrenWorkReduction(LogicalBinaryPlan plan, WorkReduction parentWorkReduction, ExecutionModel.SelectedBatchSize batchSize, PlanningAttributes.Cardinalities cardinalities) {
        Cardinality lhsCardinality = (Cardinality)cardinalities.get(plan.left().id());
        Cardinality rhsCardinality = (Cardinality)cardinalities.get(plan.right().id());
        Cardinality chunkSize = Cardinality$.MODULE$.min(batchSize.size(), lhsCardinality);
        Cardinality rhsRowsMinimum = Cardinality$.MODULE$.min(batchSize.size(), rhsCardinality);
        Cardinality outputRowsPerExecution = chunkSize.$times(rhsCardinality);
        Cardinality outputChunk = chunkSize.$times(rhsRowsMinimum);
        Cardinality requiredOutput = outputChunk.$times(((Multiplier)Multiplier$.MODULE$.ofDivision(parentWorkReduction.calculate((Cardinality)cardinalities.get(plan.id()), parentWorkReduction.calculate$default$2()), outputChunk).getOrElse((Function0 & Serializable)() -> Multiplier$.MODULE$.ZERO())).ceil());
        Multiplier rhsExecutions = (Multiplier)Multiplier$.MODULE$.ofDivision(requiredOutput, outputRowsPerExecution).getOrElse((Function0 & Serializable)() -> Multiplier$.MODULE$.ZERO());
        Cardinality lhsFullBatches = new Cardinality(rhsExecutions.coefficient()).ceil();
        Cardinality lhsProducedRows = Cardinality$.MODULE$.min(lhsFullBatches.$times(chunkSize), lhsCardinality);
        Cardinality rhsProducedRows = Cardinality$.MODULE$.max(rhsExecutions.$times(rhsCardinality), rhsRowsMinimum);
        Cardinality rhsProducedRowsPerExecution = new Cardinality(((Multiplier)Multiplier$.MODULE$.ofDivision(rhsProducedRows.$times(chunkSize), lhsProducedRows).getOrElse((Function0 & Serializable)() -> Multiplier$.MODULE$.ZERO())).coefficient());
        Selectivity lhsFraction = (Selectivity)lhsProducedRows.$div(lhsCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
        Selectivity rhsFraction = (Selectivity)rhsProducedRowsPerExecution.$div(rhsCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
        return new Tuple2((Object)parentWorkReduction.withFraction(lhsFraction), (Object)parentWorkReduction.withFraction(rhsFraction));
    }

    private Tuple2<WorkReduction, WorkReduction> trailChildrenWorkReduction(Trail plan, WorkReduction parentWorkReduction, PlanningAttributes.Cardinalities cardinalities) {
        Cardinality lhsCardinality = (Cardinality)cardinalities.get(plan.left().id());
        Cardinality rhsNeededExecutions = parentWorkReduction.calculate(lhsCardinality, parentWorkReduction.calculate$default$2());
        Cardinality lhsProducedRows = rhsNeededExecutions.ceil();
        Selectivity lhsFraction = (Selectivity)lhsProducedRows.$div(lhsCardinality).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
        Selectivity rhsFraction = (Selectivity)Selectivity$.MODULE$.of(parentWorkReduction.fraction().factor() / lhsFraction.factor()).getOrElse((Function0 & Serializable)() -> Selectivity$.MODULE$.ONE());
        return new Tuple2((Object)parentWorkReduction.withFraction(lhsFraction), (Object)parentWorkReduction.withFraction(rhsFraction));
    }

    public ExecutionModel.SelectedBatchSize getEffectiveBatchSize(ExecutionModel.SelectedBatchSize batchSize, LogicalPlan plan, PlanningAttributes.ProvidedOrders providedOrders) {
        CartesianProduct cartesianProduct;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CartesianProduct && !((ProvidedOrder)providedOrders.apply((cartesianProduct = (CartesianProduct)logicalPlan).id())).isEmpty()) {
            return ExecutionModel$VolcanoBatchSize$.MODULE$;
        }
        return batchSize;
    }

    public CardinalityCostModel apply(ExecutionModel executionModel) {
        return new CardinalityCostModel(executionModel);
    }

    public Option<ExecutionModel> unapply(CardinalityCostModel x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.executionModel());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CardinalityCostModel$.class);
    }

    public static final /* synthetic */ boolean $anonfun$hackyRelTypeScanCost$1(LogicalVariable relVariable$1, PropertyAccessHelper.PropertyAccess x$1) {
        LogicalVariable logicalVariable = x$1.variable();
        LogicalVariable logicalVariable2 = relVariable$1;
        return !(logicalVariable != null ? !logicalVariable.equals(logicalVariable2) : logicalVariable2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$costPerRow$1(IntersectionNodeByLabelsScan x5$1, PropertyAccessHelper.PropertyAccess x$2) {
        LogicalVariable logicalVariable = x$2.variable();
        LogicalVariable logicalVariable2 = x5$1.idName();
        return !(logicalVariable != null ? !logicalVariable.equals(logicalVariable2) : logicalVariable2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$effectiveCardinalities$1(LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        return logicalPlan instanceof Argument;
    }

    private CardinalityCostModel$() {
    }
}

