/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.io.Serializable;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.eval.DatabaseLookup$;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}aaB\f\u0019!\u0003\r\n!\t\u0005\u0006Q\u00011\t!\u000b\u0005\u0006q\u00011\t!\u000f\u0005\u0006\u000b\u00021\tAR\u0004\u0006)bA\t!\u0016\u0004\u0006/aA\ta\u0016\u0005\u00061\u0016!\t!\u0017\u0005\b5\u0016\u0011\r\u0011b\u0001\\\u0011\u0019)W\u0001)A\u00059\"9a-\u0002b\u0001\n\u00079\u0007BB5\u0006A\u0003%\u0001NB\u0004k\u000bA\u0005\u0019\u0013A6\t\u000b1\\a\u0011A7\t\u000bI,A\u0011B:\u0007\tm,\u0001\u0001 \u0005\to:\u0011\t\u0011)A\u0005q\"AaP\u0004B\u0001B\u0003%A\u000fC\u0003Y\u001d\u0011\u0005q\u0010\u0003\u0004Y\u001d\u0011\u0005\u0011q\u0001\u0005\u00071:!\t!a\u0003\t\u000b!rA\u0011A\u0015\t\rarA\u0011AA\r\u0011\u0019)e\u0002\"\u0001\u0002\u001e\tqA)\u0019;bE\u0006\u001cX\rT8pWV\u0004(BA\r\u001b\u0003\u0011)g/\u00197\u000b\u0005ma\u0012A\u00024bEJL7M\u0003\u0002\u001e=\u0005)a.Z85U*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\f!\u0003Z1uC\n\f7/\u001a*fM\u0016\u0014XM\\2fgV\t!\u0006E\u0002,]Aj\u0011\u0001\f\u0006\u0003[\u0011\n!bY8mY\u0016\u001cG/[8o\u0013\tyCFA\u0005T_J$X\rZ*fiB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\tI\u0006$\u0018MY1tK*\u0011Q\u0007H\u0001\u0007W\u0016\u0014h.\u001a7\n\u0005]\u0012$!\u0005#bi\u0006\u0014\u0017m]3SK\u001a,'/\u001a8dK\u0006QA-\u0019;bE\u0006\u001cX-\u00133\u0015\u0005i\u0002\u0005cA\u0012<{%\u0011A\b\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Er\u0014BA 3\u0005=q\u0015-\\3e\t\u0006$\u0018MY1tK&#\u0007\"B!\u0003\u0001\u0004\u0011\u0015\u0001\u00043bi\u0006\u0014\u0017m]3OC6,\u0007CA\u0019D\u0013\t!%G\u0001\fO_Jl\u0017\r\\5{K\u0012$\u0015\r^1cCN,g*Y7f\u0003I!\u0017\r^1cCN,7\t\\1tg&4\u0017.\u001a:\u0016\u0003\u001d\u0003\"\u0001S\u0006\u000f\u0005%#aB\u0001&T\u001d\tY%K\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q\nI\u0001\u0007yI|w\u000e\u001e \n\u0003}I!!\b\u0010\n\u0005ma\u0012BA\r\u001b\u00039!\u0015\r^1cCN,Gj\\8lkB\u0004\"AV\u0003\u000e\u0003a\u0019\"!\u0002\u0012\u0002\rqJg.\u001b;?)\u0005)\u0016\u0001\u00063bi\u0006\u0014\u0017m]3OC6,wJ\u001d3fe&tw-F\u0001]!\ri&M\u0011\b\u0003=\u0002t!!T0\n\u0003\u0015J!!\u0019\u0013\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\t\u001fJ$WM]5oO*\u0011\u0011\rJ\u0001\u0016I\u0006$\u0018MY1tK:\u000bW.Z(sI\u0016\u0014\u0018N\\4!\u0003I!\u0017\r^1cCN,\u0017\nZ(sI\u0016\u0014\u0018N\\4\u0016\u0003!\u00042!\u00182>\u0003M!\u0017\r^1cCN,\u0017\nZ(sI\u0016\u0014\u0018N\\4!\u0005I!\u0015\r^1cCN,7\t\\1tg&4\u0017.\u001a:\u0014\u0005-\u0011\u0013!E5t-&\u0014H/^1m\t\u0006$\u0018MY1tKR\u0011a.\u001d\t\u0003G=L!\u0001\u001d\u0013\u0003\u000f\t{w\u000e\\3b]\")\u0001\b\u0004a\u0001{\u0005IB-\u001a4bk2$H)\u0019;bE\u0006\u001cXm\u00117bgNLg-[3s)\t!h\u000f\u0005\u0002v\u00175\tQ\u0001C\u0003x\u001b\u0001\u0007\u00010A\u000beCR\f'-Y:f%\u00164WM]3oG\u0016\u0014V\r]8\u0011\u0005EJ\u0018B\u0001>3\u0005m!\u0015\r^1cCN,'+\u001a4fe\u0016t7-\u001a*fa>\u001c\u0018\u000e^8ss\n9A)\u001a4bk2$8c\u0001\b#{B\u0011a\u000bA\u0001\u000bG2\f7o]5gS\u0016\u0014HCBA\u0001\u0003\u0007\t)\u0001\u0005\u0002v\u001d!)q/\u0005a\u0001q\")a0\u0005a\u0001iR!\u0011\u0011AA\u0005\u0011\u00159(\u00031\u0001y)\u0011\t\t!!\u0004\t\u000f\u0005=1\u00031\u0001\u0002\u0012\u0005)b-\u00192sS\u000e$\u0015\r^1cCN,W*\u00198bO\u0016\u0014\b\u0003BA\n\u0003+i\u0011AG\u0005\u0004\u0003/Q\"!\u0006$bEJL7\rR1uC\n\f7/Z'b]\u0006<WM\u001d\u000b\u0004u\u0005m\u0001\"B!\u0016\u0001\u0004\u0011U#\u0001;")
public interface DatabaseLookup {
    public static Ordering<NamedDatabaseId> databaseIdOrdering() {
        return DatabaseLookup$.MODULE$.databaseIdOrdering();
    }

    public static Ordering<NormalizedDatabaseName> databaseNameOrdering() {
        return DatabaseLookup$.MODULE$.databaseNameOrdering();
    }

    public SortedSet<DatabaseReference> databaseReferences();

    public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName var1);

    public DatabaseClassifier databaseClassifier();

    public static interface DatabaseClassifier {
        public boolean isVirtualDatabase(NamedDatabaseId var1);
    }

    public static class Default
    implements DatabaseLookup {
        private final DatabaseReferenceRepository databaseReferenceRepo;
        private final DatabaseClassifier classifier;

        @Override
        public SortedSet<DatabaseReference> databaseReferences() {
            Set unsortedSet = CollectionConverters$.MODULE$.SetHasAsScala(this.databaseReferenceRepo.getAllDatabaseReferences()).asScala();
            return (SortedSet)((SetOps)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).$plus$plus((IterableOnce)unsortedSet);
        }

        @Override
        public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName databaseName) {
            return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.databaseReferenceRepo.getByAlias(databaseName))).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends DatabaseReference, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof DatabaseReferenceImpl.Internal) {
                        DatabaseReferenceImpl.Internal internal = (DatabaseReferenceImpl.Internal)A1;
                        return (B1)internal.databaseId();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(DatabaseReference x1) {
                    DatabaseReference databaseReference = x1;
                    return databaseReference instanceof DatabaseReferenceImpl.Internal;
                }
            });
        }

        @Override
        public DatabaseClassifier databaseClassifier() {
            return this.classifier;
        }

        public Default(DatabaseReferenceRepository databaseReferenceRepo, DatabaseClassifier classifier) {
            this.databaseReferenceRepo = databaseReferenceRepo;
            this.classifier = classifier;
        }

        public Default(DatabaseReferenceRepository databaseReferenceRepo) {
            this(databaseReferenceRepo, DatabaseLookup$.MODULE$.org$neo4j$fabric$eval$DatabaseLookup$$defaultDatabaseClassifier(databaseReferenceRepo));
        }

        public Default(FabricDatabaseManager fabricDatabaseManager) {
            this(fabricDatabaseManager.databaseReferenceRepository(), new DatabaseClassifier(fabricDatabaseManager){
                private final FabricDatabaseManager fabricDatabaseManager$1;

                public final boolean isVirtualDatabase(NamedDatabaseId databaseId2) {
                    return this.fabricDatabaseManager$1.isFabricDatabase(databaseId2);
                }
                {
                    this.fabricDatabaseManager$1 = fabricDatabaseManager$1;
                }
            });
        }
    }
}

