/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Args;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.OutputStreamWritableChannel;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public class LoggingIndexedIdGeneratorMonitor
implements IndexedIdGenerator.Monitor,
Closeable {
    private static final String ARG_TOFILE = "tofile";
    private static final String ARG_FILTER = "filter";
    private static final IdFilter NO_FILTER = (id, numberOfIds) -> true;
    private static final Type[] TYPES = Type.values();
    static final int HEADER_SIZE = 9;
    private final FileSystemAbstraction fs;
    private final Path path;
    private final SystemNanoClock clock;
    private FlushableChannel channel;
    private final AtomicLong position = new AtomicLong();
    private final long rotationThreshold;
    private final long pruneThreshold;

    public static IndexedIdGenerator.Monitor defaultIdMonitor(FileSystemAbstraction fs, Path idFile, Config config) {
        if (((Boolean)config.get(GraphDatabaseInternalSettings.id_generator_log_enabled)).booleanValue()) {
            return new LoggingIndexedIdGeneratorMonitor(fs, idFile.resolveSibling(idFile.getFileName() + ".log"), Clocks.nanoClock(), (Long)config.get(GraphDatabaseInternalSettings.id_generator_log_rotation_threshold), ByteUnit.Byte, ((Duration)config.get(GraphDatabaseInternalSettings.id_generator_log_prune_threshold)).toMillis(), TimeUnit.MILLISECONDS);
        }
        return IndexedIdGenerator.NO_MONITOR;
    }

    LoggingIndexedIdGeneratorMonitor(FileSystemAbstraction fs, Path path, SystemNanoClock clock, long rotationThreshold, ByteUnit rotationThresholdUnit, long pruneThreshold, TimeUnit pruneThresholdUnit) {
        this.fs = fs;
        this.path = path;
        this.clock = clock;
        this.rotationThreshold = rotationThresholdUnit.toBytes(rotationThreshold);
        this.pruneThreshold = pruneThresholdUnit.toMillis(pruneThreshold);
        try {
            if (fs.fileExists(path)) {
                this.moveAwayFile();
            }
            this.channel = this.instantiateChannel();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void opened(long highestWrittenId, long highId) {
        this.putTypeAndTwoIds(Type.OPENED, highestWrittenId, highId);
    }

    @Override
    public synchronized void allocatedFromHigh(long allocatedId, int numberOfIds) {
        this.putTypeAndId(Type.ALLOCATE_HIGH, allocatedId, numberOfIds);
    }

    @Override
    public synchronized void allocatedFromReused(long allocatedId, int numberOfIds) {
        this.putTypeAndId(Type.ALLOCATE_REUSED, allocatedId, numberOfIds);
    }

    @Override
    public synchronized void cached(long cachedId, int numberOfIds) {
        this.putTypeAndId(Type.CACHED, cachedId, numberOfIds);
    }

    @Override
    public synchronized void markedAsUsed(long markedId, int numberOfIds) {
        this.putTypeAndId(Type.MARK_USED, markedId, numberOfIds);
    }

    @Override
    public synchronized void markedAsDeleted(long markedId, int numberOfIds) {
        this.putTypeAndId(Type.MARK_DELETED, markedId, numberOfIds);
    }

    @Override
    public synchronized void markedAsFree(long markedId, int numberOfIds) {
        this.putTypeAndId(Type.MARK_FREE, markedId, numberOfIds);
    }

    @Override
    public synchronized void markedAsReserved(long markedId, int numberOfIds) {
        this.putTypeAndId(Type.MARK_RESERVED, markedId, numberOfIds);
    }

    @Override
    public synchronized void markedAsUnreserved(long markedId, int numberOfIds) {
        this.putTypeAndId(Type.MARK_UNRESERVED, markedId, numberOfIds);
    }

    @Override
    public synchronized void markSessionDone() {
        this.flushBuffer();
        this.checkRotateAndPrune();
    }

    @Override
    public synchronized void normalized(long idRange) {
        this.putTypeAndId(Type.NORMALIZED, idRange);
    }

    @Override
    public synchronized void bridged(long bridgedId) {
        this.putTypeAndId(Type.BRIDGED, bridgedId);
    }

    @Override
    public synchronized void checkpoint(long highestWrittenId, long highId) {
        this.putTypeAndTwoIds(Type.CHECKPOINT, highestWrittenId, highId);
        this.flushBuffer();
    }

    @Override
    public synchronized void clearingCache() {
        this.putTypeOnly(Type.CLEARING_CACHE);
    }

    @Override
    public synchronized void clearedCache() {
        this.putTypeOnly(Type.CLEARED_CACHE);
    }

    @Override
    public void skippedIdsAtHighId(long readHighId, int numberOfIds) {
    }

    @Override
    public synchronized void close() {
        this.putTypeOnly(Type.CLOSED);
        IOUtils.closeAllUnchecked((AutoCloseable[])new FlushableChannel[]{this.channel});
    }

    private void flushBuffer() {
        try {
            this.channel.prepareForFlush().flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void putEntryHeader(Type type) throws IOException {
        this.channel.put(type.id);
        this.channel.putLong(this.clock.millis());
    }

    private void checkRotateAndPrune() {
        if (this.position.longValue() >= this.rotationThreshold) {
            try {
                this.flushBuffer();
                this.channel.close();
                this.moveAwayFile();
                this.position.set(0L);
                this.channel = this.instantiateChannel();
                long time = this.clock.millis();
                long threshold = time - this.pruneThreshold;
                for (Path file2 : this.fs.listFiles(this.path.getParent(), file -> file.getFileName().toString().startsWith(this.path.getFileName() + "-"))) {
                    if (LoggingIndexedIdGeneratorMonitor.millisOf(file2) >= threshold) continue;
                    this.fs.deleteFile(file2);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void putTypeOnly(Type type) {
        try {
            this.putEntryHeader(type);
            this.position.addAndGet(9L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void putTypeAndId(Type type, long id, int numberOfIds) {
        try {
            this.putEntryHeader(type);
            this.channel.putLong(id);
            this.channel.putInt(numberOfIds);
            this.position.addAndGet(21L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void putTypeAndId(Type type, long id) {
        try {
            this.putEntryHeader(type);
            this.channel.putLong(id);
            this.position.addAndGet(17L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void putTypeAndTwoIds(Type type, long id1, long id2) {
        try {
            this.putEntryHeader(type);
            this.channel.putLong(id1);
            this.channel.putLong(id2);
            this.position.addAndGet(25L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void moveAwayFile() throws IOException {
        Path to;
        while (this.fs.fileExists(to = this.timestampedFile())) {
        }
        this.fs.renameFile(this.path, to, new CopyOption[0]);
    }

    private FlushableChannel instantiateChannel() throws IOException {
        return new OutputStreamWritableChannel(this.fs.openAsOutputStream(this.path, false));
    }

    private Path timestampedFile() {
        return this.path.resolveSibling(this.path.getFileName() + "-" + this.clock.millis());
    }

    static long millisOf(Path file) {
        String name = file.getFileName().toString();
        int dashIndex = name.lastIndexOf(45);
        if (dashIndex == -1) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(name.substring(dashIndex + 1));
    }

    public static void main(String[] args) throws IOException {
        Args arguments = Args.withFlags((String[])new String[]{ARG_TOFILE}).parse(args);
        if (arguments.orphans().isEmpty()) {
            System.err.println("Please supply base name of log file");
            return;
        }
        Path path = Path.of((String)arguments.orphans().get(0), new String[0]);
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        String filterArg = arguments.get(ARG_FILTER, null);
        IdFilter filter = filterArg != null ? LoggingIndexedIdGeneratorMonitor.parseFilter(filterArg) : NO_FILTER;
        PrintStream out = System.out;
        boolean redirectsToFile = arguments.getBoolean(ARG_TOFILE);
        if (redirectsToFile) {
            Path outFile = path.resolveSibling(path.getFileName() + ".txt");
            System.out.println("Redirecting output to " + outFile);
            out = new PrintStream(new BufferedOutputStream(Files.newOutputStream(outFile, new OpenOption[0])));
        }
        LoggingIndexedIdGeneratorMonitor.dump((FileSystemAbstraction)fs, path, new Printer(out, filter));
        if (redirectsToFile) {
            out.close();
        }
    }

    static void dump(FileSystemAbstraction fs, Path baseFile, Dumper dumper) throws IOException {
        Path[] files = fs.listFiles(baseFile.getParent(), file -> file.getFileName().toString().startsWith(baseFile.getFileName().toString()) && !file.getFileName().toString().endsWith(".txt"));
        Arrays.sort(files, Comparator.comparing(LoggingIndexedIdGeneratorMonitor::millisOf));
        for (Path file2 : files) {
            LoggingIndexedIdGeneratorMonitor.dumpFile(fs, file2, dumper);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dumpFile(FileSystemAbstraction fs, Path path, Dumper dumper) throws IOException {
        dumper.path(path);
        try {
            InputStreamReadableChannel channel = new InputStreamReadableChannel(fs.openAsInputStream(path));
            try {
                block12: while (true) {
                    byte typeByte;
                    if ((typeByte = channel.get()) < 0 || typeByte >= TYPES.length) {
                        System.out.println("Unknown type " + typeByte);
                        continue;
                    }
                    Type type = TYPES[typeByte];
                    long time = channel.getLong();
                    switch (type) {
                        case CLEARING_CACHE: 
                        case CLEARED_CACHE: 
                        case CLOSED: {
                            dumper.type(type, time);
                            continue block12;
                        }
                        case ALLOCATE_HIGH: 
                        case ALLOCATE_REUSED: 
                        case CACHED: 
                        case MARK_USED: 
                        case MARK_DELETED: 
                        case MARK_FREE: 
                        case MARK_RESERVED: 
                        case MARK_UNRESERVED: {
                            dumper.typeAndId(type, time, channel.getLong(), channel.getInt());
                            continue block12;
                        }
                        case NORMALIZED: 
                        case BRIDGED: {
                            dumper.typeAndId(type, time, channel.getLong());
                            continue block12;
                        }
                        case OPENED: 
                        case CHECKPOINT: {
                            dumper.typeAndTwoIds(type, time, channel.getLong(), channel.getLong());
                            continue block12;
                        }
                    }
                    System.out.println("Unknown type " + type);
                }
            }
            catch (Throwable throwable) {
                try {
                    channel.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private static IdFilter parseFilter(String arg) {
        String[] ids = arg.split(",");
        long[] result = new long[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = Long.parseLong(ids[i]);
        }
        return new Filter(result);
    }

    static enum Type {
        OPENED("Opened"),
        CLOSED("Closed"),
        ALLOCATE_HIGH("AH"),
        ALLOCATE_REUSED("AR"),
        CACHED("CA"),
        MARK_USED("MI"),
        MARK_DELETED("MD"),
        MARK_FREE("MF"),
        MARK_RESERVED("MR"),
        MARK_UNRESERVED("MX"),
        NORMALIZED("NO"),
        BRIDGED("BR"),
        CHECKPOINT("Checkpoint"),
        CLEARING_CACHE("ClearCacheStart"),
        CLEARED_CACHE("ClearCacheEnd");

        final byte id = (byte)this.ordinal();
        final String shortName;

        private Type(String shortName) {
            this.shortName = shortName;
        }
    }

    static interface IdFilter {
        public boolean test(long var1, int var3);
    }

    public static class Printer
    implements Dumper {
        private final PrintStream out;
        private final IdFilter filter;

        public Printer(PrintStream out, IdFilter filter) {
            this.out = out;
            this.filter = filter;
        }

        @Override
        public void path(Path path) {
            this.out.printf("=== %s ===%n", path.toAbsolutePath());
        }

        @Override
        public void type(Type type, long time) {
            this.out.printf("%s %s%n", Format.date((long)time), type.shortName);
        }

        @Override
        public void typeAndId(Type type, long time, long id) {
            if (this.filter.test(id, 1)) {
                this.out.printf("%s %s [%d]%n", Format.date((long)time), type.shortName, id);
            }
        }

        @Override
        public void typeAndId(Type type, long time, long id, int numberOfIds) {
            if (this.filter.test(id, numberOfIds)) {
                if (numberOfIds == 1) {
                    this.out.printf("%s %s [%d]%n", Format.date((long)time), type.shortName, id);
                } else {
                    this.out.printf("%s %s [%d-%d]%n", Format.date((long)time), type.shortName, id, id + (long)numberOfIds - 1L);
                }
            }
        }

        @Override
        public void typeAndTwoIds(Type type, long time, long id1, long id2) {
            this.out.printf("%s %s %d/%d%n", Format.date((long)time), type.shortName, id1, id2);
        }
    }

    static interface Dumper {
        public void path(Path var1);

        public void type(Type var1, long var2);

        public void typeAndId(Type var1, long var2, long var4);

        public void typeAndId(Type var1, long var2, long var4, int var6);

        public void typeAndTwoIds(Type var1, long var2, long var4, long var6);
    }

    public static class Filter
    implements IdFilter {
        private final long[] ids;

        public Filter(long ... ids) {
            this.ids = ids;
        }

        @Override
        public boolean test(long id, int numberOfIds) {
            for (long testId : this.ids) {
                if (testId < id || testId >= id + (long)numberOfIds) continue;
                return true;
            }
            return false;
        }
    }
}

