/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.ReadOnlyHighIdGenerator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;

public class ScanOnOpenReadOnlyIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, ReadOnlyHighIdGenerator> idGenerators = new HashMap<IdType, ReadOnlyHighIdGenerator>();

    @Override
    public IdGenerator open(PageCache pageCache, Path filename, IdType idType, LongSupplier highIdScanner, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) {
        long highId = highIdScanner.getAsLong();
        ReadOnlyHighIdGenerator idGenerator = new ReadOnlyHighIdGenerator(highId, idType);
        this.idGenerators.put(idType, idGenerator);
        return idGenerator;
    }

    @Override
    public IdGenerator create(PageCache pageCache, Path filename, IdType idType, long highId, boolean throwIfFileExists, long maxId, boolean readOnly, Config config, CursorContextFactory contextFactory, ImmutableSet<OpenOption> openOptions, IdSlotDistribution slotDistribution) {
        return this.open(pageCache, filename, idType, () -> highId, maxId, readOnly, config, contextFactory, openOptions, slotDistribution);
    }

    @Override
    public IdGenerator get(IdType idType) {
        ReadOnlyHighIdGenerator idGenerator = this.idGenerators.get(idType);
        if (idGenerator == null) {
            throw new IllegalStateException("IdGenerator for " + idType + " not opened");
        }
        return idGenerator;
    }

    @Override
    public void visit(Consumer<IdGenerator> visitor) {
        this.idGenerators.values().forEach(visitor);
    }

    @Override
    public void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
        this.idGenerators.values().forEach(idGenerator -> idGenerator.clearCache(allocationEnabled, cursorContext));
    }

    @Override
    public Collection<Path> listIdFiles() {
        return Collections.emptyList();
    }
}

