/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.OffloadPageCursorFactory;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

@FunctionalInterface
public interface CursorCreator {
    public PageCursor create() throws IOException;

    public static CursorCreator bind(PageCursor cursor) {
        return () -> cursor.openLinkedCursor(0L);
    }

    public static CursorCreator bind(PagedFile pagedFile, int pfFlags, CursorContext context) {
        return () -> pagedFile.io(0L, pfFlags, context);
    }

    public static CursorCreator bind(OffloadPageCursorFactory pcFactory, int pfFlags, CursorContext context) {
        return () -> pcFactory.create(0L, pfFlags, context);
    }

    public static CursorCreator bind(RootLayerSupport support, int pfFlags, CursorContext context) {
        return () -> support.openCursor(pfFlags, context);
    }
}

