/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringJoiner;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.Overflow;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.ValueHolder;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.context.CursorContext;

class LeafNodeDynamicSize<KEY, VALUE>
implements LeafNodeBehaviour<KEY, VALUE> {
    private final int inlineKeyValueSizeCap;
    private final int keyValueSizeCap;
    private final int totalSpace;
    private final int halfSpace;
    final OffloadStore<KEY, VALUE> offloadStore;
    private final int maxKeyCount;
    final Layout<KEY, VALUE> layout;
    final int payloadSize;

    LeafNodeDynamicSize(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore) {
        this.payloadSize = payloadSize;
        this.layout = layout;
        assert (payloadSize < DynamicSizeUtil.SUPPORTED_PAGE_SIZE_LIMIT) : "Only payload size less then " + DynamicSizeUtil.SUPPORTED_PAGE_SIZE_LIMIT + " bytes supported";
        this.totalSpace = payloadSize - 86;
        this.maxKeyCount = this.totalSpace / 3;
        this.offloadStore = offloadStore;
        this.halfSpace = this.totalSpace >> 1;
        this.inlineKeyValueSizeCap = DynamicSizeUtil.inlineKeyValueSizeCap(payloadSize);
        this.keyValueSizeCap = DynamicSizeUtil.keyValueSizeCapFromPageSize(payloadSize);
        DynamicSizeUtil.validateInlineCap(this.inlineKeyValueSizeCap, payloadSize);
    }

    @Override
    public void initialize(PageCursor cursor, byte layerType, long stableGeneration, long unstableGeneration) {
        TreeNodeUtil.writeBaseHeader(cursor, (byte)1, layerType, stableGeneration, unstableGeneration);
        DynamicSizeUtil.setAllocOffset(cursor, this.payloadSize);
        DynamicSizeUtil.setDeadSpace(cursor, 0);
    }

    @Override
    public long offloadIdAt(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos);
        return DynamicSizeUtil.offloadIdAt(cursor);
    }

    @Override
    public KEY keyAt(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        this.placeCursorAtActualKey(cursor, pos);
        return TreeNodeUtil.readDynamicKey(this.layout, this.offloadStore, cursor, into, pos, cursorContext, this.keyValueSizeCap());
    }

    @Override
    public Comparator<KEY> keyComparator() {
        return this.layout;
    }

    @Override
    public void keyValueAt(PageCursor cursor, KEY intoKey, ValueHolder<VALUE> intoValue, int pos, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos);
        intoValue.defined = true;
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                this.offloadStore.readKeyValue(offloadId, intoKey, intoValue.value, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read keyValue from offload, cause: " + e.getMessage());
            }
        } else {
            if (TreeNodeUtil.isUnreliableKeyValueSize(keySize, valueSize, this.keyValueSizeCap())) {
                TreeNodeUtil.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos, this.keyValueSizeCap());
                return;
            }
            this.layout.readKey(cursor, intoKey, keySize);
            this.layout.readValue(cursor, intoValue.value, valueSize);
        }
    }

    @Override
    public void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int newKeyValueOffset;
        int valueSize;
        int currentKeyValueOffset = DynamicSizeUtil.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        if (this.canInline(keySize + (valueSize = this.layout.valueSize(value)))) {
            newKeyValueOffset = currentKeyValueOffset - keySize - valueSize - DynamicSizeUtil.getOverhead(keySize, valueSize, false);
            cursor.setOffset(newKeyValueOffset);
            DynamicSizeUtil.putKeyValueSize(cursor, keySize, valueSize);
            this.layout.writeKey(cursor, key);
            this.layout.writeValue(cursor, value);
        } else {
            newKeyValueOffset = currentKeyValueOffset - DynamicSizeUtil.getOverhead(keySize, valueSize, true);
            cursor.setOffset(newKeyValueOffset);
            DynamicSizeUtil.putOffloadMarker(cursor);
            long offloadId = this.offloadStore.writeKeyValue(key, value, stableGeneration, unstableGeneration, cursorContext);
            DynamicSizeUtil.putOffloadId(cursor, offloadId);
        }
        DynamicSizeUtil.setAllocOffset(cursor, newKeyValueOffset);
        TreeNodeUtil.insertSlotsAt(cursor, pos, 1, keyCount, LeafNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        cursor.setOffset(LeafNodeDynamicSize.keyPosOffsetLeaf(pos));
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)newKeyValueOffset);
    }

    @Override
    public int removeKeyValueAt(PageCursor cursor, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            this.offloadStore.free(offloadId, stableGeneration, unstableGeneration, cursorContext);
        }
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        DynamicSizeUtil.setDeadSpace(cursor, deadSpace + keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize, offload));
        TreeNodeUtil.removeSlotAt(cursor, pos, keyCount, LeafNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        return keyCount - 1;
    }

    @Override
    public ValueHolder<VALUE> valueAt(PageCursor cursor, ValueHolder<VALUE> into, int pos, CursorContext cursorContext) throws IOException {
        this.placeCursorAtActualKey(cursor, pos);
        into.defined = true;
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                this.offloadStore.readValue(offloadId, into.value, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read value from offload, cause: " + e.getMessage());
            }
        } else {
            if (TreeNodeUtil.isUnreliableKeyValueSize(keySize, valueSize, this.keyValueSizeCap())) {
                TreeNodeUtil.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos, this.keyValueSizeCap());
                return into;
            }
            LeafNodeDynamicSize.progressCursor(cursor, keySize);
            this.layout.readValue(cursor, into.value, valueSize);
        }
        return into;
    }

    @Override
    public boolean setValueAt(PageCursor cursor, VALUE value, int pos, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        this.placeCursorAtActualKey(cursor, pos);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        int newValueSize = this.layout.valueSize(value);
        if (oldValueSize == newValueSize) {
            LeafNodeDynamicSize.progressCursor(cursor, keySize);
            this.layout.writeValue(cursor, value);
            return true;
        }
        return false;
    }

    static void progressCursor(PageCursor cursor, int delta) {
        cursor.setOffset(cursor.getOffset() + delta);
    }

    @Override
    public int keyValueSizeCap() {
        return this.keyValueSizeCap;
    }

    @Override
    public int inlineKeyValueSizeCap() {
        return this.inlineKeyValueSizeCap;
    }

    @Override
    public void validateKeyValueSize(KEY key, VALUE value) {
        int valueSize;
        int keySize = this.layout.keySize(key);
        if (this.keyValueSizeTooLarge(keySize, valueSize = this.layout.valueSize(value))) {
            throw new IllegalArgumentException("Index key-value size it too large. Please see index documentation for limitations.");
        }
    }

    @Override
    public int maxKeyCount() {
        return this.maxKeyCount;
    }

    @Override
    public boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    @Override
    public Overflow overflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue, CursorContext cursorContext) throws IOException {
        int neededSpace = this.totalSpaceOfKeyValue(newKey, newValue);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, LeafNodeDynamicSize.keyPosOffsetLeaf(currentKeyCount));
        return DynamicSizeUtil.calculateOverflow(neededSpace, deadSpace, allocSpace);
    }

    @Override
    public int availableSpace(PageCursor cursor, int currentKeyCount) {
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, LeafNodeDynamicSize.keyPosOffsetLeaf(currentKeyCount));
        return allocSpace + deadSpace;
    }

    @Override
    public int underflowThreshold() {
        return this.halfSpace;
    }

    @Override
    public int defragment(PageCursor cursor, int keyCount, CursorContext cursorContext) throws IOException {
        this.doDefragment(cursor, keyCount);
        return keyCount;
    }

    private void doDefragment(PageCursor cursor, int keyCount) {
        int[] offsets = new int[keyCount];
        int[] sizes = new int[keyCount];
        this.recordAliveBlocks(cursor, keyCount, offsets, sizes, this.payloadSize, true);
        DynamicSizeUtil.compactToRight(cursor, keyCount, offsets, sizes, this.payloadSize, LeafNodeDynamicSize::keyPosOffsetLeaf);
        DynamicSizeUtil.setDeadSpace(cursor, 0);
    }

    protected void recordAliveBlocks(PageCursor cursor, int keyCount, int[] offsets, int[] sizes, int payloadSize, boolean assertKeyCount) {
        DynamicSizeUtil.recordAliveBlocks(cursor, keyCount, offsets, sizes, payloadSize);
    }

    @Override
    public boolean underflow(PageCursor cursor, int keyCount) {
        int deadSpace;
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount));
        int availableSpace = allocSpace + (deadSpace = DynamicSizeUtil.getDeadSpace(cursor));
        return availableSpace > this.halfSpace;
    }

    @Override
    public int canRebalance(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int prevDelta;
        int lastChunkSize;
        int rightActiveSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount);
        if (leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount)) <= this.totalSpace) {
            return -1;
        }
        if (leftActiveSpace < rightActiveSpace) {
            return 0;
        }
        int currentDelta = Math.abs(leftActiveSpace - rightActiveSpace);
        int keysToMove = 0;
        do {
            lastChunkSize = this.totalSpaceOfKeyValue(leftCursor, leftKeyCount - ++keysToMove);
            prevDelta = currentDelta;
        } while ((currentDelta = Math.abs((leftActiveSpace -= lastChunkSize) - (rightActiveSpace += lastChunkSize))) < prevDelta);
        boolean canRebalance = (leftActiveSpace += lastChunkSize) > this.halfSpace && (rightActiveSpace -= lastChunkSize) > this.halfSpace;
        return canRebalance ? --keysToMove : 0;
    }

    @Override
    public boolean canMerge(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int rightActiveSpace;
        int totalSpace = this.totalSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount);
        return totalSpace >= leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount));
    }

    @Override
    public int findSplitter(PageCursor cursor, int keyCount, KEY newKey, VALUE newValue, int insertPos, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        KEY rightInSplit;
        Object leftInSplit;
        int keyCountAfterInsert = keyCount + 1;
        int splitPos = this.splitPosInLeaf(cursor, insertPos, newKey, newValue, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            leftInSplit = this.keyAt(cursor, this.layout.newKey(), splitPos - 1, cursorContext);
            rightInSplit = newKey;
        } else {
            int rightPos = insertPos < splitPos ? splitPos - 1 : splitPos;
            rightInSplit = this.keyAt(cursor, this.layout.newKey(), rightPos, cursorContext);
            if (rightPos == insertPos) {
                leftInSplit = newKey;
            } else {
                int leftPos = rightPos - 1;
                leftInSplit = this.keyAt(cursor, this.layout.newKey(), leftPos, cursorContext);
            }
        }
        this.layout.minimalSplitter(leftInSplit, rightInSplit, newSplitter);
        return splitPos;
    }

    @Override
    public void doSplit(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, int splitPos, double ratioToKeepInLeftOnSplit, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int rightKeyCount = keyCountAfterInsert - splitPos;
        if (insertPos < splitPos) {
            this.moveKeysAndValues(leftCursor, splitPos - 1, rightCursor, 0, rightKeyCount);
            this.doDefragment(leftCursor, splitPos - 1);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else {
            int newInsertPos = insertPos - splitPos;
            int keysToMove = leftKeyCount - splitPos;
            this.moveKeysAndValues(leftCursor, splitPos, rightCursor, 0, keysToMove);
            this.doDefragment(leftCursor, splitPos);
            this.insertKeyValueAt(rightCursor, newKey, newValue, newInsertPos, keysToMove, stableGeneration, unstableGeneration, cursorContext);
        }
        TreeNodeUtil.setKeyCount(leftCursor, splitPos);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    public void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode, CursorContext cursorContext) {
        this.doDefragment(rightCursor, rightKeyCount);
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        TreeNodeUtil.insertSlotsAt(rightCursor, 0, numberOfKeysToMove, rightKeyCount, LeafNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        this.moveKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    private void moveKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int firstAllocOffset;
        int toAllocOffset = firstAllocOffset = DynamicSizeUtil.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.copyRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset, true);
            toCursor.setOffset(LeafNodeDynamicSize.keyPosOffsetLeaf(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        DynamicSizeUtil.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = DynamicSizeUtil.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        DynamicSizeUtil.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        TreeNodeUtil.setKeyCount(fromCursor, fromPos);
    }

    protected int copyRawKeyValue(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset, boolean markDead) {
        this.placeCursorAtActualKey(fromCursor, fromPos);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
        int newRightAllocSpace = toAllocOffset - toCopy;
        fromCursor.copyTo(fromKeyOffset, toCursor, newRightAllocSpace, toCopy);
        if (markDead) {
            fromCursor.setOffset(fromKeyOffset);
            DynamicSizeUtil.putTombstone(fromCursor);
        }
        return newRightAllocSpace;
    }

    @Override
    public void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, CursorContext cursorContext) {
        this.doDefragment(rightCursor, rightKeyCount);
        TreeNodeUtil.insertSlotsAt(rightCursor, 0, leftKeyCount, rightKeyCount, LeafNodeDynamicSize.keyPosOffsetLeaf(0), 2);
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int toAllocOffset = DynamicSizeUtil.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.copyRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset, false);
            toCursor.setOffset(LeafNodeDynamicSize.keyPosOffsetLeaf(toPos));
            PageCursorUtil.putUnsignedShort((PageCursor)toCursor, (int)toAllocOffset);
            ++i;
            ++toPos;
        }
        DynamicSizeUtil.setAllocOffset(toCursor, toAllocOffset);
    }

    private int splitPosInLeaf(PageCursor cursor, int insertPos, KEY newKey, VALUE newValue, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = 0;
        int currentDelta = targetLeftSpace;
        int spaceOfNewKey = this.totalSpaceOfKeyValue(newKey, newValue);
        int totalSpaceIncludingNewKey = this.totalActiveSpace(cursor, keyCountAfterInsert - 1) + spaceOfNewKey;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        if (totalSpaceIncludingNewKey > this.totalSpace * 2) {
            throw new IllegalStateException(String.format("There's not enough space to insert new key, even when splitting the leaf. Space needed:%d, max space allowed:%d", totalSpaceIncludingNewKey, this.totalSpace * 2));
        }
        do {
            int currentSpace;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos && !includedNew) {
                currentSpace = spaceOfNewKey;
                includedNew = true;
                --currentPos;
            } else {
                currentSpace = this.totalSpaceOfKeyValue(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += currentSpace) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKey - accumulatedLeftSpace <= this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace <= this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int totalActiveSpace(PageCursor cursor, int keyCount) {
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        int allocSpace = DynamicSizeUtil.getAllocSpace(cursor, LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount));
        return this.totalSpace - deadSpace - allocSpace;
    }

    @Override
    public int totalSpaceOfKeyValue(KEY key, VALUE value) {
        int valueSize;
        int keySize = this.layout.keySize(key);
        boolean canInline = this.canInline(keySize + (valueSize = this.layout.valueSize(value)));
        if (canInline) {
            return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, false) + keySize + valueSize;
        }
        return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, true);
    }

    @Override
    protected int totalSpaceOfKeyValue(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        return 2 + DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
    }

    void placeCursorAtActualKey(PageCursor cursor, int pos) {
        int keyPosOffset = LeafNodeDynamicSize.keyPosOffsetLeaf(pos);
        DynamicSizeUtil.redirectCursor(cursor, keyPosOffset, 86, this.payloadSize);
    }

    boolean keyValueSizeTooLarge(int keySize, int valueSize) {
        return keySize + valueSize > this.keyValueSizeCap;
    }

    protected static int keyPosOffsetLeaf(int pos) {
        return 86 + pos * 2;
    }

    public String toString() {
        return "TreeNodeDynamicSize[pageSize:" + this.payloadSize + ", keyValueSizeCap:" + this.keyValueSizeCap + ", inlineKeyValueSizeCap:" + this.inlineKeyValueSizeCap + "]";
    }

    private String asString(PageCursor cursor, boolean includeValue, boolean includeAllocSpace) {
        int currentOffset = cursor.getOffset();
        int allocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        int deadSpace = DynamicSizeUtil.getDeadSpace(cursor);
        String additionalHeader = "{" + cursor.getCurrentPageId() + "} [allocOffset=" + allocOffset + " deadSpace=" + deadSpace + "] ";
        String offsetArray = this.readOffsetArray(cursor);
        String allocSpace = "";
        if (includeAllocSpace) {
            allocSpace = this.readAllocSpace(cursor, allocOffset);
        }
        Object readKey = this.layout.newKey();
        VALUE readValue = this.layout.newValue();
        StringJoiner keys = new StringJoiner(" ");
        cursor.setOffset(allocOffset);
        while (cursor.getOffset() < cursor.getPagedFile().payloadSize()) {
            StringJoiner singleKey = new StringJoiner("|");
            singleKey.add(Integer.toString(cursor.getOffset()));
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            if (DynamicSizeUtil.extractTombstone(keyValueSize)) {
                singleKey.add("T");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                singleKey.add("O");
            } else {
                singleKey.add("_");
            }
            if (offload) {
                long offloadId = DynamicSizeUtil.readOffloadId(cursor);
                singleKey.add(Long.toString(offloadId));
            } else {
                this.layout.readKey(cursor, readKey, keySize);
                this.layout.readValue(cursor, readValue, valueSize);
                singleKey.add(Integer.toString(keySize));
                if (includeValue) {
                    singleKey.add(Integer.toString(valueSize));
                }
                singleKey.add(readKey.toString());
                if (includeValue) {
                    singleKey.add(readValue.toString());
                }
            }
            keys.add(singleKey.toString());
        }
        cursor.setOffset(currentOffset);
        return additionalHeader + offsetArray + " " + allocSpace + " " + String.valueOf(keys);
    }

    @Override
    public void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        System.out.println(this.asString(cursor, includeValue, includeAllocSpace));
    }

    @Override
    public String checkMetaConsistency(PageCursor cursor) {
        int keyCount;
        int offsetArray;
        long nodeId = cursor.getCurrentPageId();
        StringJoiner joiner = new StringJoiner(", ", "Meta data for tree node is inconsistent, id=" + nodeId + ": ", "");
        boolean hasInconsistency = false;
        int allocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        if (allocOffset < (offsetArray = LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount = TreeNodeUtil.keyCount(cursor)))) {
            joiner.add(String.format("Overlap between offsetArray and allocSpace, offsetArray=%d, allocOffset=%d", offsetArray, allocOffset));
            return joiner.toString();
        }
        if (this.reasonableKeyCount(keyCount)) {
            int lowestActiveKeyOffset;
            int allocSpace;
            int deadSpace;
            int activeSpace = this.totalActiveSpaceRaw(cursor, keyCount);
            if (activeSpace + (deadSpace = DynamicSizeUtil.getDeadSpace(cursor)) + (allocSpace = DynamicSizeUtil.getAllocSpace(cursor, LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount))) != this.totalSpace) {
                hasInconsistency = true;
                joiner.add(String.format("Space areas did not sum to total space; activeSpace=%d, deadSpace=%d, allocSpace=%d, totalSpace=%d", activeSpace, deadSpace, allocSpace, this.totalSpace));
            }
            if ((lowestActiveKeyOffset = LeafNodeDynamicSize.lowestActiveKeyOffset(cursor, keyCount, this.payloadSize)) < allocOffset) {
                hasInconsistency = true;
                joiner.add(String.format("Overlap between allocSpace and active keys, allocOffset=%d, lowestActiveKeyOffset=%d", allocOffset, lowestActiveKeyOffset));
            }
        }
        if (allocOffset < this.payloadSize && allocOffset >= 0) {
            cursor.setOffset(allocOffset);
            long keyValueAtAllocOffset = DynamicSizeUtil.readKeyValueSize(cursor);
            if (keyValueAtAllocOffset == 0L) {
                hasInconsistency = true;
                joiner.add(String.format("Pointer to allocSpace is misplaced, it should point to start of key, allocOffset=%d", allocOffset));
            }
        }
        if (hasInconsistency) {
            return joiner.toString();
        }
        return "";
    }

    @Override
    public <ROOT_KEY> void deepVisitValue(PageCursor cursor, int pos, GBPTreeVisitor<ROOT_KEY, KEY, VALUE> visitor) {
    }

    protected static int lowestActiveKeyOffset(PageCursor cursor, int keyCount, int payloadSize) {
        int lowestOffsetSoFar = payloadSize;
        for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = LeafNodeDynamicSize.keyPosOffsetLeaf(pos);
            cursor.setOffset(keyPosOffset);
            int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            lowestOffsetSoFar = Math.min(lowestOffsetSoFar, keyOffset);
        }
        return lowestOffsetSoFar;
    }

    private int totalActiveSpaceRaw(PageCursor cursor, int keyCount) {
        int offsetArrayStart = 86;
        int offsetArrayEnd = LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount);
        int offsetArraySize = offsetArrayEnd - offsetArrayStart;
        int aliveKeySize = 0;
        int nextKeyOffset = DynamicSizeUtil.getAllocOffset(cursor);
        while (nextKeyOffset < this.payloadSize) {
            cursor.setOffset(nextKeyOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            boolean tombstone = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (!tombstone) {
                aliveKeySize += DynamicSizeUtil.getOverhead(keySize, valueSize, offload) + keySize + valueSize;
            }
            nextKeyOffset = cursor.getOffset() + (offload ? 8 : keySize + valueSize);
        }
        return offsetArraySize + aliveKeySize;
    }

    private String readAllocSpace(PageCursor cursor, int allocOffset) {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        int endOfOffsetArray = LeafNodeDynamicSize.keyPosOffsetLeaf(keyCount);
        cursor.setOffset(endOfOffsetArray);
        int bytesToRead = allocOffset - endOfOffsetArray;
        byte[] allocSpace = new byte[bytesToRead];
        cursor.getBytes(allocSpace);
        for (byte b : allocSpace) {
            if (b == 0) continue;
            return "v" + endOfOffsetArray + ">" + bytesToRead + "|" + Arrays.toString(allocSpace);
        }
        return "v" + endOfOffsetArray + ">" + bytesToRead + "|[0...]";
    }

    private String readOffsetArray(PageCursor cursor) {
        int keyCount = TreeNodeUtil.keyCount(cursor);
        StringJoiner offsetArray = new StringJoiner(" ");
        for (int i = 0; i < keyCount; ++i) {
            cursor.setOffset(LeafNodeDynamicSize.keyPosOffsetLeaf(i));
            offsetArray.add(Integer.toString(PageCursorUtil.getUnsignedShort((PageCursor)cursor)));
        }
        return offsetArray.toString();
    }

    private boolean canInline(int entrySize) {
        return entrySize <= this.inlineKeyValueSizeCap;
    }
}

