/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.AbstractTracker;

public class BigIdTracker
extends AbstractTracker<ByteArray> {
    static final int SIZE = 5;
    static final int ID_BITS = 39;
    static final byte[] DEFAULT_VALUE;
    public static final long MAX_ID = 0x4000000000L;
    private static final LongBitsManipulator BITS;

    public BigIdTracker(ByteArray array) {
        super(array);
    }

    @Override
    public long get(long index) {
        return BITS.get(((ByteArray)this.array).get5ByteLong(index, 0), 0);
    }

    @Override
    public void set(long index, long value) {
        long field = ((ByteArray)this.array).get5ByteLong(index, 0);
        field = BITS.set(field, 0, value);
        ((ByteArray)this.array).set5ByteLong(index, 0, field);
    }

    @Override
    public void markAsDuplicate(long index) {
        long field = ((ByteArray)this.array).get5ByteLong(index, 0);
        field = BITS.set(field, 1, 0L);
        ((ByteArray)this.array).set5ByteLong(index, 0, field);
    }

    @Override
    public boolean isMarkedAsDuplicate(long index) {
        long field = ((ByteArray)this.array).get5ByteLong(index, 0);
        return BITS.get(field, 1) == 0L;
    }

    static {
        BITS = new LongBitsManipulator(39, 1);
        DEFAULT_VALUE = new byte[5];
        Arrays.fill(DEFAULT_VALUE, (byte)-1);
    }
}

