/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.store.Directory;
import org.neo4j.internal.helpers.collection.NumberAwareStringComparator;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.FailureStorage;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;

public class PartitionedIndexStorage {
    private static final Comparator<Path> FILE_COMPARATOR = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getFileName().toString(), o2.getFileName().toString());
    private final DirectoryFactory directoryFactory;
    private final FileSystemAbstraction fileSystem;
    private final FolderLayout folderLayout;
    private final FailureStorage failureStorage;

    public PartitionedIndexStorage(DirectoryFactory directoryFactory, FileSystemAbstraction fileSystem, Path rootFolder) {
        this.fileSystem = fileSystem;
        this.folderLayout = new IndexFolderLayout(rootFolder);
        this.directoryFactory = directoryFactory;
        this.failureStorage = new FailureStorage(fileSystem, this.folderLayout);
    }

    public Directory openDirectory(Path folder) throws IOException {
        return this.directoryFactory.open(folder);
    }

    public Path getPartitionFolder(int partition) {
        return this.folderLayout.getPartitionFolder(partition);
    }

    public Path getIndexFolder() {
        return this.folderLayout.getIndexFolder();
    }

    public void reserveIndexFailureStorage() throws IOException {
        this.failureStorage.reserveForIndex();
    }

    public void storeIndexFailure(String failure) throws IOException {
        this.failureStorage.storeIndexFailure(failure);
    }

    public String getStoredIndexFailure() {
        return this.failureStorage.loadIndexFailure();
    }

    public Path getIndexFailureFile() {
        return this.failureStorage.failureFile();
    }

    public void prepareFolder(Path folder) throws IOException {
        this.cleanupFolder(folder);
        this.fileSystem.mkdirs(folder);
    }

    public void cleanupFolder(Path folder) throws IOException {
        if (!this.fileSystem.fileExists(folder)) {
            return;
        }
        List<Path> partitionFolders = this.listFolders(folder);
        if (!partitionFolders.isEmpty()) {
            for (Path partitionFolder : partitionFolders) {
                this.cleanupLuceneDirectory(partitionFolder);
            }
        }
        this.fileSystem.deleteRecursively(folder);
    }

    public Map<Path, Directory> openIndexDirectories() throws IOException {
        LinkedHashMap<Path, Directory> directories = new LinkedHashMap<Path, Directory>();
        try {
            for (Path dir : this.listFolders()) {
                directories.put(dir, this.directoryFactory.open(dir));
            }
        }
        catch (IOException oe) {
            try {
                IOUtils.closeAll(directories.values());
            }
            catch (Exception ce) {
                oe.addSuppressed(ce);
            }
            throw oe;
        }
        return directories;
    }

    public List<Path> listFolders() throws IOException {
        return this.listFolders(this.getIndexFolder());
    }

    private List<Path> listFolders(Path rootFolder) throws IOException {
        if (!this.fileSystem.fileExists(rootFolder)) {
            return Collections.emptyList();
        }
        return Stream.of(this.fileSystem.listFiles(rootFolder)).filter(f -> this.fileSystem.isDirectory(f) && StringUtils.isNumeric((CharSequence)f.getFileName().toString())).sorted(FILE_COMPARATOR).toList();
    }

    private void cleanupLuceneDirectory(Path folder) throws IOException {
        try (Directory dir = this.directoryFactory.open(folder);){
            String[] indexFiles;
            for (String indexFile : indexFiles = dir.listAll()) {
                FileUtils.windowsSafeIOOperation(() -> dir.deleteFile(indexFile));
            }
        }
    }

    public long sizeInBytes() {
        return FileSystemUtils.size((FileSystemAbstraction)this.fileSystem, (Path)this.folderLayout.getIndexFolder());
    }
}

