/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class EmbeddedEntityAdapter {
    public boolean isPath(Object value) {
        return value instanceof Path;
    }

    public boolean isNode(Object value) {
        return value instanceof Node;
    }

    public boolean isRelationship(Object value) {
        return value instanceof Relationship;
    }

    public long nodeId(Object node) {
        return ((Node)node).getId();
    }

    public List<String> labels(Object node) {
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : ((Node)node).getLabels()) {
            labels.add(label.name());
        }
        return labels;
    }

    public long relationshipId(Object relationship) {
        return ((Relationship)relationship).getId();
    }

    public String relationshipType(Object relationship) {
        return ((Relationship)relationship).getType().name();
    }

    public Long startNodeId(Object relationship) {
        return ((Relationship)relationship).getStartNode().getId();
    }

    public Long endNodeId(Object relationship) {
        return ((Relationship)relationship).getEndNode().getId();
    }

    public Map<String, Object> properties(Object container) {
        return EmbeddedEntityAdapter.getAllProperties((PropertyContainer)container);
    }

    public List<Object> nodesInPath(Object path) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Node node : ((Path)path).nodes()) {
            nodes.add(node);
        }
        return nodes;
    }

    public List<Object> relsInPath(Object path) {
        ArrayList<Object> rels = new ArrayList<Object>();
        for (Relationship rel : ((Path)path).relationships()) {
            rels.add(rel);
        }
        return rels;
    }

    public static Map<String, Object> getAllProperties(PropertyContainer propertyContainer) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : propertyContainer.getPropertyKeys()) {
            properties.put(key, propertyContainer.getProperty(key));
        }
        return properties;
    }
}

