/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.string.Mask;

final class RelationshipEndpointLabelConstraintDescriptorImplementation
implements RelationshipEndpointLabelConstraintDescriptor {
    private final long id;
    private final int endpointLabelId;
    private final String name;
    private final RelationshipEndpointLabelSchemaDescriptor schema;
    private final EndpointType endpointType;

    RelationshipEndpointLabelConstraintDescriptorImplementation(RelationshipEndpointLabelSchemaDescriptor schema, long id, int endpointLabelId, String name, EndpointType endpointType) {
        if (endpointLabelId < 0) {
            throw new IllegalArgumentException("endpointLabelId cannot be negative");
        }
        this.schema = Objects.requireNonNull(schema, "SchemaDescriptor cannot be null");
        this.endpointType = Objects.requireNonNull(endpointType, "EndpointType cannot be null");
        this.id = id;
        this.endpointLabelId = endpointLabelId;
        this.name = name;
    }

    static RelationshipEndpointLabelConstraintDescriptor make(RelationshipEndpointLabelSchemaDescriptor schema, int endpointLabelId, EndpointType endpointType) {
        return new RelationshipEndpointLabelConstraintDescriptorImplementation(schema, -1L, endpointLabelId, null, endpointType);
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public ConstraintType type() {
        return ConstraintType.RELATIONSHIP_ENDPOINT_LABEL;
    }

    @Override
    public GraphTypeDependence graphTypeDependence() {
        return GraphTypeDependence.DEPENDENT;
    }

    @Override
    public boolean enforcesUniqueness() {
        return false;
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return false;
    }

    @Override
    public boolean enforcesPropertyType() {
        return false;
    }

    @Override
    public boolean isPropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipEndpointLabelConstraint() {
        return true;
    }

    @Override
    public boolean isNodeLabelExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isNodePropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyTypeConstraint() {
        return false;
    }

    @Override
    public TypeConstraintDescriptor asPropertyTypeConstraint() {
        throw this.conversionException(TypeConstraintDescriptor.class);
    }

    @Override
    public boolean isPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return false;
    }

    @Override
    public ExistenceConstraintDescriptor asPropertyExistenceConstraint() {
        throw this.conversionException(ExistenceConstraintDescriptor.class);
    }

    @Override
    public boolean isUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isNodeUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipUniquenessConstraint() {
        return false;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        throw this.conversionException(UniquenessConstraintDescriptor.class);
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipKeyConstraint() {
        return false;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return false;
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        throw this.conversionException(IndexBackedConstraintDescriptor.class);
    }

    @Override
    public boolean isKeyConstraint() {
        return false;
    }

    @Override
    public KeyConstraintDescriptor asKeyConstraint() {
        throw this.conversionException(KeyConstraintDescriptor.class);
    }

    @Override
    public RelationshipEndpointLabelConstraintDescriptor withId(long newId) {
        return new RelationshipEndpointLabelConstraintDescriptorImplementation(this.schema, newId, this.endpointLabelId, this.name, this.endpointType);
    }

    @Override
    public RelationshipEndpointLabelConstraintDescriptor withName(String newName) {
        if (newName == null) {
            return this;
        }
        newName = SchemaNameUtil.sanitiseName(newName);
        return new RelationshipEndpointLabelConstraintDescriptorImplementation(this.schema, this.id, this.endpointLabelId, newName, this.endpointType);
    }

    @Override
    public IndexBackedConstraintDescriptor withOwnedIndexId(long id) {
        throw new NotImplementedException();
    }

    @Override
    public RelationshipEndpointLabelConstraintDescriptor asRelationshipEndpointLabelConstraint() {
        return this;
    }

    @Override
    public NodeLabelExistenceConstraintDescriptor asNodeLabelExistenceConstraint() {
        throw this.conversionException(NodeLabelExistenceConstraintDescriptor.class);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RelationshipEndpointLabelConstraintDescriptor)) {
            return false;
        }
        RelationshipEndpointLabelConstraintDescriptor that = (RelationshipEndpointLabelConstraintDescriptor)o;
        if (this.endpointType != that.endpointType()) {
            return false;
        }
        if (this.endpointLabelId != that.endpointLabelId()) {
            return false;
        }
        return this.schema().equals(that.schema());
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + this);
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int endpointLabelId() {
        return this.endpointLabelId;
    }

    public String toString() {
        return this.toString(Mask.NO);
    }

    public String toString(Mask mask) {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, mask);
    }

    private String userDescription(TokenNameLookup tokenNameLookup, Mask mask) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, ConstraintType.RELATIONSHIP_ENDPOINT_LABEL, this.schema, null, null, null, mask);
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + targetType + " because it does not match that structure: " + this + ".");
    }

    @Override
    public EndpointType endpointType() {
        return this.endpointType;
    }
}

