/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.UUID;
import org.neo4j.common.EntityType;

public abstract class ElementIdMapper {
    protected static byte ELEMENT_ID_FORMAT_VERSION = 1;

    public static ElementId decode(String id, EntityType expectedType) {
        ElementId elementId = ElementIdMapper.decode(id);
        ElementIdMapper.verifyEntityType(id, elementId.entityType, expectedType);
        return elementId;
    }

    public static ElementId decode(String id) {
        try {
            String[] parts = ElementIdMapper.readParts(id);
            byte header = Byte.parseByte(parts[0]);
            ElementIdMapper.verifyVersion(id, header);
            UUID databaseId = UUID.fromString(parts[1]);
            long entityId = Long.parseLong(parts[2]);
            EntityType entityType = ElementIdMapper.decodeEntityType(id, header);
            return new ElementId(databaseId, entityId, entityType);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id), e);
        }
    }

    private static String[] readParts(String id) {
        String[] parts = id.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id));
        }
        return parts;
    }

    private static void verifyVersion(String id, byte header) {
        byte version = (byte)(header >>> 2);
        if (version != ELEMENT_ID_FORMAT_VERSION) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected version %d", id, version));
        }
    }

    private static EntityType decodeEntityType(String id, byte header) {
        byte entityTypeId = (byte)(header & 3);
        return switch (entityTypeId) {
            case 0 -> EntityType.NODE;
            case 1 -> EntityType.RELATIONSHIP;
            default -> throw new IllegalArgumentException(String.format("Element ID %s has unknown entity type ID %s", id, entityTypeId));
        };
    }

    private static void verifyEntityType(String id, EntityType actual, EntityType expected) {
        if (actual != expected) {
            throw new IllegalArgumentException(String.format("Element ID %s has unexpected entity type %s, was expecting %s", id, actual, expected));
        }
    }

    public abstract String nodeElementId(long var1);

    public abstract long nodeId(String var1);

    public abstract String relationshipElementId(long var1);

    public abstract long relationshipId(String var1);

    public record ElementId(UUID databaseId, long entityId, EntityType entityType) {
    }
}

