/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.vertx.core.dns.impl.netty.DnsEntry;

public class DnsResource
extends DnsEntry
implements ByteBufHolder {
    private final int contentIndex;
    private final long ttl;
    private final ByteBuf content;

    public DnsResource(String name, int type, int aClass, long ttl, int contentIndex, ByteBuf content) {
        super(name, type, aClass);
        this.ttl = ttl;
        this.contentIndex = contentIndex;
        this.content = content;
    }

    public long timeToLive() {
        return this.ttl;
    }

    public int contentIndex() {
        return this.contentIndex;
    }

    public int contentLength() {
        return this.content.writerIndex() - this.content.readerIndex();
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public DnsResource copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public DnsResource duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public DnsResource retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public DnsResource replace(ByteBuf content) {
        return new DnsResource(this.name(), this.type(), this.dnsClass(), this.ttl, this.contentIndex, content);
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public DnsResource retain() {
        this.content.retain();
        return this;
    }

    @Override
    public DnsResource retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        this.content.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }
}

