/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.AsyncResultHandler;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerRequestStream;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.ServerWebSocketStream;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerConnection;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.VertxHttpResponseEncoder;
import io.vertx.core.http.impl.cgbystrom.FlashPolicyHandler;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.streams.ReadStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class HttpServerImpl
implements HttpServer,
Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private static final String FLASH_POLICY_HANDLER_PROP_NAME = "vertx.flashPolicyHandler";
    private static final boolean USE_FLASH_POLICY_HANDLER = Boolean.getBoolean("vertx.flashPolicyHandler");
    private static final String DISABLE_WEBSOCKETS_PROP_NAME = "vertx.disableWebsockets";
    private static final boolean DISABLE_WEBSOCKETS = Boolean.getBoolean("vertx.disableWebsockets");
    private static final String DISABLE_H2C_PROP_NAME = "vertx.disableH2c";
    private final boolean DISABLE_HC2 = Boolean.getBoolean("vertx.disableH2c");
    private static final String[] H2C_HANDLERS_TO_REMOVE = new String[]{"idle", "flashpolicy", "deflater", "chunkwriter"};
    private static final byte[] HTTP_2_PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes();
    private final HttpServerOptions options;
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final ContextImpl creatingContext;
    private final Map<Channel, ServerConnection> connectionMap = new ConcurrentHashMap<Channel, ServerConnection>();
    private final Map<Channel, Http2ServerConnection> connectionMap2 = new ConcurrentHashMap<Channel, Http2ServerConnection>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<HttpHandler> reqHandlerManager = new HandlerManager(this.availableWorkers);
    private final HandlerManager<Handler<ServerWebSocket>> wsHandlerManager = new HandlerManager(this.availableWorkers);
    private final ServerWebSocketStreamImpl wsStream = new ServerWebSocketStreamImpl();
    private final HttpServerRequestStreamImpl requestStream = new HttpServerRequestStreamImpl();
    private Handler<HttpConnection> connectionHandler;
    private final String subProtocols;
    private String serverOrigin;
    private ChannelGroup serverChannelGroup;
    private volatile boolean listening;
    private AsyncResolveConnectHelper bindFuture;
    private ServerID id;
    private HttpServerImpl actualServer;
    private volatile int actualPort;
    private ContextImpl listenContext;
    private HttpServerMetrics metrics;
    private boolean logEnabled;

    public HttpServerImpl(VertxInternal vertx, HttpServerOptions options) {
        this.options = new HttpServerOptions(options);
        this.vertx = vertx;
        this.creatingContext = vertx.getContext();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.subProtocols = options.getWebsocketSubProtocols();
        this.logEnabled = options.getLogActivity();
    }

    @Override
    public synchronized HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.requestStream.handler(handler);
        return this;
    }

    @Override
    public HttpServerRequestStream requestStream() {
        return this.requestStream;
    }

    @Override
    public HttpServer websocketHandler(Handler<ServerWebSocket> handler) {
        this.websocketStream().handler((Handler)handler);
        return this;
    }

    @Override
    public Handler<HttpServerRequest> requestHandler() {
        return this.requestStream.handler();
    }

    @Override
    public synchronized HttpServer connectionHandler(Handler<HttpConnection> handler) {
        if (this.listening) {
            throw new IllegalStateException("Please set handler before server is listening");
        }
        this.connectionHandler = handler;
        return this;
    }

    @Override
    public Handler<ServerWebSocket> websocketHandler() {
        return this.wsStream.handler();
    }

    @Override
    public ServerWebSocketStream websocketStream() {
        return this.wsStream;
    }

    @Override
    public HttpServer listen() {
        return this.listen(this.options.getPort(), this.options.getHost(), null);
    }

    @Override
    public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public HttpServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public HttpServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        if (this.requestStream.handler() == null && this.wsStream.handler() == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Already listening");
        }
        this.listenContext = this.vertx.getOrCreateContext();
        this.listening = true;
        this.serverOrigin = (this.options.isSsl() ? "https" : "http") + "://" + host + ":" + port;
        List<HttpVersion> applicationProtocols = this.options.getAlpnVersions();
        if (this.listenContext.isWorkerContext()) {
            applicationProtocols = applicationProtocols.stream().filter(v -> v != HttpVersion.HTTP_2).collect(Collectors.toList());
        }
        this.sslHelper.setApplicationProtocols(applicationProtocols);
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            this.actualPort = port;
            this.id = new ServerID(port, host);
            HttpServerImpl shared = this.vertx.sharedHttpServers().get(this.id);
            if (shared == null || port == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.availableWorkers);
                bootstrap.channel(NioServerSocketChannel.class);
                this.applyConnectionOptions(bootstrap);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(final Channel ch) throws Exception {
                        if (HttpServerImpl.this.requestStream.isPaused() || HttpServerImpl.this.wsStream.isPaused()) {
                            ch.close();
                            return;
                        }
                        final ChannelPipeline pipeline = ch.pipeline();
                        if (HttpServerImpl.this.sslHelper.isSSL()) {
                            pipeline.addLast("ssl", (ChannelHandler)HttpServerImpl.this.sslHelper.createSslHandler(HttpServerImpl.this.vertx));
                            if (HttpServerImpl.this.options.isUseAlpn()) {
                                pipeline.addLast("alpn", (ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

                                    @Override
                                    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
                                        if (protocol.equals("http/1.1")) {
                                            HttpServerImpl.this.configureHttp1(pipeline);
                                        } else {
                                            HttpServerImpl.this.handleHttp2(ch);
                                        }
                                    }
                                });
                            } else {
                                HttpServerImpl.this.configureHttp1(pipeline);
                            }
                        } else if (HttpServerImpl.this.DISABLE_HC2) {
                            HttpServerImpl.this.configureHttp1(pipeline);
                        } else {
                            pipeline.addLast(new Http1xOrHttp2Handler());
                        }
                    }
                });
                this.addHandlers(this, this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, port, host, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.failed()) {
                            this.vertx.sharedHttpServers().remove(this.id);
                        } else {
                            Channel serverChannel = (Channel)res.result();
                            this.actualPort = ((InetSocketAddress)serverChannel.localAddress()).getPort();
                            this.serverChannelGroup.add(serverChannel);
                            this.metrics = this.vertx.metricsSPI().createMetrics(this, (SocketAddress)new SocketAddressImpl(port, host), this.options);
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return this;
                }
                this.vertx.sharedHttpServers().put(this.id, this);
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort;
                this.addHandlers(this.actualServer, this.listenContext);
                this.metrics = this.vertx.metricsSPI().createMetrics(this, (SocketAddress)new SocketAddressImpl(port, host), this.options);
            }
            this.actualServer.bindFuture.addListener(future -> {
                if (listenHandler != null) {
                    Future<HttpServerImpl> res;
                    if (future.succeeded()) {
                        res = Future.succeededFuture(this);
                    } else {
                        res = Future.failedFuture(future.cause());
                        this.listening = false;
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(res));
                } else if (future.failed()) {
                    this.listening = false;
                    log.error(future.cause());
                }
            });
        }
        return this;
    }

    private VertxHttp2ConnectionHandler<Http2ServerConnection> createHttp2Handler(HandlerHolder<HttpHandler> holder, Channel ch) {
        return ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder<Http2ServerConnection>().connectionMap(this.connectionMap2).server(true)).useCompression(this.options.isCompressionSupported()).initialSettings(this.options.getInitialSettings()).connectionFactory(connHandler -> new Http2ServerConnection(ch, holder.context, this.serverOrigin, (VertxHttp2ConnectionHandler)connHandler, this.options, ((HttpHandler)holder.handler).requesthHandler, this.metrics)).logEnabled(this.logEnabled).build();
    }

    private void configureHttp1(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (USE_FLASH_POLICY_HANDLER) {
            pipeline.addLast("flashpolicy", (ChannelHandler)new FlashPolicyHandler());
        }
        pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder(this.options.getMaxInitialLineLength(), this.options.getMaxHeaderSize(), this.options.getMaxChunkSize(), false));
        pipeline.addLast("httpEncoder", (ChannelHandler)new VertxHttpResponseEncoder());
        if (this.options.isCompressionSupported()) {
            pipeline.addLast("deflater", (ChannelHandler)new HttpChunkContentCompressor());
        }
        if (this.sslHelper.isSSL() || this.options.isCompressionSupported()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
        pipeline.addLast("handler", (ChannelHandler)new ServerHandler(pipeline.channel()));
    }

    public void handleHttp2(Channel ch) {
        HandlerHolder<HttpHandler> holder = this.reqHandlerManager.chooseHandler(ch.eventLoop());
        VertxHttp2ConnectionHandler<Http2ServerConnection> handler = this.createHttp2Handler(holder, ch);
        this.configureHttp2(ch.pipeline(), handler);
        if (((HttpHandler)holder.handler).connectionHandler != null) {
            holder.context.executeFromIO(() -> ((HttpHandler)holder.handler).connectionHandler.handle((HttpConnection)handler.connection));
        }
    }

    public void configureHttp2(ChannelPipeline pipeline, VertxHttp2ConnectionHandler<Http2ServerConnection> handler) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
        pipeline.addLast("handler", handler);
        if (this.options.getHttp2ConnectionWindowSize() > 0) {
            ((Http2ServerConnection)handler.connection).setWindowSize(this.options.getHttp2ConnectionWindowSize());
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> done) {
        if (this.wsStream.endHandler() != null || this.requestStream.endHandler() != null) {
            final Handler<Void> wsEndHandler = this.wsStream.endHandler();
            this.wsStream.endHandler(null);
            final Handler<Void> requestEndHandler = this.requestStream.endHandler();
            this.requestStream.endHandler(null);
            final AsyncResultHandler<Void> next = done;
            done = new AsyncResultHandler<Void>(){

                @Override
                public void handle(AsyncResult<Void> event) {
                    if (event.succeeded()) {
                        if (wsEndHandler != null) {
                            wsEndHandler.handle(event.result());
                        }
                        if (requestEndHandler != null) {
                            requestEndHandler.handle(event.result());
                        }
                    }
                    if (next != null) {
                        next.handle(event);
                    }
                }
            };
        }
        ContextImpl context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            this.executeCloseDone(context, done, null);
            return;
        }
        this.listening = false;
        Map<ServerID, HttpServerImpl> map = this.vertx.sharedHttpServers();
        synchronized (map) {
            if (this.actualServer != null) {
                if (this.requestStream.handler() != null) {
                    this.actualServer.reqHandlerManager.removeHandler(new HttpHandler(this.requestStream.handler(), this.connectionHandler), this.listenContext);
                }
                if (this.wsStream.handler() != null) {
                    this.actualServer.wsHandlerManager.removeHandler(this.wsStream.handler(), this.listenContext);
                }
                if (this.actualServer.reqHandlerManager.hasHandlers() || this.actualServer.wsHandlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, (Handler<AsyncResult<Void>>)done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, (Handler<AsyncResult<Void>>)done);
                }
            }
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    public SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    void removeChannel(Channel channel) {
        this.connectionMap.remove(channel);
    }

    private void applyConnectionOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, this.options.getReceiveBufferSize());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        if (this.options.getSoLinger() != -1) {
            bootstrap.option(ChannelOption.SO_LINGER, this.options.getSoLinger());
        }
        if (this.options.getTrafficClass() != -1) {
            bootstrap.childOption(ChannelOption.IP_TOS, this.options.getTrafficClass());
        }
        bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, this.options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, this.options.isReuseAddress());
        if (this.options.getAcceptBacklog() != -1) {
            bootstrap.option(ChannelOption.SO_BACKLOG, this.options.getAcceptBacklog());
        }
    }

    private void addHandlers(HttpServerImpl server, ContextImpl context) {
        if (this.requestStream.handler() != null) {
            server.reqHandlerManager.addHandler(new HttpHandler(this.requestStream.handler(), this.connectionHandler), context);
        }
        if (this.wsStream.handler() != null) {
            server.wsHandlerManager.addHandler(this.wsStream.handler(), context);
        }
    }

    private void actualClose(ContextImpl closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedHttpServers().remove(this.id);
        }
        ContextImpl currCon = this.vertx.getContext();
        for (ServerConnection serverConnection : this.connectionMap.values()) {
            serverConnection.close();
        }
        for (Http2ServerConnection http2ServerConnection : this.connectionMap2.values()) {
            http2ServerConnection.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        if (this.metrics != null) {
            this.metrics.close();
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)cgf -> this.executeCloseDone(closeContext, done, fut.cause())));
    }

    @Override
    public int actualPort() {
        return this.actualPort;
    }

    private void executeCloseDone(ContextImpl closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e != null ? Future.failedFuture(e) : Future.succeededFuture();
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    WebSocketServerHandshaker createHandshaker(Channel ch, HttpRequest request) {
        String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            this.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, ch);
            return null;
        }
        if (request.getMethod() != HttpMethod.GET) {
            this.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
            return null;
        }
        try {
            WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(ch.pipeline(), request), this.subProtocols, false, this.options.getMaxWebsocketFrameSize());
            WebSocketServerHandshaker shake = factory.newHandshaker(request);
            if (shake == null) {
                log.error("Unrecognised websockets handshake");
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ch);
            }
            return shake;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    private void sendError(CharSequence err, HttpResponseStatus status, Channel ch) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, err.length());
        } else {
            io.netty.handler.codec.http.HttpHeaders.setContentLength(resp, 0L);
        }
        ch.writeAndFlush(resp);
    }

    private String getWebSocketLocation(ChannelPipeline pipeline, HttpRequest req) throws Exception {
        String prefix = pipeline.get(SslHandler.class) == null ? "ws://" : "wss://";
        URI uri = new URI(req.getUri());
        String path = uri.getRawPath();
        String loc = prefix + io.netty.handler.codec.http.HttpHeaders.getHost(req) + path;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    HttpServerOptions options() {
        return this.options;
    }

    Map<Channel, ServerConnection> connectionMap() {
        return this.connectionMap;
    }

    private class Http1xOrHttp2Handler
    extends ChannelInboundHandlerAdapter {
        private int index = 0;

        private Http1xOrHttp2Handler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf buf = (ByteBuf)msg;
            int len = buf.readableBytes();
            for (int i = this.index; i < len; ++i) {
                if (i == HTTP_2_PREFACE.length) {
                    this.http2(ctx, buf);
                    break;
                }
                if (buf.getByte(i) == HTTP_2_PREFACE[i]) continue;
                this.http1(ctx, buf);
                break;
            }
        }

        private void http2(ChannelHandlerContext ctx, ByteBuf buf) {
            if (this.index > 0) {
                ByteBuf msg = Unpooled.buffer(this.index + buf.readableBytes());
                msg.setBytes(0, HTTP_2_PREFACE, 0, this.index);
                msg.setBytes(this.index, buf);
                buf = msg;
            }
            HttpServerImpl.this.handleHttp2(ctx.channel());
            ctx.fireChannelRead(buf);
            ctx.pipeline().remove(this);
        }

        private void http1(ChannelHandlerContext ctx, ByteBuf buf) {
            if (this.index > 0) {
                ByteBuf msg = Unpooled.buffer(this.index + buf.readableBytes());
                msg.setBytes(0, HTTP_2_PREFACE, 0, this.index);
                msg.setBytes(this.index, buf);
                buf = msg;
            }
            HttpServerImpl.this.configureHttp1(ctx.pipeline());
            ctx.fireChannelRead(buf);
            ctx.pipeline().remove(this);
        }
    }

    class HttpHandler {
        final Handler<HttpServerRequest> requesthHandler;
        final Handler<HttpConnection> connectionHandler;

        public HttpHandler(Handler<HttpServerRequest> requesthHandler, Handler<HttpConnection> connectionHandler) {
            this.requesthHandler = requesthHandler;
            this.connectionHandler = connectionHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HttpHandler that = (HttpHandler)o;
            if (!this.requesthHandler.equals(that.requesthHandler)) {
                return false;
            }
            return !(this.connectionHandler != null ? !this.connectionHandler.equals(that.connectionHandler) : that.connectionHandler != null);
        }

        public int hashCode() {
            int result = HttpServerImpl.this.reqHandlerManager.hashCode();
            if (this.connectionHandler != null) {
                result = 31 * result + this.connectionHandler.hashCode();
            }
            return result;
        }
    }

    class ServerWebSocketStreamImpl
    extends HttpStreamHandler<ServerWebSocketStream, ServerWebSocket>
    implements ServerWebSocketStream {
        ServerWebSocketStreamImpl() {
        }
    }

    class HttpServerRequestStreamImpl
    extends HttpStreamHandler<HttpServerRequestStream, HttpServerRequest>
    implements HttpServerRequestStream {
        HttpServerRequestStreamImpl() {
        }
    }

    private class HttpStreamHandler<R extends ReadStream<C>, C extends ReadStream<?>>
    implements ReadStream<C> {
        private Handler<C> handler;
        private boolean paused;
        private Handler<Void> endHandler;

        private HttpStreamHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<C> handler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isPaused() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.paused;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Handler<Void> endHandler() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                return this.endHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R handler(Handler<C> handler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (HttpServerImpl.this.listening) {
                    throw new IllegalStateException("Please set handler before server is listening");
                }
                this.handler = handler;
                return (R)this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R pause() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (!this.paused) {
                    this.paused = true;
                }
                return (R)this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R resume() {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                if (this.paused) {
                    this.paused = false;
                }
                return (R)this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public R endHandler(Handler<Void> endHandler) {
            HttpServerImpl httpServerImpl = HttpServerImpl.this;
            synchronized (httpServerImpl) {
                this.endHandler = endHandler;
                return (R)this;
            }
        }

        public R exceptionHandler(Handler<Throwable> handler) {
            return (R)this;
        }
    }

    public class ServerHandler
    extends VertxHttpHandler<ServerConnection> {
        private boolean closeFrameSent;
        FullHttpRequest wsRequest;

        public ServerHandler(Channel ch) {
            super(HttpServerImpl.this.connectionMap, ch);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doMessageReceived(ServerConnection conn, ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!DISABLE_WEBSOCKETS) {
                if (msg instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)msg;
                    if (log.isTraceEnabled()) {
                        log.trace("Server received request: " + request.getUri());
                    }
                    if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
                        String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
                        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
                            HttpServerImpl.this.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, this.ch);
                            return;
                        }
                        if (request.getMethod() != HttpMethod.GET) {
                            HttpServerImpl.this.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, this.ch);
                            return;
                        }
                        if (this.wsRequest != null) return;
                        if (request instanceof FullHttpRequest) {
                            this.handshake((FullHttpRequest)request, this.ch, ctx);
                            return;
                        } else {
                            this.wsRequest = new DefaultFullHttpRequest(request.getProtocolVersion(), request.getMethod(), request.getUri());
                            this.wsRequest.headers().set(request.headers());
                        }
                        return;
                    } else if (conn == null) {
                        this.createConnAndHandle(ctx, this.ch, msg, null);
                        return;
                    } else {
                        conn.handleMessage(msg);
                    }
                    return;
                } else if (msg instanceof WebSocketFrameInternal) {
                    WebSocketFrameInternal wsFrame = (WebSocketFrameInternal)msg;
                    switch (wsFrame.type()) {
                        case BINARY: 
                        case CONTINUATION: 
                        case TEXT: {
                            if (conn == null) return;
                            conn.handleMessage(msg);
                            return;
                        }
                        case PING: {
                            this.ch.writeAndFlush(new WebSocketFrameImpl(FrameType.PONG, wsFrame.getBinaryData()));
                            return;
                        }
                        case PONG: {
                            return;
                        }
                        case CLOSE: {
                            if (this.closeFrameSent) return;
                            this.ch.writeAndFlush(wsFrame).addListener(ChannelFutureListener.CLOSE);
                            this.closeFrameSent = true;
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Invalid type: " + (Object)((Object)wsFrame.type()));
                        }
                    }
                } else {
                    if (!(msg instanceof HttpContent)) throw new IllegalStateException("Invalid message " + msg);
                    if (this.wsRequest != null) {
                        this.wsRequest.content().writeBytes(((HttpContent)msg).content());
                        if (msg instanceof LastHttpContent) {
                            FullHttpRequest req = this.wsRequest;
                            this.wsRequest = null;
                            this.handshake(req, this.ch, ctx);
                            return;
                        }
                    }
                    if (conn == null) return;
                    conn.handleMessage(msg);
                }
                return;
            } else if (conn == null) {
                this.createConnAndHandle(ctx, this.ch, msg, null);
                return;
            } else {
                conn.handleMessage(msg);
            }
        }

        private void createConnAndHandle(ChannelHandlerContext ctx, Channel ch, Object msg, WebSocketServerHandshaker shake) {
            HandlerHolder reqHandler = HttpServerImpl.this.reqHandlerManager.chooseHandler(ch.eventLoop());
            if (reqHandler != null) {
                HttpRequest request;
                if (!HttpServerImpl.this.DISABLE_HC2 && msg instanceof HttpRequest && (request = (HttpRequest)msg).headers().contains(HttpHeaders.UPGRADE, Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true)) {
                    if (reqHandler.context.isEventLoopContext()) {
                        String connection = request.headers().get(HttpHeaders.CONNECTION);
                        int found = 0;
                        if (connection != null && connection.length() > 0) {
                            StringBuilder buff = new StringBuilder();
                            int pos = 0;
                            int len = connection.length();
                            while (pos < len) {
                                char c;
                                if ((c = connection.charAt(pos++)) != ' ' && c != ',') {
                                    buff.append(Character.toLowerCase(c));
                                }
                                if (c != ',' && pos != len) continue;
                                if (buff.indexOf("upgrade") == 0 && buff.length() == 7) {
                                    found |= 1;
                                } else if (buff.indexOf("http2-settings") == 0 && buff.length() == 14) {
                                    found |= 2;
                                }
                                buff.setLength(0);
                            }
                        }
                        if (found == 3) {
                            Http2Settings settings = null;
                            String settingsHeader = request.headers().get(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
                            if (settingsHeader != null) {
                                settings = HttpUtils.decodeSettings(settingsHeader);
                            }
                            if (settings != null) {
                                ChannelPipeline pipeline = ch.pipeline();
                                DefaultFullHttpResponse res = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                                res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
                                res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                                res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                                ctx.writeAndFlush(res).addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)v -> {
                                    pipeline.remove("handler");
                                    pipeline.remove("httpDecoder");
                                    pipeline.remove("httpEncoder");
                                }));
                                for (String name : H2C_HANDLERS_TO_REMOVE) {
                                    if (pipeline.get(name) == null) continue;
                                    pipeline.remove(name);
                                }
                                try {
                                    VertxHttp2ConnectionHandler handler = HttpServerImpl.this.createHttp2Handler(reqHandler, ch);
                                    handler.onHttpServerUpgrade(settings);
                                    HttpServerImpl.this.configureHttp2(pipeline, handler);
                                    return;
                                }
                                catch (Http2Exception http2Exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    DefaultFullHttpResponse res = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                    res.setStatus(HttpResponseStatus.BAD_REQUEST);
                    ctx.writeAndFlush(res);
                    return;
                }
                ServerConnection conn = new ServerConnection(HttpServerImpl.this.vertx, HttpServerImpl.this, ch, reqHandler.context, HttpServerImpl.this.serverOrigin, shake, HttpServerImpl.this.metrics);
                conn.requestHandler(((HttpHandler)reqHandler.handler).requesthHandler);
                this.conn = conn;
                this.connectionMap.put(ch, conn);
                reqHandler.context.executeFromIO(() -> {
                    conn.metric(HttpServerImpl.this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
                    Handler<HttpConnection> connHandler = ((HttpHandler)reqHandler.handler).connectionHandler;
                    if (connHandler != null) {
                        connHandler.handle(conn);
                    }
                    conn.handleMessage(msg);
                });
            }
        }

        private void handshake(FullHttpRequest request, Channel ch, ChannelHandlerContext ctx) throws Exception {
            WebSocketServerHandshaker shake = HttpServerImpl.this.createHandshaker(ch, request);
            if (shake == null) {
                return;
            }
            HandlerHolder wsHandler = HttpServerImpl.this.wsHandlerManager.chooseHandler(ch.eventLoop());
            if (wsHandler == null) {
                this.createConnAndHandle(ctx, ch, request, shake);
            } else {
                wsHandler.context.executeFromIO(() -> {
                    URI theURI;
                    try {
                        theURI = new URI(request.getUri());
                    }
                    catch (URISyntaxException e2) {
                        throw new IllegalArgumentException("Invalid uri " + request.getUri());
                    }
                    ServerConnection wsConn = new ServerConnection(HttpServerImpl.this.vertx, HttpServerImpl.this, ch, wsHandler.context, HttpServerImpl.this.serverOrigin, shake, HttpServerImpl.this.metrics);
                    wsConn.metric(HttpServerImpl.this.metrics.connected(wsConn.remoteAddress(), wsConn.remoteName()));
                    wsConn.wsHandler((Handler)wsHandler.handler);
                    Runnable connectRunnable = () -> {
                        VertxHttpHandler handler = ch.pipeline().get(VertxHttpHandler.class);
                        handler.conn = wsConn;
                        this.connectionMap.put(ch, wsConn);
                        try {
                            shake.handshake(ch, request);
                        }
                        catch (WebSocketHandshakeException e) {
                            wsConn.handleException(e);
                        }
                        catch (Exception e) {
                            log.error((Object)"Failed to generate shake response", e);
                        }
                    };
                    ServerWebSocketImpl ws = new ServerWebSocketImpl(HttpServerImpl.this.vertx, theURI.toString(), theURI.getPath(), theURI.getQuery(), new HeadersAdaptor(request.headers()), wsConn, shake.version() != WebSocketVersion.V00, connectRunnable, HttpServerImpl.this.options.getMaxWebsocketFrameSize());
                    ws.setMetric(HttpServerImpl.this.metrics.connected(wsConn.metric(), ws));
                    wsConn.handleWebsocketConnect(ws);
                    if (!ws.isRejected()) {
                        HttpChunkContentCompressor handler = ctx.pipeline().get(HttpChunkContentCompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        ws.connectNow();
                    } else {
                        ch.writeAndFlush(new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY));
                    }
                });
            }
        }
    }
}

