/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.http.impl.ServerConnection;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.net.URISyntaxException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class HttpServerRequestImpl
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpServerRequestImpl.class);
    private final ServerConnection conn;
    private final HttpRequest request;
    private final HttpServerResponse response;
    private HttpVersion version;
    private HttpMethod method;
    private String rawMethod;
    private String uri;
    private String path;
    private String query;
    private Handler<Buffer> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private MultiMap params;
    private MultiMap headers;
    private String absoluteURI;
    private NetSocket netSocket;
    private Handler<HttpServerFileUpload> uploadHandler;
    private Handler<Void> endHandler;
    private MultiMap attributes;
    private HttpPostRequestDecoder decoder;
    private boolean ended;

    HttpServerRequestImpl(ServerConnection conn, HttpRequest request, HttpServerResponse response) {
        this.conn = conn;
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpVersion version() {
        if (this.version == null) {
            io.netty.handler.codec.http.HttpVersion nettyVersion = this.request.getProtocolVersion();
            if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_0) {
                this.version = HttpVersion.HTTP_1_0;
            } else if (nettyVersion == io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                this.version = HttpVersion.HTTP_1_1;
            } else {
                this.sendNotImplementedAndClose();
                throw new IllegalStateException("Unsupported HTTP version: " + nettyVersion);
            }
        }
        return this.version;
    }

    @Override
    public HttpMethod method() {
        if (this.method == null) {
            String sMethod = this.request.method().toString();
            try {
                this.method = HttpMethod.valueOf(sMethod);
            }
            catch (IllegalArgumentException e) {
                this.method = HttpMethod.OTHER;
            }
        }
        return this.method;
    }

    @Override
    public String rawMethod() {
        if (this.rawMethod == null) {
            this.rawMethod = this.request.method().toString();
        }
        return this.rawMethod;
    }

    @Override
    public String uri() {
        if (this.uri == null) {
            this.uri = this.request.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (this.path == null) {
            this.path = HttpUtils.parsePath(this.uri());
        }
        return this.path;
    }

    @Override
    public String query() {
        if (this.query == null) {
            this.query = HttpUtils.parseQuery(this.uri());
        }
        return this.query;
    }

    @Override
    public @Nullable String host() {
        return this.getHeader(HttpHeaderNames.HOST);
    }

    @Override
    public HttpServerResponse response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.request.headers());
        }
        return this.headers;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public MultiMap params() {
        if (this.params == null) {
            this.params = HttpUtils.params(this.uri());
        }
        return this.params;
    }

    @Override
    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> dataHandler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.dataHandler = dataHandler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.conn.pause();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest resume() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.conn.resume();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public String scheme() {
        return this.isSSL() ? "https" : "http";
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSSL();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                this.absoluteURI = HttpUtils.absoluteURI(this.conn.getServerOrigin(), this);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Failed to create abs uri", e);
            }
        }
        return this.absoluteURI;
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.getPeerCertificateChain();
    }

    @Override
    public NetSocket netSocket() {
        if (this.netSocket == null) {
            this.netSocket = this.conn.createNetSocket();
        }
        return this.netSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            this.uploadHandler = handler;
            return this;
        }
    }

    @Override
    public MultiMap formAttributes() {
        return this.attributes();
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        return this.conn.upgrade(this, this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkEnded();
            if (expect) {
                String contentType;
                if (this.decoder == null && (contentType = this.request.headers().get("Content-Type")) != null) {
                    io.netty.handler.codec.http.HttpMethod method = this.request.getMethod();
                    String lowerCaseContentType = contentType.toLowerCase();
                    boolean isURLEncoded = lowerCaseContentType.startsWith("application/x-www-form-urlencoded");
                    if ((lowerCaseContentType.startsWith("multipart/form-data") || isURLEncoded) && (method.equals(io.netty.handler.codec.http.HttpMethod.POST) || method.equals(io.netty.handler.codec.http.HttpMethod.PUT) || method.equals(io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals(io.netty.handler.codec.http.HttpMethod.DELETE))) {
                        this.decoder = new HttpPostRequestDecoder(new NettyFileUploadDataFactory(this.conn.vertx(), this, () -> this.uploadHandler), this.request);
                    }
                }
            } else {
                this.decoder = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.decoder != null;
        }
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.ended;
        }
    }

    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleData(Buffer data) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.decoder != null) {
                try {
                    this.decoder.offer(new DefaultHttpContent(data.getByteBuf()));
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
            }
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleEnd() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.ended = true;
            if (this.decoder != null) {
                try {
                    this.decoder.offer(LastHttpContent.EMPTY_LAST_CONTENT);
                    while (this.decoder.hasNext()) {
                        InterfaceHttpData data = this.decoder.next();
                        if (!(data instanceof Attribute)) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            this.attributes().add(attr.getName(), attr.getValue());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                    }
                }
                catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                    this.handleException(e);
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
                }
                finally {
                    this.decoder.destroy();
                }
            }
            if (this.endHandler != null) {
                this.endHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(t);
            }
        }
    }

    private void sendNotImplementedAndClose() {
        this.response().setStatusCode(501).end();
        this.response().close();
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    private MultiMap attributes() {
        if (this.attributes == null) {
            this.attributes = new CaseInsensitiveHeaders();
        }
        return this.attributes;
    }

    private static String urlDecode(String str) {
        return QueryStringDecoder.decodeComponent(str, CharsetUtil.UTF_8);
    }
}

