/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxInternal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class AsyncResolveConnectHelper {
    private List<Handler<AsyncResult<Channel>>> handlers = new ArrayList<Handler<AsyncResult<Channel>>>();
    private ChannelFuture future;
    private AsyncResult<Channel> result;

    public synchronized void addListener(Handler<AsyncResult<Channel>> handler) {
        if (this.result != null) {
            if (this.future != null) {
                this.future.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)v -> handler.handle(this.result)));
            } else {
                handler.handle(this.result);
            }
        } else {
            this.handlers.add(handler);
        }
    }

    private synchronized void handle(ChannelFuture cf, AsyncResult<Channel> res) {
        if (this.result == null) {
            for (Handler<AsyncResult<Channel>> handler : this.handlers) {
                handler.handle(res);
            }
        } else {
            throw new IllegalStateException("Already complete!");
        }
        this.future = cf;
        this.result = res;
    }

    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
    }

    public static AsyncResolveConnectHelper doBind(VertxInternal vertx, int port, String host, ServerBootstrap bootstrap) {
        AsyncResolveConnectHelper.checkPort(port);
        AsyncResolveConnectHelper asyncResolveConnectHelper = new AsyncResolveConnectHelper();
        vertx.resolveAddress(host, res -> {
            if (res.succeeded()) {
                InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), port);
                ChannelFuture future = bootstrap.bind(t);
                future.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)f -> {
                    if (f.isSuccess()) {
                        asyncResolveConnectHelper.handle(future, Future.succeededFuture(future.channel()));
                    } else {
                        asyncResolveConnectHelper.handle(future, Future.failedFuture(f.cause()));
                    }
                }));
            } else {
                asyncResolveConnectHelper.handle(null, Future.failedFuture(res.cause()));
            }
        });
        return asyncResolveConnectHelper;
    }
}

