/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.TemplateEngine;

public class TemplateHandlerImpl
implements TemplateHandler {
    private final TemplateEngine engine;
    private final String templateDirectory;
    private final String contentType;

    public TemplateHandlerImpl(TemplateEngine engine, String templateDirectory, String contentType) {
        this.engine = engine;
        this.templateDirectory = templateDirectory;
        this.contentType = contentType;
    }

    @Override
    public void handle(RoutingContext context) {
        String file = this.templateDirectory + Utils.pathOffset(context.normalisedPath(), context);
        this.engine.render(context, file, res -> {
            if (res.succeeded()) {
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType).end((Buffer)res.result());
            } else {
                context.fail(res.cause());
            }
        });
    }
}

