/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class Utils
extends io.vertx.core.impl.Utils {
    private static final Pattern COMMA_SPLITTER = Pattern.compile(" *, *");
    private static final Pattern SEMICOLON_SPLITTER = Pattern.compile(" *; *");
    private static final Pattern EQUAL_SPLITTER = Pattern.compile(" *= *");
    private static final Comparator<String> ACCEPT_X_COMPARATOR = new Comparator<String>(){

        float getQuality(String s) {
            if (s == null) {
                return 0.0f;
            }
            String[] params = SEMICOLON_SPLITTER.split(s);
            for (int i = 1; i < params.length; ++i) {
                String[] q = EQUAL_SPLITTER.split(params[1]);
                if (!"q".equals(q[0])) continue;
                return Float.parseFloat(q[1]);
            }
            return 1.0f;
        }

        @Override
        public int compare(String o1, String o2) {
            float f2;
            float f1 = this.getQuality(o1);
            if (f1 < (f2 = this.getQuality(o2))) {
                return 1;
            }
            if (f1 > f2) {
                return -1;
            }
            return 0;
        }
    };

    public static String normalisePath(String path) {
        return Utils.normalisePath(path, true);
    }

    public static String normalisePath(String path, boolean urldecode) {
        if (path == null) {
            return "/";
        }
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        try {
            StringBuilder result = new StringBuilder(path.length());
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '/') {
                    if (i != 0 && result.charAt(result.length() - 1) == '/') continue;
                    result.append(c);
                    continue;
                }
                if (urldecode && c == '%') {
                    i = Utils.processEscapeSequence(path, result, i);
                    continue;
                }
                if (c == '.') {
                    if (i == 0 || result.charAt(result.length() - 1) != '.') {
                        result.append(c);
                        continue;
                    }
                    result.deleteCharAt(result.length() - 1);
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static int processEscapeSequence(String path, StringBuilder result, int i) throws UnsupportedEncodingException {
        Buffer buf = Buffer.buffer(2);
        do {
            if (i >= path.length() - 2) {
                throw new IllegalArgumentException("Invalid position for escape character: " + i);
            }
            int unescaped = Integer.parseInt(path.substring(i + 1, i + 3), 16);
            if (unescaped < 0) {
                throw new IllegalArgumentException("Invalid escape sequence: " + path.substring(i, i + 3));
            }
            buf.appendByte((byte)unescaped);
        } while ((i += 3) < path.length() && path.charAt(i) == '%');
        String escapedSeq = new String(buf.getBytes(), StandardCharsets.UTF_8);
        for (int j = 0; j < escapedSeq.length(); ++j) {
            char c = escapedSeq.charAt(j);
            if (c == '/') {
                if (j != 0 && result.charAt(result.length() - 1) == '/') continue;
                result.append(c);
                continue;
            }
            if (c == '.') {
                if (j == 0 || result.charAt(result.length() - 1) != '.') {
                    result.append(c);
                    continue;
                }
                result.deleteCharAt(result.length() - 1);
                continue;
            }
            result.append(c);
        }
        return i - 1;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? Utils.class.getClassLoader() : tccl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buffer readResourceToBuffer(String resource) {
        ClassLoader cl = Utils.getClassLoader();
        try {
            Buffer buffer = Buffer.buffer();
            try (InputStream in = cl.getResourceAsStream(resource);){
                int read;
                if (in == null) {
                    Buffer buffer2 = null;
                    return buffer2;
                }
                byte[] data = new byte[4096];
                while ((read = in.read(data, 0, data.length)) != -1) {
                    if (read == data.length) {
                        buffer.appendBytes(data);
                        continue;
                    }
                    byte[] slice = new byte[read];
                    System.arraycopy(data, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
                return buffer;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFileToString(Vertx vertx, String resource) {
        try {
            Buffer buff = vertx.fileSystem().readFileBlocking(resource);
            return buff.toString();
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public static List<String> getSortedAcceptableMimeTypes(String acceptHeader) {
        if (acceptHeader == null) {
            return Collections.emptyList();
        }
        String[] items = COMMA_SPLITTER.split(acceptHeader);
        Arrays.sort(items, ACCEPT_X_COMPARATOR);
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            int space = item.indexOf(59);
            if (space != -1) {
                list.add(item.substring(0, space));
                continue;
            }
            list.add(item);
        }
        return list;
    }

    public static DateFormat createRFC1123DateTimeFormatter() {
        SimpleDateFormat dtf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        dtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dtf;
    }

    public static String pathOffset(String path, RoutingContext context) {
        String routePath;
        int prefixLen = 0;
        String mountPoint = context.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
        }
        if ((routePath = context.currentRoute().getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path.substring(prefixLen) : path;
    }

    public static long secondsFactor(long millis) {
        return millis - millis % 1000L;
    }
}

