/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging;

import java.util.Collection;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.spi.loader.ServiceRegistry;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingProcessors {
    public static PackagingProcessor<? extends Archive<?>> find(PackagingType packagingType) {
        ServiceRegistry registry = ServiceRegistry.getInstance();
        Collection<PackagingProcessor> processors = registry.all(PackagingProcessor.class);
        StringBuilder unsupportedFormatMessage = new StringBuilder("No packaging processor for ").append(packagingType.toString()).append(" packaging was found. Supported processors are: ");
        for (PackagingProcessor processor : processors) {
            if (processor.handles(packagingType)) {
                return processor;
            }
            unsupportedFormatMessage.append(processor.getClass()).append(", ");
        }
        if (unsupportedFormatMessage.indexOf(", ") != -1) {
            unsupportedFormatMessage.delete(unsupportedFormatMessage.length() - 2, unsupportedFormatMessage.length());
        }
        throw new UnsupportedOperationException(unsupportedFormatMessage.toString());
    }
}

