/*
 * Decompiled with CFR 0.152.
 */
package org.obsidiantoaster.quickstart;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.Json;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.obsidiantoaster.quickstart.service.Greeting;

public class RestApplication
extends AbstractVerticle {
    private static final String template = "Hello, %s!";
    private long counter;

    public void start(Future done) {
        Router router = Router.router(this.vertx);
        router.get("/greeting").handler(this::greeting);
        this.vertx.createHttpServer().requestHandler(router::accept).listen((int)this.config().getInteger("http.port", 8080), done.completer());
    }

    private void greeting(RoutingContext rc) {
        String name = rc.request().getParam("name");
        if (name == null) {
            name = "World";
        }
        rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").end(Json.encode(new Greeting(++this.counter, String.format(template, name))));
    }
}

