/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2ServerRequestImpl;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;

public class Http2ServerConnection
extends Http2ConnectionBase {
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final Handler<HttpServerRequest> requestHandler;
    private final HttpServerMetrics metrics;
    private final Object metric;
    private Long maxConcurrentStreams;
    private int concurrentStreams;
    private final ArrayDeque<Push> pendingPushes = new ArrayDeque(8);

    Http2ServerConnection(Channel channel, ContextImpl context, String serverOrigin, VertxHttp2ConnectionHandler connHandler, HttpServerOptions options, Handler<HttpServerRequest> requestHandler, HttpServerMetrics metrics) {
        super(channel, context, connHandler, metrics);
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.requestHandler = requestHandler;
        this.metric = metrics.connected(this.remoteAddress(), this.remoteName());
        this.metrics = metrics;
    }

    HttpServerMetrics metrics() {
        return this.metrics;
    }

    private static boolean isMalformedRequest(Http2Headers headers) {
        if (headers.method() == null) {
            return true;
        }
        String method = headers.method().toString();
        if (method.equals("CONNECT") ? headers.scheme() != null || headers.path() != null || headers.authority() == null : headers.method() == null || headers.scheme() == null || headers.path() == null) {
            return true;
        }
        if (headers.authority() != null) {
            URI uri;
            try {
                uri = new URI(null, headers.authority().toString(), null, null, null);
            }
            catch (URISyntaxException e) {
                return true;
            }
            if (uri.getRawUserInfo() != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        VertxHttp2Stream stream = (VertxHttp2Stream)this.streams.get(streamId);
        if (stream == null) {
            if (Http2ServerConnection.isMalformedRequest(headers)) {
                this.handler.writeReset(streamId, Http2Error.PROTOCOL_ERROR.code());
                return;
            }
            String contentEncoding = this.options.isCompressionSupported() ? HttpUtils.determineContentEncoding(headers) : null;
            Http2Stream s = this.handler.connection().stream(streamId);
            boolean writable = this.handler.encoder().flowController().isWritable(s);
            Http2ServerRequestImpl req = new Http2ServerRequestImpl(this, s, this.metrics, this.serverOrigin, headers, contentEncoding, writable);
            stream = req;
            CharSequence value = (CharSequence)headers.get(HttpHeaderNames.EXPECT);
            if (this.options.isHandle100ContinueAutomatically() && (value != null && HttpHeaderValues.CONTINUE.equals(value) || headers.contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE))) {
                req.response().writeContinue();
            }
            this.streams.put(streamId, req);
            this.context.executeFromIO(() -> {
                Http2ServerResponseImpl resp = req.response();
                resp.beginRequest();
                this.requestHandler.handle(req);
                boolean hasPush = resp.endRequest();
                if (hasPush) {
                    ctx.flush();
                }
            });
        }
        if (endOfStream) {
            this.context.executeFromIO(stream::onEnd);
        }
    }

    @Override
    public synchronized void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        Long v = settings.maxConcurrentStreams();
        if (v != null) {
            this.maxConcurrentStreams = v;
        }
        super.onSettingsRead(ctx, settings);
    }

    synchronized void sendPush(int streamId, String host, final HttpMethod method, MultiMap headers, final String path, final Handler<AsyncResult<HttpServerResponse>> completionHandler) {
        final DefaultHttp2Headers headers_ = new DefaultHttp2Headers();
        if (method == HttpMethod.OTHER) {
            throw new IllegalArgumentException("Cannot push HttpMethod.OTHER");
        }
        headers_.method(method.name());
        headers_.path(path);
        headers_.scheme(this.isSsl() ? "https" : "http");
        if (host != null) {
            headers_.authority(host);
        }
        if (headers != null) {
            headers.forEach(header -> {
                Http2Headers cfr_ignored_0 = (Http2Headers)headers_.add(header.getKey(), header.getValue());
            });
        }
        this.handler.writePushPromise(streamId, headers_, new Handler<AsyncResult<Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(AsyncResult<Integer> ar) {
                if (ar.succeeded()) {
                    Http2ServerConnection http2ServerConnection = Http2ServerConnection.this;
                    synchronized (http2ServerConnection) {
                        int promisedStreamId = ar.result();
                        String contentEncoding = HttpUtils.determineContentEncoding(headers_);
                        Http2Stream promisedStream = Http2ServerConnection.this.handler.connection().stream(promisedStreamId);
                        boolean writable = Http2ServerConnection.this.handler.encoder().flowController().isWritable(promisedStream);
                        Push push = new Push(promisedStream, contentEncoding, method, path, writable, completionHandler);
                        Http2ServerConnection.this.streams.put(promisedStreamId, push);
                        if (Http2ServerConnection.this.maxConcurrentStreams == null || (long)Http2ServerConnection.this.concurrentStreams < Http2ServerConnection.this.maxConcurrentStreams) {
                            Http2ServerConnection.this.concurrentStreams++;
                            Http2ServerConnection.this.context.executeFromIO(push::complete);
                        } else {
                            Http2ServerConnection.this.pendingPushes.add(push);
                        }
                    }
                } else {
                    Http2ServerConnection.this.context.executeFromIO(() -> completionHandler.handle(Future.failedFuture(ar.cause())));
                }
            }
        });
    }

    @Override
    protected void updateSettings(Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        settingsUpdate.remove('\u0002');
        super.updateSettings(settingsUpdate, completionHandler);
    }

    @Override
    protected Object metric() {
        return this.metric;
    }

    private class Push
    extends VertxHttp2Stream<Http2ServerConnection> {
        private final HttpMethod method;
        private final String uri;
        private final String contentEncoding;
        private Http2ServerResponseImpl response;
        private final Future<HttpServerResponse> completionHandler;

        public Push(Http2Stream stream, String contentEncoding, HttpMethod method, String uri, boolean writable, Handler<AsyncResult<HttpServerResponse>> completionHandler) {
            super(Http2ServerConnection.this, stream, writable);
            this.method = method;
            this.uri = uri;
            this.contentEncoding = contentEncoding;
            this.completionHandler = Future.future().setHandler(completionHandler);
        }

        @Override
        void handleEnd(MultiMap trailers) {
        }

        @Override
        void handleData(Buffer buf) {
        }

        @Override
        void handleInterestedOpsChanged() {
            if (this.response != null) {
                this.response.writabilityChanged();
            }
        }

        @Override
        void handleReset(long errorCode) {
            if (this.response != null) {
                this.response.callReset(errorCode);
            } else {
                this.completionHandler.fail(new StreamResetException(errorCode));
            }
        }

        @Override
        void handleException(Throwable cause) {
            if (this.response != null) {
                this.response.handleError(cause);
            }
        }

        @Override
        void handleClose() {
            if (Http2ServerConnection.this.pendingPushes.remove(this)) {
                this.completionHandler.fail("Push reset by client");
            } else {
                Http2ServerConnection.this.concurrentStreams--;
                while ((Http2ServerConnection.this.maxConcurrentStreams == null || (long)Http2ServerConnection.this.concurrentStreams < Http2ServerConnection.this.maxConcurrentStreams) && Http2ServerConnection.this.pendingPushes.size() > 0) {
                    Push push = (Push)Http2ServerConnection.this.pendingPushes.pop();
                    Http2ServerConnection.this.concurrentStreams++;
                    this.context.runOnContext(v -> push.complete());
                }
                this.response.handleClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            Http2ServerConnection http2ServerConnection = Http2ServerConnection.this;
            synchronized (http2ServerConnection) {
                this.response = new Http2ServerResponseImpl(Http2ServerConnection.this, (VertxHttp2Stream)this, this.method, this.uri, true, this.contentEncoding);
                this.completionHandler.complete(this.response);
            }
        }
    }
}

