/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.table.MethodCalls;
import org.openrewrite.java.trait.MethodAccess;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class FindInternalJavaxApis
extends Recipe {
    private final transient MethodCalls methodCalls = new MethodCalls((Recipe)this);
    @Option(displayName="Method pattern", description="Optionally limit the search to declarations that match the provided method pattern.", example="java.util.List add(..)", required=false)
    private final @Nullable String methodPattern;

    public String getDisplayName() {
        return "Find uses of internal javax APIs";
    }

    public String getDescription() {
        return "The libraries that define these APIs will have to be migrated before any of the repositories that use them.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        Pattern javaxType = Pattern.compile(StringUtils.aspectjNameToPattern((String)"javax..*"));
        return Preconditions.check((TreeVisitor)new UsesType("javax..*", null), (TreeVisitor)(StringUtils.isBlank((String)this.methodPattern) ? new MethodAccess.Matcher() : new MethodAccess.Matcher(this.methodPattern)).asVisitor((ma, ctx) -> {
            MethodCall call = (MethodCall)ma.getTree();
            JavaType.Method methodType = call.getMethodType();
            if (methodType == null || methodType.getReturnType() == null || methodType.getReturnType() instanceof JavaType.Unknown) {
                return call;
            }
            if (methodType.getReturnType().isAssignableFrom(javaxType)) {
                this.insertRow((MethodAccess)ma, (ExecutionContext)ctx, methodType);
                return SearchResult.found((Tree)call);
            }
            for (JavaType parameterType : methodType.getParameterTypes()) {
                if (!parameterType.isAssignableFrom(javaxType)) continue;
                this.insertRow((MethodAccess)ma, (ExecutionContext)ctx, methodType);
                return SearchResult.found((Tree)call);
            }
            return call;
        }));
    }

    private void insertRow(MethodAccess ma, ExecutionContext ctx, JavaType.Method methodType) {
        this.methodCalls.insertRow(ctx, (Object)new MethodCalls.Row(((SourceFile)ma.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), ((MethodCall)ma.getTree()).printTrimmed(ma.getCursor()), methodType.getDeclaringType().toString(), methodType.getName(), methodType.getParameterTypes().stream().map(String::valueOf).collect(Collectors.joining(", "))));
    }

    @ConstructorProperties(value={"methodPattern"})
    @Generated
    public FindInternalJavaxApis(@Nullable String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindInternalJavaxApis)) {
            return false;
        }
        FindInternalJavaxApis other = (FindInternalJavaxApis)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.methodPattern;
        String other$methodPattern = other.methodPattern;
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindInternalJavaxApis;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.methodPattern;
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

