/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class CaseInsensitiveComparisonsDoNotChangeCase
extends Recipe {
    public String getDisplayName() {
        return "CaseInsensitive comparisons do not alter case";
    }

    public String getDescription() {
        return "Remove `String#toLowerCase()` or `String#toUpperCase()` from `String#equalsIgnoreCase(..)` comparisons.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1157");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String equalsIgnoreCase(java.lang.String)"), new CaseInsensitiveComparisonVisitor());
    }

    private static class CaseInsensitiveComparisonVisitor<ExecutionContext>
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher COMPARE_IGNORE_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
        private static final MethodMatcher TO_LOWER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toLowerCase()");
        private static final MethodMatcher TO_UPPER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toUpperCase()");

        private CaseInsensitiveComparisonVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, executionContext);
            if (COMPARE_IGNORE_CASE_METHOD_MATCHER.matches((MethodCall)mi) && this.isChangeCaseMethod((J)(mi = mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                if (arg instanceof J.MethodInvocation && this.isChangeCaseMethod((J)arg)) {
                    return ((J.MethodInvocation)arg).getSelect();
                }
                return arg;
            }))).getSelect())) {
                J.MethodInvocation mChangeCase = (J.MethodInvocation)mi.getSelect();
                mi = mi.withSelect(mChangeCase.getSelect());
            }
            return mi;
        }

        private boolean isChangeCaseMethod(@Nullable J j) {
            if (j instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)j;
                return TO_LOWER_CASE_METHOD_MATCHER.matches((MethodCall)mi) || TO_UPPER_CASE_METHOD_MATCHER.matches((MethodCall)mi);
            }
            return false;
        }
    }
}

