/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class NestedEnumsAreNotStatic
extends Recipe {
    public String getDisplayName() {
        return "Nested enums are not static";
    }

    public String getDescription() {
        return "Remove static modifier from nested enum types since they are implicitly static.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2786");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getKind() == J.ClassDeclaration.Kind.Type.Enum && cd.getType() != null && cd.getType().getOwningClass() != null) {
                    cd = (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getKind() == J.ClassDeclaration.Kind.Type.Enum && cd.getType() != null && cd.getType().getOwningClass() != null && J.Modifier.hasModifier((Collection)cd.getModifiers(), (J.Modifier.Type)J.Modifier.Type.Static)) {
                    J.Block enumBody = cd.getBody();
                    cd = cd.withBody(null);
                    cd = (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)cd.withModifiers(ListUtils.map((List)cd.getModifiers(), mod -> mod.getType() == J.Modifier.Type.Static ? null : mod)), ctx);
                    cd = cd.withBody(enumBody);
                }
                return cd;
            }
        });
    }
}

