/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;

@Incubating(since="7.33.0")
public class RemoveEmptyJavaDocParameters
extends Recipe {
    public String getDisplayName() {
        return "Remove JavaDoc `@param`, `@return`, and `@throws` with no description";
    }

    public String getDescription() {
        return "Removes `@param`, `@return`, and `@throws` with no description from JavaDocs.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final RemoveEmptyParamVisitor removeEmptyParamVisitor = new RemoveEmptyParamVisitor();

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (md.getComments().stream().anyMatch(Javadoc.DocComment.class::isInstance)) {
                    md = (J.MethodDeclaration)md.withComments(ListUtils.map((List)md.getComments(), it -> {
                        if (it instanceof Javadoc.DocComment) {
                            Javadoc.DocComment docComment = (Javadoc.DocComment)it;
                            return (Comment)this.removeEmptyParamVisitor.visitDocComment(docComment, ctx);
                        }
                        return it;
                    }));
                }
                return md;
            }

            class RemoveEmptyParamVisitor
            extends JavadocVisitor<ExecutionContext> {
                public RemoveEmptyParamVisitor() {
                    super((JavaVisitor)new JavaIsoVisitor());
                }

                public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext ctx) {
                    ArrayList<Javadoc> newBody = new ArrayList<Javadoc>(javadoc.getBody().size());
                    boolean useNewBody = false;
                    ArrayList body = new ArrayList(javadoc.getBody());
                    body.add(0, null);
                    for (int i = 0; i < body.size(); ++i) {
                        Javadoc currentDoc = (Javadoc)body.get(i);
                        if (i + 1 < body.size()) {
                            Javadoc.Erroneous nextErroneous;
                            Javadoc nextDoc = (Javadoc)body.get(i + 1);
                            if (nextDoc instanceof Javadoc.Parameter) {
                                Javadoc.Parameter nextParameter = (Javadoc.Parameter)nextDoc;
                                if (this.isEmptyParameter(nextParameter)) {
                                    if (i + 1 == body.size() - 1) {
                                        if (!newBody.isEmpty() && newBody.get(newBody.size() - 1) instanceof Javadoc.LineBreak) {
                                            newBody.remove(newBody.size() - 1);
                                        }
                                        if (!nextParameter.getDescription().isEmpty()) {
                                            newBody.add((Javadoc)nextParameter.getDescription().get(0));
                                        }
                                    }
                                    ++i;
                                    useNewBody = true;
                                    currentDoc = null;
                                }
                            } else if (nextDoc instanceof Javadoc.Return) {
                                Javadoc.Return nextReturn = (Javadoc.Return)nextDoc;
                                if (this.isEmptyReturn(nextReturn)) {
                                    if (i + 1 == body.size() - 1) {
                                        if (!newBody.isEmpty() && newBody.get(newBody.size() - 1) instanceof Javadoc.LineBreak) {
                                            newBody.remove(newBody.size() - 1);
                                        }
                                        if (!nextReturn.getDescription().isEmpty()) {
                                            newBody.add((Javadoc)nextReturn.getDescription().get(0));
                                        }
                                    }
                                    ++i;
                                    useNewBody = true;
                                    currentDoc = null;
                                }
                            } else if (nextDoc instanceof Javadoc.Erroneous && this.isEmptyErroneous(nextErroneous = (Javadoc.Erroneous)nextDoc)) {
                                if (!newBody.isEmpty() && newBody.get(newBody.size() - 1) instanceof Javadoc.LineBreak) {
                                    newBody.remove(newBody.size() - 1);
                                }
                                ++i;
                                useNewBody = true;
                                currentDoc = null;
                            }
                        }
                        if (currentDoc == null) continue;
                        newBody.add(currentDoc);
                    }
                    if (useNewBody) {
                        this.trim(newBody);
                        if (newBody.isEmpty()) {
                            return null;
                        }
                        javadoc = javadoc.withBody(newBody);
                    }
                    return javadoc;
                }

                private void trim(List<Javadoc> body) {
                    Javadoc.LineBreak firstLineBreak = null;
                    while (!body.isEmpty()) {
                        Javadoc currentDoc = body.get(body.size() - 1);
                        boolean isLineBreak = currentDoc instanceof Javadoc.LineBreak;
                        if (isLineBreak && firstLineBreak == null) {
                            firstLineBreak = (Javadoc.LineBreak)currentDoc;
                        }
                        boolean isEmptyText = false;
                        if (currentDoc instanceof Javadoc.Text) {
                            String currentText = ((Javadoc.Text)currentDoc).getText().trim();
                            isEmptyText = currentText.isEmpty();
                        }
                        if (!isLineBreak && !isEmptyText) break;
                        body.remove(body.size() - 1);
                    }
                    if (!body.isEmpty() && firstLineBreak != null) {
                        String margin = firstLineBreak.getMargin();
                        if (margin.endsWith("*")) {
                            firstLineBreak = firstLineBreak.withMargin(margin.substring(0, margin.length() - 1));
                        }
                        body.add((Javadoc)firstLineBreak);
                    }
                }

                public boolean isEmptyParameter(Javadoc.Parameter parameter) {
                    return parameter.getDescription().stream().allMatch(Javadoc.LineBreak.class::isInstance);
                }

                public boolean isEmptyReturn(Javadoc.Return aReturn) {
                    return aReturn.getDescription().stream().allMatch(Javadoc.LineBreak.class::isInstance);
                }

                public boolean isEmptyErroneous(Javadoc.Erroneous erroneous) {
                    return erroneous.getText().size() == 1 && erroneous.getText().get(0) instanceof Javadoc.Text && "@throws".equals(((Javadoc.Text)erroneous.getText().get(0)).getText());
                }
            }
        };
    }
}

