/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;

public class UnnecessaryParentheses
extends Recipe {
    public String getDisplayName() {
        return "Remove unnecessary parentheses";
    }

    public String getDescription() {
        return "Removes unnecessary parentheses from code where extra parentheses pairs are redundant.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-S1110", "RSPEC-S1611"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UnnecessaryParenthesesVisitor();
    }
}

