/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertNotNullToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertNotNull` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertNotNull()` to AssertJ's `assertThat().isNotNull()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(false));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AssertNotNullToAssertThatVisitor();
    }

    public static class AssertNotNullToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher JUNIT_ASSERT_NOT_NULL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertNotNull(..)");

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_NOT_NULL_MATCHER.matches(method)) {
                return method;
            }
            List args = method.getArguments();
            Expression actual = (Expression)args.get(0);
            if (args.size() == 1) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertNotNullToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).isNotNull();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual});
            } else {
                Expression message = (Expression)args.get(1);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertNotNullToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(String)}).isNotNull();") : JavaTemplate.builder(() -> ((AssertNotNullToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any()}).as(#{any(java.util.function.Supplier)}).isNotNull();");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, message});
            }
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            return method;
        }
    }
}

