/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class UseExplicitSize
extends Recipe {
    public String getDisplayName() {
        return "Use AssertJ `hasSize()` on collections";
    }

    public String getDescription() {
        return "Convert `assertThat(collection.size()).isEqualTo(Y)` with AssertJ's `assertThat(collection).hasSize()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.assertj.core.api.Assertions", Boolean.valueOf(false));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UseExplicitSizeVisitor();
    }

    public static class UseExplicitSizeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher ASSERT_THAT = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
        private static final MethodMatcher IS_EQUAL_TO = new MethodMatcher("org.assertj.core.api.* isEqualTo(..)");
        private static final MethodMatcher SIZE = new MethodMatcher("java.util.Collection size(..)", true);

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, ExecutionContext ctx) {
            J.MethodInvocation method = super.visitMethodInvocation(m, (Object)ctx);
            if (!IS_EQUAL_TO.matches(method)) {
                return method;
            }
            if (!(method.getSelect() instanceof J.MethodInvocation)) {
                return method;
            }
            if (!ASSERT_THAT.matches((J.MethodInvocation)method.getSelect())) {
                return method;
            }
            J.MethodInvocation assertThat = (J.MethodInvocation)method.getSelect();
            if (!(assertThat.getArguments().get(0) instanceof J.MethodInvocation)) {
                return method;
            }
            J.MethodInvocation size = (J.MethodInvocation)assertThat.getArguments().get(0);
            if (!SIZE.matches(size)) {
                return method;
            }
            Expression list = size.getSelect();
            Expression expectedSize = (Expression)method.getArguments().get(0);
            String template = "assertThat(#{any(java.util.List)}).hasSize(#{any()});";
            return (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((UseExplicitSizeVisitor)this).getCursor(), (String)template).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{list, expectedSize});
        }
    }
}

