/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindEmptyMethods;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class RemoveEmptyTests
extends Recipe {
    public String getDisplayName() {
        return "Remove empty tests without comments";
    }

    public String getDescription() {
        return "Removes empty methods with a `@Test` annotation if the body does not have comments.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1186");
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                this.doAfterVisit((Recipe)new FindEmptyMethods(Boolean.valueOf(false)));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (this.hasTestAnnotation(method) && this.isEmptyMethod(method)) {
                    return null;
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private boolean hasTestAnnotation(J.MethodDeclaration method) {
                return method.getLeadingAnnotations().stream().filter(o -> o.getAnnotationType() instanceof J.Identifier).anyMatch(o -> "Test".equals(o.getSimpleName()));
            }

            private boolean isEmptyMethod(J.MethodDeclaration method) {
                return !method.isConstructor() && (method.getBody() == null || method.getBody().getStatements().isEmpty() && method.getBody().getEnd().getComments().isEmpty());
            }
        };
    }
}

