/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.template.SourceTemplate;

public final class RunnerToExtension
extends Recipe {
    @Option(displayName="Runners", description="The fully qualified class names of the JUnit 4 runners to replace. Sometimes several runners are replaced by a single JUnit Jupiter extension.", example="org.springframework.test.context.junit4.SpringRunner")
    private final List<String> runners;
    @Option(displayName="Extension", description="The fully qualified class names of the JUnit Jupiter extension.", example="org.springframework.test.context.junit.jupiter.SpringExtension")
    private final String extension;

    @JsonCreator
    public RunnerToExtension(@JsonProperty(value="runners") List<String> runners, @JsonProperty(value="extension") String extension) {
        this.runners = runners;
        this.extension = extension;
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (String runner : RunnerToExtension.this.runners) {
                    this.doAfterVisit((TreeVisitor)new UsesType(runner, Boolean.valueOf(false)));
                }
                return cu;
            }
        };
    }

    public String getDisplayName() {
        return "JUnit 4 `@RunWith` to JUnit Jupiter `@ExtendWith`";
    }

    public String getDescription() {
        return "Replace runners with the JUnit Jupiter extension equivalent.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final JavaType.Class extensionType;
            @Nullable
            private JavaTemplate extendsWithTemplate;
            {
                this.extensionType = JavaType.ShallowClass.build((String)RunnerToExtension.this.extension);
            }

            private JavaTemplate getExtendsWithTemplate(ExecutionContext ctx) {
                if (this.extendsWithTemplate == null) {
                    this.extendsWithTemplate = JavaTemplate.builder(() -> (this).getCursor(), (String)"@ExtendWith(#{}.class)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"}).dependsOn(new String[]{"package " + this.extensionType.getPackageName() + ";\nimport org.junit.jupiter.api.extension.Extension;\npublic class " + this.extensionType.getClassName() + " implements Extension {}"})).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith", "org.junit.jupiter.api.extension.Extension", RunnerToExtension.this.extension}).build();
                }
                return this.extendsWithTemplate;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                for (String runner : RunnerToExtension.this.runners) {
                    for (J.Annotation runWith : FindAnnotations.find((J)classDecl.withBody(null), (String)("@org.junit.runner.RunWith(" + runner + ".class)"))) {
                        cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)this.getExtendsWithTemplate(ctx), runWith.getCoordinates().replace(), new Object[]{this.extensionType.getClassName()});
                        this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                        this.maybeAddImport(RunnerToExtension.this.extension);
                        this.maybeRemoveImport("org.junit.runner.RunWith");
                        this.maybeRemoveImport(runner);
                    }
                }
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                for (String runner : RunnerToExtension.this.runners) {
                    for (J.Annotation runWith : FindAnnotations.find((J)method.withBody(null), (String)("@org.junit.runner.RunWith(" + runner + ".class)"))) {
                        md = (J.MethodDeclaration)md.withTemplate((SourceTemplate)this.getExtendsWithTemplate(ctx), runWith.getCoordinates().replace(), new Object[]{this.extensionType.getClassName()});
                        this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                        this.maybeAddImport(RunnerToExtension.this.extension);
                        this.maybeRemoveImport("org.junit.runner.RunWith");
                        this.maybeRemoveImport(runner);
                    }
                }
                return md;
            }
        };
    }

    public List<String> getRunners() {
        return this.runners;
    }

    public String getExtension() {
        return this.extension;
    }

    @NonNull
    public String toString() {
        return "RunnerToExtension(runners=" + this.getRunners() + ", extension=" + this.getExtension() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunnerToExtension)) {
            return false;
        }
        RunnerToExtension other = (RunnerToExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$runners = this.getRunners();
        List<String> other$runners = other.getRunners();
        if (this$runners == null ? other$runners != null : !((Object)this$runners).equals(other$runners)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !this$extension.equals(other$extension));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RunnerToExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $runners = this.getRunners();
        result = result * 59 + ($runners == null ? 43 : ((Object)$runners).hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        return result;
    }
}

