/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.internal.InsertDependencyComparator;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.tree.ParseError;

public class AddDependencyVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final GradleParser GRADLE_PARSER = GradleParser.builder().build();
    private final String groupId;
    private final String artifactId;
    private final @Nullable String version;
    private final @Nullable String versionPattern;
    private final String configuration;
    private final @Nullable String classifier;
    private final @Nullable String extension;
    private final @Nullable MavenMetadataFailures metadataFailures;
    private @Nullable String resolvedVersion;
    private final @Nullable Predicate<Cursor> insertPredicate;

    public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            K.CompilationUnit k;
            G.CompilationUnit g;
            JavaSourceFile cu = (JavaSourceFile)super.visit(tree, (Object)ctx);
            Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
            if (!maybeGp.isPresent()) {
                return cu;
            }
            GradleProject gp = (GradleProject)maybeGp.get();
            GradleDependencyConfiguration gdc = gp.getConfiguration(this.configuration);
            if (gdc == null || gdc.findRequestedDependency(this.groupId, this.artifactId) != null) {
                return cu;
            }
            boolean dependenciesBlockMissing = true;
            if (cu instanceof G.CompilationUnit) {
                g = (G.CompilationUnit)cu;
                for (Statement statement : g.getStatements()) {
                    if (!(statement instanceof J.MethodInvocation) || !DEPENDENCIES_DSL_MATCHER.matches((MethodCall)((J.MethodInvocation)statement))) continue;
                    dependenciesBlockMissing = false;
                }
            } else if (cu instanceof K.CompilationUnit) {
                k = (K.CompilationUnit)cu;
                for (Statement statement : ((J.Block)k.getStatements().get(0)).getStatements()) {
                    if (!(statement instanceof J.MethodInvocation) || !((J.MethodInvocation)statement).getSimpleName().equals("dependencies")) continue;
                    dependenciesBlockMissing = false;
                }
            }
            if (dependenciesBlockMissing) {
                Cursor parent;
                Statement dependenciesInvocation;
                if (cu instanceof G.CompilationUnit) {
                    g = (G.CompilationUnit)cu;
                    dependenciesInvocation = (Statement)GRADLE_PARSER.parse(ctx, new String[]{"dependencies {}"}).findFirst().map(G.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0);
                    parent = this.getCursor();
                    this.setCursor(new Cursor(parent, (Object)g));
                    dependenciesInvocation = (Statement)this.autoFormat((J)dependenciesInvocation, ctx, new Cursor(parent, (Object)g));
                    this.setCursor(parent);
                    cu = g.withStatements(ListUtils.concat((List)g.getStatements(), (Object)(g.getStatements().isEmpty() ? dependenciesInvocation : (Statement)dependenciesInvocation.withPrefix(Space.format((String)"\n\n")))));
                } else {
                    k = (K.CompilationUnit)cu;
                    dependenciesInvocation = (J.MethodInvocation)((J.Block)GRADLE_PARSER.parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle.kts", new String[0]), () -> new ByteArrayInputStream("dependencies {}".getBytes(StandardCharsets.UTF_8)))), null, ctx).findFirst().map(K.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0)).getStatements().get(0);
                    parent = this.getCursor();
                    this.setCursor(new Cursor(parent, (Object)k));
                    dependenciesInvocation = (J.MethodInvocation)this.autoFormat((J)dependenciesInvocation, ctx, new Cursor(this.getCursor(), (Object)k));
                    this.setCursor(parent);
                    dependenciesInvocation = dependenciesInvocation.withArguments(ListUtils.mapFirst((List)dependenciesInvocation.getArguments(), arg -> {
                        J.Lambda lambda = (J.Lambda)Objects.requireNonNull(arg);
                        J.Block block = (J.Block)lambda.getBody();
                        return lambda.withBody((J)block.withEnd(Space.format((String)"\n")));
                    }));
                    cu = k.withStatements(ListUtils.concat((List)k.getStatements(), (Object)(k.getStatements().isEmpty() ? dependenciesInvocation : dependenciesInvocation.withPrefix(Space.format((String)"\n\n")))));
                }
            }
            if ((cu = (JavaSourceFile)new InsertDependencyInOrder(this.configuration, gp).visitNonNull((Tree)cu, ctx)) != tree) {
                String versionWithPattern = StringUtils.isBlank((String)this.resolvedVersion) || this.resolvedVersion.startsWith("$") ? null : this.resolvedVersion;
                cu = AddDependencyVisitor.addDependency(cu, gdc, new GroupArtifactVersion(this.groupId, this.artifactId, versionWithPattern), this.classifier, ctx);
            }
            return cu;
        }
        return (J)super.visit(tree, (Object)ctx);
    }

    static JavaSourceFile addDependency(JavaSourceFile buildScript, @Nullable GradleDependencyConfiguration configuration, GroupArtifactVersion gav, @Nullable String classifier, ExecutionContext ctx) {
        if (gav.getGroupId() == null || gav.getArtifactId() == null || configuration == null) {
            return buildScript;
        }
        GradleProject gp = (GradleProject)buildScript.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Could not find GradleProject"));
        try {
            List transitiveDependencies;
            ResolvedGroupArtifactVersion resolvedGav;
            if (gav.getVersion() == null) {
                resolvedGav = null;
                transitiveDependencies = Collections.emptyList();
            } else {
                MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                Pom pom = mpd.download(gav, null, null, gp.getMavenRepositories());
                ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), mpd, gp.getMavenRepositories(), ctx);
                resolvedGav = resolvedPom.getGav();
                transitiveDependencies = resolvedPom.resolveDependencies(Scope.Runtime, mpd, ctx);
            }
            Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
            HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
            Set configurationsToAdd = Stream.concat(Stream.of(configuration), gp.configurationsExtendingFrom(configuration, true).stream()).collect(Collectors.toSet());
            for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                if (!configurationsToAdd.contains(gdc)) {
                    newNameToConfiguration.put(gdc.getName(), gdc);
                    continue;
                }
                GradleDependencyConfiguration newGdc = gdc;
                Dependency newRequested = new Dependency(gav, classifier, "jar", gdc.getName(), Collections.emptyList(), null);
                if ((newGdc = newGdc.withRequested(ListUtils.concat((List)ListUtils.map(gdc.getRequested(), requested -> {
                    if (Objects.equals(requested.getGroupId(), gav.getGroupId()) && Objects.equals(requested.getArtifactId(), gav.getArtifactId())) {
                        return null;
                    }
                    return requested;
                }), (Object)newRequested))).isCanBeResolved() && resolvedGav != null) {
                    newGdc = newGdc.withDirectResolved(ListUtils.concat((List)ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        if (Objects.equals(resolved.getGroupId(), resolvedGav.getGroupId()) && Objects.equals(resolved.getArtifactId(), resolvedGav.getArtifactId())) {
                            return null;
                        }
                        return resolved;
                    }), (Object)new ResolvedDependency(null, resolvedGav, newRequested, transitiveDependencies, Collections.emptyList(), "jar", classifier, null, 0, null)));
                }
                newNameToConfiguration.put(newGdc.getName(), newGdc);
            }
            gp = gp.withNameToConfiguration(newNameToConfiguration);
        }
        catch (IllegalArgumentException | MavenDownloadingException | MavenDownloadingExceptions e) {
            return (JavaSourceFile)Markup.warn((Tree)buildScript, (Throwable)e);
        }
        return (JavaSourceFile)buildScript.withMarkers(buildScript.getMarkers().setByType((Marker)gp));
    }

    private String escapeIfNecessary(String configurationName) {
        return configurationName.equals("default") ? "'" + configurationName + "'" : configurationName;
    }

    private DependencyStyle autodetectDependencyStyle(List<Statement> statements) {
        int string = 0;
        int map = 0;
        for (Statement statement : statements) {
            J.MethodInvocation invocation;
            if (statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof J.MethodInvocation) {
                invocation = (J.MethodInvocation)((J.Return)statement).getExpression();
                if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                    ++string;
                    continue;
                }
                if (invocation.getArguments().get(0) instanceof G.MapEntry) {
                    ++map;
                    continue;
                }
                if (!(invocation.getArguments().get(0) instanceof J.Assignment)) continue;
                ++map;
                continue;
            }
            if (!(statement instanceof J.MethodInvocation)) continue;
            invocation = (J.MethodInvocation)statement;
            if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                ++string;
                continue;
            }
            if (invocation.getArguments().get(0) instanceof G.MapEntry) {
                ++map;
                continue;
            }
            if (!(invocation.getArguments().get(0) instanceof J.Assignment)) continue;
            ++map;
        }
        return string >= map ? DependencyStyle.String : DependencyStyle.Map;
    }

    @Generated
    public AddDependencyVisitor(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, String configuration, @Nullable String classifier, @Nullable String extension, @Nullable MavenMetadataFailures metadataFailures, @Nullable Predicate<Cursor> insertPredicate) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.classifier = classifier;
        this.extension = extension;
        this.metadataFailures = metadataFailures;
        this.insertPredicate = insertPredicate;
    }

    static enum DependencyStyle {
        Map,
        String;

    }

    private class InsertDependencyInOrder
    extends JavaIsoVisitor<ExecutionContext> {
        private final String configuration;
        private final GradleProject gp;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            int i;
            J.Block body;
            DependencyStyle style;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            boolean isKotlinDsl = this.getCursor().firstEnclosing(JavaSourceFile.class) instanceof K.CompilationUnit;
            if (!(DEPENDENCIES_DSL_MATCHER.matches((MethodCall)m) || isKotlinDsl && m.getSimpleName().equals("dependencies"))) {
                return m;
            }
            if (AddDependencyVisitor.this.insertPredicate != null && !AddDependencyVisitor.this.insertPredicate.test(this.getCursor())) {
                return m;
            }
            J.Lambda dependenciesBlock = (J.Lambda)m.getArguments().get(0);
            if (!(dependenciesBlock.getBody() instanceof J.Block)) {
                return m;
            }
            if (AddDependencyVisitor.this.version != null) {
                if (AddDependencyVisitor.this.version.startsWith("$")) {
                    AddDependencyVisitor.this.resolvedVersion = AddDependencyVisitor.this.version;
                } else {
                    try {
                        AddDependencyVisitor.this.resolvedVersion = new DependencyVersionSelector(AddDependencyVisitor.this.metadataFailures, this.gp, null).select(new GroupArtifact(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId), this.configuration, AddDependencyVisitor.this.version, AddDependencyVisitor.this.versionPattern, ctx);
                    }
                    catch (MavenDownloadingException e) {
                        return (J.MethodInvocation)e.warn((Tree)m);
                    }
                }
            }
            String codeTemplate = (style = AddDependencyVisitor.this.autodetectDependencyStyle((body = (J.Block)dependenciesBlock.getBody()).getStatements())) == DependencyStyle.String ? (!isKotlinDsl ? "dependencies {\n" + AddDependencyVisitor.this.escapeIfNecessary(this.configuration) + " \"" + AddDependencyVisitor.this.groupId + ":" + AddDependencyVisitor.this.artifactId + (AddDependencyVisitor.this.resolvedVersion == null ? "" : ":" + AddDependencyVisitor.this.resolvedVersion) + (AddDependencyVisitor.this.resolvedVersion == null || AddDependencyVisitor.this.classifier == null ? "" : ":" + AddDependencyVisitor.this.classifier) + (AddDependencyVisitor.this.extension == null ? "" : "@" + AddDependencyVisitor.this.extension) + "\"\n}" : "dependencies {\n" + this.configuration + "(\"" + AddDependencyVisitor.this.groupId + ":" + AddDependencyVisitor.this.artifactId + (AddDependencyVisitor.this.resolvedVersion == null ? "" : ":" + AddDependencyVisitor.this.resolvedVersion) + (AddDependencyVisitor.this.resolvedVersion == null || AddDependencyVisitor.this.classifier == null ? "" : ":" + AddDependencyVisitor.this.classifier) + (AddDependencyVisitor.this.extension == null ? "" : "@" + AddDependencyVisitor.this.extension) + "\")\n}") : (!isKotlinDsl ? "dependencies {\n" + AddDependencyVisitor.this.escapeIfNecessary(this.configuration) + " group: \"" + AddDependencyVisitor.this.groupId + "\", name: \"" + AddDependencyVisitor.this.artifactId + "\"" + (AddDependencyVisitor.this.resolvedVersion == null ? "" : ", version: \"" + AddDependencyVisitor.this.resolvedVersion + "\"") + (AddDependencyVisitor.this.classifier == null ? "" : ", classifier: \"" + AddDependencyVisitor.this.classifier + "\"") + (AddDependencyVisitor.this.extension == null ? "" : ", ext: \"" + AddDependencyVisitor.this.extension + "\"") + "\n}" : "dependencies {\n" + this.configuration + "(group = \"" + AddDependencyVisitor.this.groupId + "\", name = \"" + AddDependencyVisitor.this.artifactId + "\"" + (AddDependencyVisitor.this.resolvedVersion == null ? "" : ", version = \"" + AddDependencyVisitor.this.resolvedVersion + "\"") + (AddDependencyVisitor.this.classifier == null ? "" : ", classifier = \"" + AddDependencyVisitor.this.classifier + "\"") + (AddDependencyVisitor.this.extension == null ? "" : ", ext = \"" + AddDependencyVisitor.this.extension + "\"") + ")\n}");
            Boolean requirePrintEqualsInput = (Boolean)ctx.getMessage("org.openrewrite.requirePrintEqualsInput");
            ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
            SourceFile parsed = !isKotlinDsl ? (SourceFile)GRADLE_PARSER.parse(ctx, new String[]{codeTemplate}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")) : GRADLE_PARSER.parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle.kts", new String[0]), () -> new ByteArrayInputStream(codeTemplate.getBytes(StandardCharsets.UTF_8)))), null, ctx).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
            ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)requirePrintEqualsInput);
            if (parsed instanceof ParseError) {
                throw ((ParseError)parsed).toException();
            }
            J.MethodInvocation addDependencyInvocation = !isKotlinDsl ? Objects.requireNonNull((J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)((J.MethodInvocation)((G.CompilationUnit)parsed).getStatements().get(0)).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression()) : Objects.requireNonNull((J.MethodInvocation)((J.Block)((J.Lambda)((J.MethodInvocation)((J.Block)((K.CompilationUnit)parsed).getStatements().get(0)).getStatements().get(0)).getArguments().get(0)).getBody()).getStatements().get(0));
            addDependencyInvocation = (J.MethodInvocation)this.autoFormat((J)addDependencyInvocation, ctx, new Cursor(this.getCursor(), (Object)body));
            InsertDependencyComparator dependencyComparator = new InsertDependencyComparator(body.getStatements(), addDependencyInvocation);
            ArrayList<Object> statements = new ArrayList<Object>(body.getStatements());
            for (i = 0; i < body.getStatements().size(); ++i) {
                Statement currentStatement = (Statement)body.getStatements().get(i);
                if (dependencyComparator.compare(currentStatement, (Statement)addDependencyInvocation) <= 0) continue;
                if (dependencyComparator.getBeforeDependency() != null) {
                    J.MethodInvocation beforeDependency = (J.MethodInvocation)(dependencyComparator.getBeforeDependency() instanceof J.Return ? (J)Objects.requireNonNull(((J.Return)dependencyComparator.getBeforeDependency()).getExpression()) : dependencyComparator.getBeforeDependency());
                    if (i == 0) {
                        if (!addDependencyInvocation.getSimpleName().equals(beforeDependency.getSimpleName())) {
                            statements.set(i, (Statement)currentStatement.withPrefix(Space.format((String)("\n\n" + currentStatement.getPrefix().getIndent()))));
                        }
                    } else {
                        Space originalPrefix = addDependencyInvocation.getPrefix();
                        if ((addDependencyInvocation = addDependencyInvocation.withPrefix(currentStatement.getPrefix())).getSimpleName().equals(beforeDependency.getSimpleName()) && !currentStatement.getPrefix().equals((Object)originalPrefix)) {
                            statements.set(i, (Statement)currentStatement.withPrefix(originalPrefix));
                        }
                    }
                }
                statements.add(i, addDependencyInvocation);
                break;
            }
            if (body.getStatements().size() == i) {
                if (!body.getStatements().isEmpty()) {
                    Statement lastStatement;
                    if (statements.get(i - 1) instanceof J.Return) {
                        J.Return r = (J.Return)statements.remove(i - 1);
                        lastStatement = (Statement)Objects.requireNonNull(r.getExpression()).withPrefix(r.getPrefix());
                        statements.add(lastStatement);
                    } else {
                        lastStatement = (Statement)statements.get(i - 1);
                    }
                    if (lastStatement instanceof J.MethodInvocation && !((J.MethodInvocation)lastStatement).getSimpleName().equals(addDependencyInvocation.getSimpleName())) {
                        addDependencyInvocation = addDependencyInvocation.withPrefix(Space.format((String)("\n\n" + addDependencyInvocation.getPrefix().getIndent())));
                    }
                }
                statements.add(addDependencyInvocation);
            }
            body = body.withStatements(statements);
            m = m.withArguments(Collections.singletonList(dependenciesBlock.withBody((J)body)));
            return m;
        }

        @Generated
        public InsertDependencyInOrder(String configuration, GradleProject gp) {
            this.configuration = configuration;
            this.gp = gp;
        }
    }
}

