/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.Traits;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestIntegration;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class RemoveRedundantDependencyVersions
extends Recipe {
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.*", required=false)
    private final @Nullable String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava*", required=false)
    private final @Nullable String artifactPattern;
    @Option(displayName="Only if managed version is ...", description="Only remove the explicit version if the managed version has the specified comparative relationship to the explicit version. For example, `gte` will only remove the explicit version if the managed version is the same or newer. Default `eq`.", valid={"ANY", "EQ", "LT", "LTE", "GT", "GTE"}, required=false)
    private final @Nullable Comparator onlyIfManagedVersionIs;
    private static final List<String> DEPENDENCY_MANAGEMENT_METHODS = Arrays.asList("api", "implementation", "compileOnly", "runtimeOnly", "testImplementation", "testCompileOnly", "testRuntimeOnly", "debugImplementation", "releaseImplementation", "androidTestImplementation", "featureImplementation", "annotationProcessor", "kapt", "ksp", "compile", "runtime", "testCompile", "testRuntime");
    private static final VersionComparator VERSION_COMPARATOR = Objects.requireNonNull((VersionComparator)Semver.validate((String)"latest.release", null).getValue());

    public String getDisplayName() {
        return "Remove redundant explicit dependencies and versions";
    }

    public String getDescription() {
        return "Remove explicitly-specified dependencies and dependency versions that are managed by a Gradle `platform`/`enforcedPlatform`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            GradleProject gp;
            final Map<String, List<ResolvedPom>> platforms = new HashMap<String, List<ResolvedPom>>();
            final List<ResolvedDependency> directDependencies = new ArrayList<ResolvedDependency>();

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    Optional maybeGp = tree.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return (J)tree;
                    }
                    this.gp = (GradleProject)maybeGp.get();
                    new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                            new GradleDependency.Matcher().groupId(RemoveRedundantDependencyVersions.this.groupPattern).artifactId(RemoveRedundantDependencyVersions.this.artifactPattern).get(this.getCursor()).ifPresent(it -> directDependencies.add(it.getResolvedDependency()));
                            if (!m.getSimpleName().equals("platform") && !m.getSimpleName().equals("enforcedPlatform")) {
                                return m;
                            }
                            GroupArtifactVersion gav = null;
                            if (m.getArguments().get(0) instanceof J.Literal) {
                                J.Literal l = (J.Literal)m.getArguments().get(0);
                                if (l.getType() == JavaType.Primitive.String) {
                                    Dependency dependency = DependencyStringNotationConverter.parse((String)l.getValue());
                                    gav = new GroupArtifactVersion(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                                }
                            } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                                String groupId = null;
                                String artifactId = null;
                                String version = null;
                                for (Expression arg : m.getArguments()) {
                                    if (!(arg instanceof G.MapEntry) || ((G.MapEntry)arg).getKey().getType() != JavaType.Primitive.String || ((G.MapEntry)arg).getValue().getType() != JavaType.Primitive.String) continue;
                                    Object key = ((J.Literal)((G.MapEntry)arg).getKey()).getValue();
                                    if ("group".equals(key)) {
                                        groupId = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                        continue;
                                    }
                                    if ("name".equals(key)) {
                                        artifactId = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                        continue;
                                    }
                                    if (!"version".equals(key)) continue;
                                    version = (String)((J.Literal)((G.MapEntry)arg).getValue()).getValue();
                                }
                                if (groupId != null && artifactId != null && version != null) {
                                    gav = new GroupArtifactVersion(groupId, artifactId, version);
                                }
                            }
                            if (gav != null) {
                                MavenPomDownloader mpd = new MavenPomDownloader(ctx);
                                try {
                                    ResolvedPom platformPom = mpd.download(gav, null, null, gp.getMavenRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                                    platforms.computeIfAbsent(((J.MethodInvocation)this.getCursor().getParentOrThrow(1).firstEnclosingOrThrow(J.MethodInvocation.class)).getSimpleName(), k -> new ArrayList()).add(platformPom);
                                }
                                catch (MavenDownloadingException mavenDownloadingException) {
                                    // empty catch block
                                }
                            }
                            return m;
                        }
                    }.visit(tree, (Object)ctx);
                    tree = new JavaIsoVisitor<ExecutionContext>(){

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                            if (m.getSimpleName().equals("constraints")) {
                                if (m.getArguments().isEmpty() || !(m.getArguments().get(0) instanceof J.Lambda) || !(((J.Lambda)m.getArguments().get(0)).getBody() instanceof J.Block)) {
                                    return m;
                                }
                                if (((J.Block)((J.Lambda)m.getArguments().get(0)).getBody()).getStatements().isEmpty()) {
                                    return null;
                                }
                                return m;
                            }
                            if (!this.isDependencyManagmentMethod(m.getSimpleName()) || m.getArguments().isEmpty() || ((Expression)m.getArguments().get(0)).getType() != JavaType.Primitive.String) {
                                return m;
                            }
                            String value = (String)((J.Literal)m.getArguments().get(0)).getValue();
                            Dependency dependency = DependencyStringNotationConverter.parse(value);
                            try {
                                Object parent = this.getCursor().dropParentUntil(obj -> obj instanceof J.MethodInvocation && ((J.MethodInvocation)obj).getSimpleName().equals("constraints")).getValue();
                                if (parent != null && this.shouldRemoveRedundantConstraint(dependency, gp.getConfiguration(m.getSimpleName()))) {
                                    return null;
                                }
                                return m;
                            }
                            catch (Exception exception) {
                                if (this.shouldRemoveRedundantDependency(dependency, m.getSimpleName())) {
                                    return null;
                                }
                                return m;
                            }
                        }

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
                            J.Return r = super.visitReturn(_return, (Object)ctx);
                            if (r.getExpression() == null) {
                                return null;
                            }
                            return r;
                        }

                        private boolean isDependencyManagmentMethod(String methodName) {
                            return DEPENDENCY_MANAGEMENT_METHODS.contains(methodName);
                        }

                        private boolean shouldRemoveRedundantDependency(Dependency dependency, String configurationName) {
                            if (platforms == null || platforms.get(configurationName) == null || platforms.get(configurationName).isEmpty()) {
                                return false;
                            }
                            if (RemoveRedundantDependencyVersions.this.groupPattern != null && !StringUtils.matchesGlob((String)dependency.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern) || RemoveRedundantDependencyVersions.this.artifactPattern != null && !StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern)) {
                                return false;
                            }
                            String dependencyManagedVersion = platforms.get(configurationName).stream().map(e -> e.getManagedDependency(dependency.getGroupId(), dependency.getArtifactId(), null, null)).filter(Objects::nonNull).map(ResolvedManagedDependency::getVersion).max((java.util.Comparator<String>)VERSION_COMPARATOR).orElse(null);
                            for (ResolvedDependency d : directDependencies) {
                                ResolvedDependency resolvedDependency;
                                if (d.getGroupId().equals(dependency.getGroupId()) && d.getArtifactId().equals(dependency.getArtifactId()) || d.getDependencies() == null || (resolvedDependency = d.findDependency(dependency.getGroupId(), dependency.getArtifactId())) == null || dependency.getVersion() != null && VERSION_COMPARATOR.compare(dependency.getVersion(), dependencyManagedVersion) > 0) continue;
                                return true;
                            }
                            return false;
                        }

                        boolean shouldRemoveRedundantConstraint(@Nullable Dependency constraint, @Nullable GradleDependencyConfiguration c) {
                            if (c == null || constraint == null || constraint.getVersion() == null) {
                                return false;
                            }
                            if (constraint.getVersion().contains("[") || constraint.getVersion().contains("!!")) {
                                return false;
                            }
                            if (RemoveRedundantDependencyVersions.this.groupPattern != null && !StringUtils.matchesGlob((String)constraint.getGroupId(), (String)RemoveRedundantDependencyVersions.this.groupPattern) || RemoveRedundantDependencyVersions.this.artifactPattern != null && !StringUtils.matchesGlob((String)constraint.getArtifactId(), (String)RemoveRedundantDependencyVersions.this.artifactPattern)) {
                                return false;
                            }
                            return Stream.concat(Stream.of(c), gp.configurationsExtendingFrom(c, true).stream()).filter(GradleDependencyConfiguration::isCanBeResolved).distinct().map(conf -> conf.findResolvedDependency(Objects.requireNonNull(constraint.getGroupId()), constraint.getArtifactId())).filter(Objects::nonNull).anyMatch(resolvedDependency -> VERSION_COMPARATOR.compare(null, resolvedDependency.getVersion(), constraint.getVersion()) > 0);
                        }
                    }.visitNonNull(tree, (Object)ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                GradleDependencyConfiguration gdc;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                Optional maybeGradleDependency = Traits.gradleDependency().groupId(RemoveRedundantDependencyVersions.this.groupPattern).artifactId(RemoveRedundantDependencyVersions.this.artifactPattern).get(this.getCursor());
                if (!maybeGradleDependency.isPresent()) {
                    return m;
                }
                GradleDependency gradleDependency = (GradleDependency)maybeGradleDependency.get();
                ResolvedDependency dep = gradleDependency.getResolvedDependency();
                if (StringUtils.isBlank((String)dep.getVersion())) {
                    return m;
                }
                if (this.platforms.containsKey(m.getSimpleName())) {
                    for (ResolvedPom platform : this.platforms.get(m.getSimpleName())) {
                        String managedVersion = platform.getManagedVersion(dep.getGroupId(), dep.getArtifactId(), null, dep.getRequested().getClassifier());
                        if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, dep.getVersion())) continue;
                        return this.maybeRemoveVersion(m);
                    }
                }
                if ((gdc = this.gp.getConfiguration(m.getSimpleName())) != null) {
                    for (GradleDependencyConfiguration configuration : gdc.allExtendsFrom()) {
                        if (!this.platforms.containsKey(configuration.getName())) continue;
                        for (ResolvedPom platform : this.platforms.get(configuration.getName())) {
                            String managedVersion = platform.getManagedVersion(dep.getGroupId(), dep.getArtifactId(), null, dep.getRequested().getClassifier());
                            if (!RemoveRedundantDependencyVersions.this.matchesComparator(managedVersion, dep.getVersion())) continue;
                            return this.maybeRemoveVersion(m);
                        }
                    }
                }
                return m;
            }

            private J.MethodInvocation maybeRemoveVersion(J.MethodInvocation m) {
                if (m.getArguments().get(0) instanceof J.Literal) {
                    J.Literal l = (J.Literal)m.getArguments().get(0);
                    if (l.getType() == JavaType.Primitive.String) {
                        Dependency dep = DependencyStringNotationConverter.parse((String)l.getValue());
                        if (dep == null || dep.getClassifier() != null || dep.getExt() != null) {
                            return m;
                        }
                        return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue(l, dep.withVersion(null).toStringNotation())));
                    }
                } else {
                    if (m.getArguments().get(0) instanceof G.MapLiteral) {
                        return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                            return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), entry -> {
                                if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                                    return null;
                                }
                                return entry;
                            }));
                        }));
                    }
                    if (m.getArguments().get(0) instanceof G.MapEntry) {
                        return m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            G.MapEntry entry = (G.MapEntry)arg;
                            if (entry.getKey() instanceof J.Literal && "version".equals(((J.Literal)entry.getKey()).getValue())) {
                                return null;
                            }
                            return entry;
                        }));
                    }
                }
                return m;
            }
        });
    }

    private Comparator determineComparator() {
        if (this.onlyIfManagedVersionIs != null) {
            return this.onlyIfManagedVersionIs;
        }
        return Comparator.EQ;
    }

    private boolean matchesComparator(@Nullable String managedVersion, String requestedVersion) {
        Comparator comparator = this.determineComparator();
        if (managedVersion == null) {
            return false;
        }
        if (comparator == Comparator.ANY) {
            return true;
        }
        if (!this.isExact(managedVersion)) {
            return false;
        }
        int comparison = new LatestIntegration(null).compare(null, managedVersion, requestedVersion);
        if (comparison < 0) {
            return comparator == Comparator.LT || comparator == Comparator.LTE;
        }
        if (comparison > 0) {
            return comparator == Comparator.GT || comparator == Comparator.GTE;
        }
        return comparator == Comparator.EQ || comparator == Comparator.LTE || comparator == Comparator.GTE;
    }

    private boolean isExact(String managedVersion) {
        Validated maybeVersionComparator = Semver.validate((String)managedVersion, null);
        return maybeVersionComparator.isValid() && maybeVersionComparator.getValue() instanceof ExactVersion;
    }

    @Generated
    public RemoveRedundantDependencyVersions(@Nullable String groupPattern, @Nullable String artifactPattern, @Nullable Comparator onlyIfManagedVersionIs) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.onlyIfManagedVersionIs = onlyIfManagedVersionIs;
    }

    @Generated
    public @Nullable String getGroupPattern() {
        return this.groupPattern;
    }

    @Generated
    public @Nullable String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Generated
    public @Nullable Comparator getOnlyIfManagedVersionIs() {
        return this.onlyIfManagedVersionIs;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRedundantDependencyVersions(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", onlyIfManagedVersionIs=" + (Object)((Object)this.getOnlyIfManagedVersionIs()) + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencyVersions)) {
            return false;
        }
        RemoveRedundantDependencyVersions other = (RemoveRedundantDependencyVersions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        if (this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern)) {
            return false;
        }
        Comparator this$onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        Comparator other$onlyIfManagedVersionIs = other.getOnlyIfManagedVersionIs();
        return !(this$onlyIfManagedVersionIs == null ? other$onlyIfManagedVersionIs != null : !((Object)((Object)this$onlyIfManagedVersionIs)).equals((Object)other$onlyIfManagedVersionIs));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveRedundantDependencyVersions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        Comparator $onlyIfManagedVersionIs = this.getOnlyIfManagedVersionIs();
        result = result * 59 + ($onlyIfManagedVersionIs == null ? 43 : ((Object)((Object)$onlyIfManagedVersionIs)).hashCode());
        return result;
    }

    public static enum Comparator {
        ANY,
        EQ,
        LT,
        LTE,
        GT,
        GTE;

    }
}

