/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.table.JVMTestSuitesDefined;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SearchResult;

public final class FindJVMTestSuites
extends Recipe {
    private final transient JVMTestSuitesDefined jvmTestSuitesDefined = new JVMTestSuitesDefined(this);
    @Option(displayName="Requires dependencies", description="Whether the test suite configuration defines dependencies to be resolved. Defaults to false.")
    private final @Nullable Boolean definesDependencies;
    @Option(displayName="Insert rows", description="Whether to insert rows into the table. Defaults to true.")
    private final @Nullable Boolean insertRows;

    public String getDisplayName() {
        return "Find Gradle JVMTestSuite plugin configuration";
    }

    public String getDescription() {
        return "Find Gradle JVMTestSuite plugin configurations and produce a data table.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final boolean requireDependencies = this.definesDependencies != null && this.definesDependencies != false;
        final boolean tableAvailable = this.insertRows == null || this.insertRows != false;
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            private boolean isJVMTestSuitesBlock() {
                Cursor parent = this.getCursor().getParent();
                if (parent != null) {
                    Iterator path = parent.getPath(J.MethodInvocation.class::isInstance);
                    if (path.hasNext() && "suites".equals(((J.MethodInvocation)path.next()).getSimpleName())) {
                        return path.hasNext() && "testing".equals(((J.MethodInvocation)path.next()).getSimpleName());
                    }
                }
                return false;
            }

            private boolean definesDependencies(J.MethodInvocation suite) {
                for (Expression suiteDefinition : suite.getArguments()) {
                    if (!(suiteDefinition instanceof J.Lambda)) continue;
                    for (Statement statement : ((J.Block)((J.Lambda)suiteDefinition).getBody()).getStatements()) {
                        Expression expression;
                        if (!(statement instanceof J.Return) || !((expression = ((J.Return)statement).getExpression()) instanceof J.MethodInvocation) || !"dependencies".equals(((J.MethodInvocation)expression).getSimpleName())) continue;
                        return true;
                    }
                }
                return false;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (this.isJVMTestSuitesBlock()) {
                    if (tableAvailable) {
                        FindJVMTestSuites.this.jvmTestSuitesDefined.insertRow(ctx, new JVMTestSuitesDefined.Row(method.getSimpleName()));
                    }
                    return !requireDependencies || this.definesDependencies(method) ? (J.MethodInvocation)SearchResult.found((Tree)method) : method;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    public static Set<String> jvmTestSuiteNames(Tree tree, boolean definesDependencies) {
        return ((HashSet)TreeVisitor.collect(new FindJVMTestSuites(definesDependencies, false).getVisitor(), (Tree)tree, new HashSet())).stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m -> m.getMarkers().findFirst(SearchResult.class).isPresent()).map(J.MethodInvocation::getSimpleName).collect(Collectors.toSet());
    }

    @Generated
    public FindJVMTestSuites(@Nullable Boolean definesDependencies, @Nullable Boolean insertRows) {
        this.definesDependencies = definesDependencies;
        this.insertRows = insertRows;
    }

    @Generated
    public JVMTestSuitesDefined getJvmTestSuitesDefined() {
        return this.jvmTestSuitesDefined;
    }

    @Generated
    public @Nullable Boolean getDefinesDependencies() {
        return this.definesDependencies;
    }

    @Generated
    public @Nullable Boolean getInsertRows() {
        return this.insertRows;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindJVMTestSuites(jvmTestSuitesDefined=" + (Object)((Object)this.getJvmTestSuitesDefined()) + ", definesDependencies=" + this.getDefinesDependencies() + ", insertRows=" + this.getInsertRows() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindJVMTestSuites)) {
            return false;
        }
        FindJVMTestSuites other = (FindJVMTestSuites)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$definesDependencies = this.getDefinesDependencies();
        Boolean other$definesDependencies = other.getDefinesDependencies();
        if (this$definesDependencies == null ? other$definesDependencies != null : !((Object)this$definesDependencies).equals(other$definesDependencies)) {
            return false;
        }
        Boolean this$insertRows = this.getInsertRows();
        Boolean other$insertRows = other.getInsertRows();
        return !(this$insertRows == null ? other$insertRows != null : !((Object)this$insertRows).equals(other$insertRows));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindJVMTestSuites;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $definesDependencies = this.getDefinesDependencies();
        result = result * 59 + ($definesDependencies == null ? 43 : ((Object)$definesDependencies).hashCode());
        Boolean $insertRows = this.getInsertRows();
        result = result * 59 + ($insertRows == null ? 43 : ((Object)$insertRows).hashCode());
        return result;
    }
}

