/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class AddLiteralMethodArgument
extends Recipe {
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="com.yourorg.A foo(int, int)")
    private final String methodPattern;
    @Option(displayName="Argument index", description="A zero-based index that indicates which argument will be added as null to the method invocation.", example="0")
    private final int argumentIndex;
    @Option(displayName="Literal", description="The literal value that we add the argument for.", example="abc")
    private final Object literal;
    @Option(displayName="Parameter type", description="The type of the parameter that we add the argument for. Defaults to `String`.", required=false, example="String", valid={"String", "int", "short", "long", "float", "double", "boolean", "char"})
    private final @Nullable String primitiveType;

    public String getInstanceNameSuffix() {
        return String.format("%d in methods `%s`", this.argumentIndex, this.methodPattern);
    }

    public String getDisplayName() {
        return "Add a literal method argument";
    }

    public String getDescription() {
        return "Add a literal `String` or `int` argument to method invocations.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new AddLiteralMethodArgumentVisitor(new MethodMatcher(this.methodPattern)));
    }

    @Generated
    public AddLiteralMethodArgument(String methodPattern, int argumentIndex, Object literal, @Nullable String primitiveType) {
        this.methodPattern = methodPattern;
        this.argumentIndex = argumentIndex;
        this.literal = literal;
        this.primitiveType = primitiveType;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    @Generated
    public Object getLiteral() {
        return this.literal;
    }

    @Generated
    public @Nullable String getPrimitiveType() {
        return this.primitiveType;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddLiteralMethodArgument(methodPattern=" + this.getMethodPattern() + ", argumentIndex=" + this.getArgumentIndex() + ", literal=" + this.getLiteral() + ", primitiveType=" + this.getPrimitiveType() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddLiteralMethodArgument)) {
            return false;
        }
        AddLiteralMethodArgument other = (AddLiteralMethodArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getArgumentIndex() != other.getArgumentIndex()) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        Object this$literal = this.getLiteral();
        Object other$literal = other.getLiteral();
        if (this$literal == null ? other$literal != null : !this$literal.equals(other$literal)) {
            return false;
        }
        String this$primitiveType = this.getPrimitiveType();
        String other$primitiveType = other.getPrimitiveType();
        return !(this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddLiteralMethodArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArgumentIndex();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        Object $literal = this.getLiteral();
        result = result * 59 + ($literal == null ? 43 : $literal.hashCode());
        String $primitiveType = this.getPrimitiveType();
        result = result * 59 + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        return result;
    }

    private class AddLiteralMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public AddLiteralMethodArgumentVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            return (J.MethodInvocation)this.visitMethodCall((MethodCall)m);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            return (J.NewClass)this.visitMethodCall((MethodCall)n);
        }

        private MethodCall visitMethodCall(MethodCall methodCall) {
            MethodCall m = methodCall;
            List<Expression> originalArgs = m.getArguments();
            if (this.methodMatcher.matches(m) && (long)originalArgs.size() >= (long)AddLiteralMethodArgument.this.argumentIndex) {
                String valueSource;
                JavaType.Primitive primitive;
                ArrayList<Expression> args = new ArrayList<Expression>(originalArgs);
                if (args.size() == 1 && args.get(0) instanceof J.Empty) {
                    args.remove(0);
                }
                if (StringUtils.isBlank((CharSequence)AddLiteralMethodArgument.this.primitiveType) || "string".equalsIgnoreCase(AddLiteralMethodArgument.this.primitiveType)) {
                    primitive = JavaType.Primitive.String;
                    valueSource = String.format("\"%s\"", AddLiteralMethodArgument.this.getLiteral());
                } else if (AddLiteralMethodArgument.this.primitiveType.equalsIgnoreCase("char")) {
                    primitive = JavaType.Primitive.Char;
                    valueSource = String.format("'%s'", AddLiteralMethodArgument.this.getLiteral());
                } else {
                    primitive = JavaType.Primitive.fromKeyword(AddLiteralMethodArgument.this.primitiveType.toLowerCase());
                    valueSource = String.valueOf(AddLiteralMethodArgument.this.getLiteral());
                }
                J.Literal literal = new J.Literal(Tree.randomId(), args.isEmpty() ? Space.EMPTY : Space.SINGLE_SPACE, Markers.EMPTY, AddLiteralMethodArgument.this.getLiteral(), valueSource, null, primitive);
                m = m.withArguments(ListUtils.insert(args, (Object)literal, (int)AddLiteralMethodArgument.this.argumentIndex));
                JavaType.Method methodType = m.getMethodType();
                if (methodType != null && (m = m.withMethodType(methodType.withParameterNames(ListUtils.insert(methodType.getParameterNames(), (Object)("arg" + AddLiteralMethodArgument.this.argumentIndex), (int)AddLiteralMethodArgument.this.argumentIndex)).withParameterTypes(ListUtils.insert(methodType.getParameterTypes(), (Object)primitive, (int)AddLiteralMethodArgument.this.argumentIndex)))) instanceof J.MethodInvocation && ((J.MethodInvocation)m).getName().getType() != null) {
                    m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withType(m.getMethodType()));
                }
            }
            return m;
        }
    }
}

