/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class SimplifySingleElementAnnotation
extends Recipe {
    public String getDisplayName() {
        return "Simplify single-element annotation";
    }

    public String getDescription() {
        return "This recipe will remove the attribute `value` on single-element annotations. According to JLS, a _single-element annotation_, is a shorthand designed for use with single-element annotation types.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
                J an = super.visitAnnotation(annotation, executionContext);
                if (((J.Annotation)an).getArguments() != null && ((J.Annotation)an).getArguments().size() == 1) {
                    an = ((J.Annotation)an).withArguments(ListUtils.mapFirst(((J.Annotation)an).getArguments(), v -> {
                        if (v instanceof J.Assignment && ((J.Assignment)v).getVariable() instanceof J.Identifier && "value".equals(((J.Identifier)((J.Assignment)v).getVariable()).getSimpleName())) {
                            J.NewArray na;
                            List<Expression> initializer;
                            Expression assignment = ((J.Assignment)v).getAssignment();
                            if (assignment instanceof J.NewArray && (initializer = (na = (J.NewArray)assignment).getInitializer()) != null && initializer.size() == 1 && !(initializer.get(0) instanceof J.Empty)) {
                                return (Expression)initializer.get(0).withPrefix(Space.EMPTY);
                            }
                            return (Expression)assignment.withPrefix(Space.EMPTY);
                        }
                        return v;
                    }));
                }
                return an;
            }
        };
    }
}

