/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class MavenRepositoryOrder
extends DataTable<Row> {
    public MavenRepositoryOrder(Recipe recipe) {
        super(recipe, Row.class, MavenRepositoryOrder.class.getName(), "Maven repository order", "The order in which dependencies will be resolved for each `pom.xml` based on its defined repositories and effective `settings.xml`.");
    }

    public static final class Row {
        @Column(displayName="Repository ID", description="The ID of the repository. Note that projects may define the same physical repository with different IDs.")
        private final String id;
        @Column(displayName="Repository URI", description="The URI of the repository.")
        private final String uri;
        @Column(displayName="Known to exist", description="If the repository is provably reachable. If false, does not guarantee that the repository does not exist.")
        private final boolean knownToExist;
        @Column(displayName="Rank", description="The index order of this repository in the repository list.")
        private final int rank;

        @Generated
        public Row(String id, String uri, boolean knownToExist, int rank) {
            this.id = id;
            this.uri = uri;
            this.knownToExist = knownToExist;
            this.rank = rank;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public boolean isKnownToExist() {
            return this.knownToExist;
        }

        @Generated
        public int getRank() {
            return this.rank;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isKnownToExist() != other.isKnownToExist()) {
                return false;
            }
            if (this.getRank() != other.getRank()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKnownToExist() ? 79 : 97);
            result = result * 59 + this.getRank();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenRepositoryOrder.Row(id=" + this.getId() + ", uri=" + this.getUri() + ", knownToExist=" + this.isKnownToExist() + ", rank=" + this.getRank() + ")";
        }
    }
}

