/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse(this);
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. All scopes are searched by default.", valid={"compile", "test", "runtime", "provided", "system"}, example="compile", required=false)
    private final @Nullable String scope;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Only direct", description="If enabled, transitive dependencies will not be considered. All dependencies are searched by default.", required=false, example="true")
    private final @Nullable Boolean onlyDirect;

    public Validated<Object> validate() {
        Validated v = super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> Scope.fromName(s) != Scope.Invalid));
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public String getDisplayName() {
        return "Maven dependency insight";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupIdPattern, this.artifactIdPattern);
    }

    public String getDescription() {
        return "Find direct and transitive dependencies matching a group, artifact, and scope. Results include dependencies that either directly match or transitively include a matching dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Scope aScope = this.scope == null ? null : Scope.fromName(this.scope);
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (!this.isDependencyTag()) {
                    return t;
                }
                ResolvedDependency dependency = this.findDependency(t, aScope);
                if (dependency == null) {
                    return t;
                }
                ResolvedDependency match = dependency.findDependency(DependencyInsight.this.groupIdPattern, DependencyInsight.this.artifactIdPattern);
                if (match == null) {
                    return t;
                }
                if (DependencyInsight.this.version != null) {
                    VersionComparator versionComparator = (VersionComparator)Semver.validate((String)DependencyInsight.this.version, null).getValue();
                    if (versionComparator == null) {
                        t = (Xml.Tag)Markup.warn((Tree)t, (Throwable)new IllegalArgumentException("Could not construct a valid version comparator from " + DependencyInsight.this.version + "."));
                    } else if (!versionComparator.isValid(null, match.getVersion())) {
                        return t;
                    }
                }
                if (match == dependency) {
                    t = (Xml.Tag)SearchResult.found((Tree)t);
                } else {
                    if (Boolean.TRUE.equals(DependencyInsight.this.onlyDirect)) {
                        return t;
                    }
                    t = (Xml.Tag)SearchResult.found((Tree)t, (String)match.getGav().toString());
                }
                Optional javaProject = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaProject.class);
                Optional javaSourceSet = ((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class)).getMarkers().findFirst(JavaSourceSet.class);
                DependencyInsight.this.dependenciesInUse.insertRow(ctx, new DependenciesInUse.Row(javaProject.map(JavaProject::getProjectName).orElse(""), javaSourceSet.map(JavaSourceSet::getName).orElse("main"), match.getGroupId(), match.getArtifactId(), match.getVersion(), match.getDatedSnapshotVersion(), StringUtils.isBlank((String)match.getRequested().getScope()) ? "compile" : match.getRequested().getScope(), match.getDepth(), null));
                return t;
            }
        };
    }

    @Generated
    public DependencyInsight(String groupIdPattern, String artifactIdPattern, @Nullable String scope, @Nullable String version, @Nullable Boolean onlyDirect) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.scope = scope;
        this.version = version;
        this.onlyDirect = onlyDirect;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable Boolean getOnlyDirect() {
        return this.onlyDirect;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + (Object)((Object)this.getDependenciesInUse()) + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", scope=" + this.getScope() + ", version=" + this.getVersion() + ", onlyDirect=" + this.getOnlyDirect() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$onlyDirect = this.getOnlyDirect();
        Boolean other$onlyDirect = other.getOnlyDirect();
        if (this$onlyDirect == null ? other$onlyDirect != null : !((Object)this$onlyDirect).equals(other$onlyDirect)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $onlyDirect = this.getOnlyDirect();
        result = result * 59 + ($onlyDirect == null ? 43 : ((Object)$onlyDirect).hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

