/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.MapTagChildrenVisitor;
import org.openrewrite.xml.SemanticallyEqual;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class AddOrUpdateChild<P>
extends XmlVisitor<P> {
    Xml.Tag scope;
    Xml.Tag child;

    @Override
    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, p);
        if (this.scope.isScope(tag)) {
            Optional<Xml.Tag> maybeChild = this.scope.getChild(this.child.getName());
            if (maybeChild.isPresent()) {
                if (SemanticallyEqual.areEqual(maybeChild.get(), this.child)) {
                    return t;
                }
                t = MapTagChildrenVisitor.mapChildren(t, it -> {
                    if (it == maybeChild.get()) {
                        return this.autoFormat(this.child.withPrefix(((Xml.Tag)maybeChild.get()).getPrefix()), p, this.getCursor());
                    }
                    return it;
                });
            } else {
                t = AddToTagVisitor.addToTag(t, this.child, this.getCursor().getParentOrThrow());
            }
        }
        return t;
    }

    public static Xml.Tag addOrUpdateChild(Xml.Tag parent, Xml.Tag child, Cursor parentCursor) {
        return AddOrUpdateChild.addOrUpdateChild(parent, parent, child, parentCursor);
    }

    public static Xml.Tag addOrUpdateChild(Xml.Tag parentScope, Xml.Tag parent, Xml.Tag child, Cursor parentCursor) {
        return (Xml.Tag)new AddOrUpdateChild(parent, child).visitNonNull(parentScope, null, parentCursor);
    }

    @Generated
    public AddOrUpdateChild(Xml.Tag scope, Xml.Tag child) {
        this.scope = scope;
        this.child = child;
    }
}

