/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnfoldProperties
extends Recipe {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    @Option(displayName="Exclusions", description="The keys which you do not want to unfold", example="org.springframework.security")
    private final List<String> exclusions;

    public UnfoldProperties(@Nullable List<String> exclusions) {
        this.exclusions = exclusions == null ? Collections.emptyList() : exclusions;
    }

    public String getDisplayName() {
        return "Unfold YAML properties";
    }

    public String getDescription() {
        return "Transforms dot-separated property keys in YAML files into nested map hierarchies to enhance clarity and readability, or for compatibility with tools expecting structured YAML.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry e, ExecutionContext ctx) {
                Yaml entry = super.visitMappingEntry(e, ctx);
                String key = ((Yaml.Mapping.Entry)entry).getKey().getValue();
                if (key.contains(".") && !UnfoldProperties.this.exclusions.contains(key)) {
                    String[] parts = key.split("\\.");
                    Yaml.Mapping.Entry nestedEntry = this.createNestedEntry(parts, 0, ((Yaml.Mapping.Entry)entry).getValue()).withPrefix(((Yaml.Mapping.Entry)entry).getPrefix());
                    Yaml.Mapping.Entry newEntry = this.maybeAutoFormat(entry, nestedEntry, ((Yaml.Mapping.Entry)entry).getValue(), ctx, this.getCursor());
                    if (this.shouldShift()) {
                        int identLevel = Math.abs(this.getIndentLevel((Yaml.Mapping.Entry)entry) - this.getIndentLevel(newEntry));
                        if (!StringUtils.hasLineBreak((String)((Yaml.Mapping.Entry)entry).getPrefix()) && StringUtils.hasLineBreak((String)newEntry.getPrefix())) {
                            newEntry = newEntry.withPrefix(this.substringOfAfterFirstLineBreak(((Yaml.Mapping.Entry)entry).getPrefix()));
                        }
                        this.doAfterVisit(new ShiftFormatLeftVisitor(newEntry, identLevel));
                    }
                    return newEntry;
                }
                return entry;
            }

            private Yaml.Mapping.Entry createNestedEntry(String[] keys, int index, Yaml.Block value) {
                if (index != keys.length - 1) {
                    Yaml.Mapping.Entry entry = this.createNestedEntry(keys, index + 1, value);
                    value = new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.singletonList(entry), null, null, null);
                }
                Yaml.Scalar key = new Yaml.Scalar(Tree.randomId(), "", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, null, keys[index]);
                return new Yaml.Mapping.Entry(Tree.randomId(), "", Markers.EMPTY, key, "", value);
            }

            private int getIndentLevel(Yaml.Mapping.Entry entry) {
                String[] parts = entry.getPrefix().split("\\R");
                return parts.length > 1 ? StringUtils.countOccurrences((String)parts[1], (String)" ") : 0;
            }

            private boolean shouldShift() {
                try {
                    this.getCursor().dropParentUntil(it -> it instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)it).getKey().getValue().contains("."));
                    return false;
                }
                catch (IllegalStateException ignored) {
                    return true;
                }
            }

            private String substringOfAfterFirstLineBreak(String s) {
                String[] lines = LINE_BREAK.split(s, -1);
                return lines.length > 1 ? String.join((CharSequence)"\n", Arrays.copyOfRange(lines, 1, lines.length)) : "";
            }
        };
    }

    @Generated
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UnfoldProperties(exclusions=" + this.getExclusions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnfoldProperties)) {
            return false;
        }
        UnfoldProperties other = (UnfoldProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UnfoldProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }
}

