/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.Visit;

public final class ObjectMerger {
    private final ObjectDiffer objectDiffer;

    public ObjectMerger() {
        this.objectDiffer = ObjectDifferBuilder.buildDefault();
    }

    public ObjectMerger(ObjectDiffer objectDiffer) {
        this.objectDiffer = objectDiffer;
    }

    public <T> T merge(T modified, T base, T head) {
        MergingDifferenceVisitor<T> visitor = new MergingDifferenceVisitor<T>(head, modified);
        DiffNode difference = this.objectDiffer.compare(modified, base);
        difference.visit(visitor);
        return head;
    }

    private static final class MergingDifferenceVisitor<T>
    implements DiffNode.Visitor {
        private final T head;
        private final T modified;

        public MergingDifferenceVisitor(T head, T modified) {
            this.head = head;
            this.modified = modified;
        }

        @Override
        public void node(DiffNode node, Visit visit) {
            if (node.getState() == DiffNode.State.ADDED) {
                node.canonicalSet(this.head, node.canonicalGet(this.modified));
            } else if (node.getState() == DiffNode.State.REMOVED) {
                node.canonicalUnset(this.head);
            } else if (node.getState() == DiffNode.State.CHANGED) {
                if (node.hasChildren()) {
                    node.visitChildren(this);
                    visit.dontGoDeeper();
                } else {
                    node.canonicalSet(this.head, node.canonicalGet(this.modified));
                }
            }
        }
    }
}

