/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.blame.BlameGenerator;
import org.openrewrite.jgit.blame.BlameResult;
import org.openrewrite.jgit.diff.DiffAlgorithm;
import org.openrewrite.jgit.diff.RawTextComparator;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.Repository;

public class BlameCommand
extends GitCommand<BlameResult> {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection<ObjectId> reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repo) {
        super(repo);
    }

    public BlameCommand setFilePath(String filePath) {
        this.path = filePath;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId commit) {
        this.startCommit = commit.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean follow) {
        this.followFileRenames = follow;
        return this;
    }

    public BlameCommand reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId start, Collection<ObjectId> end) throws IOException {
        this.startCommit = start.toObjectId();
        this.reverseEndCommits = new ArrayList<ObjectId>(end);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BlameResult call() throws GitAPIException {
        this.checkCallable();
        try (BlameGenerator gen = new BlameGenerator(this.repo, this.path);){
            if (this.diffAlgorithm != null) {
                gen.setDiffAlgorithm(this.diffAlgorithm);
            }
            if (this.textComparator != null) {
                gen.setTextComparator(this.textComparator);
            }
            if (this.followFileRenames != null) {
                gen.setFollowFileRenames(this.followFileRenames);
            }
            if (this.reverseEndCommits != null) {
                gen.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
            } else if (this.startCommit != null) {
                gen.push(null, this.startCommit);
            } else {
                gen.prepareHead();
            }
            BlameResult blameResult = gen.computeBlameResult();
            return blameResult;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

