/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.api.FetchCommand;
import org.openrewrite.jgit.api.Git;
import org.openrewrite.jgit.api.InitCommand;
import org.openrewrite.jgit.api.SubmoduleInitCommand;
import org.openrewrite.jgit.api.SubmoduleUpdateCommand;
import org.openrewrite.jgit.api.TransportCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.InvalidRemoteException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.TransportException;
import org.openrewrite.jgit.dircache.DirCache;
import org.openrewrite.jgit.dircache.DirCacheCheckout;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.BranchConfig;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.RefUpdate;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.submodule.SubmoduleWalk;
import org.openrewrite.jgit.transport.FetchResult;
import org.openrewrite.jgit.transport.RefSpec;
import org.openrewrite.jgit.transport.RemoteConfig;
import org.openrewrite.jgit.transport.TagOpt;
import org.openrewrite.jgit.transport.URIish;
import org.openrewrite.jgit.util.FS;
import org.openrewrite.jgit.util.FileUtils;

public class CloneCommand
extends TransportCommand<CloneCommand, Git> {
    private String uri;
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean cloneAllBranches;
    private boolean mirror;
    private boolean cloneSubmodules;
    private boolean noCheckout;
    private Collection<String> branchesToClone;
    private Callback callback;
    private boolean directoryExistsInitially;
    private boolean gitDirExistsInitially;
    private FETCH_TYPE fetchType;
    private TagOpt tagOption;

    public CloneCommand() {
        super(null);
    }

    @Nullable
    File getDirectory() {
        return this.directory;
    }

    @Override
    public Git call() throws GitAPIException, InvalidRemoteException, TransportException {
        URIish u = null;
        try {
            u = new URIish(this.uri);
            this.verifyDirectories(u);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidURL, this.uri), e);
        }
        this.setFetchType();
        Repository repository = this.init();
        FetchResult fetchResult = null;
        Thread cleanupHook = new Thread(() -> this.cleanup());
        try {
            Runtime.getRuntime().addShutdownHook(cleanupHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fetchResult = this.fetch(repository, u);
        }
        catch (IOException ioe) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        catch (URISyntaxException e) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (RuntimeException | GitAPIException e) {
            if (repository != null) {
                repository.close();
            }
            this.cleanup();
            throw e;
        }
        finally {
            try {
                Runtime.getRuntime().removeShutdownHook(cleanupHook);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (!this.noCheckout) {
            try {
                this.checkout(repository, fetchResult);
            }
            catch (IOException ioe) {
                repository.close();
                throw new JGitInternalException(ioe.getMessage(), ioe);
            }
            catch (RuntimeException | GitAPIException e) {
                repository.close();
                throw e;
            }
        }
        return new Git(repository, true);
    }

    private void setFetchType() {
        if (this.mirror) {
            this.fetchType = FETCH_TYPE.MIRROR;
            this.setBare(true);
        } else {
            this.fetchType = this.cloneAllBranches ? FETCH_TYPE.ALL_BRANCHES : (this.branchesToClone != null && !this.branchesToClone.isEmpty() ? FETCH_TYPE.MULTIPLE_BRANCHES : FETCH_TYPE.ALL_BRANCHES);
        }
    }

    private static boolean isNonEmptyDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            return files != null && files.length != 0;
        }
        return false;
    }

    void verifyDirectories(URIish u) {
        if (this.directory == null && this.gitDir == null) {
            this.directory = new File(u.getHumanishName() + (this.bare ? ".git" : ""));
        }
        this.directoryExistsInitially = this.directory != null && this.directory.exists();
        this.gitDirExistsInitially = this.gitDir != null && this.gitDir.exists();
        CloneCommand.validateDirs(this.directory, this.gitDir, this.bare);
        if (CloneCommand.isNonEmptyDirectory(this.directory)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.directory.getName()));
        }
        if (CloneCommand.isNonEmptyDirectory(this.gitDir)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.gitDir.getName()));
        }
    }

    private Repository init() throws GitAPIException {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.fs != null) {
            command.setFs(this.fs);
        }
        if (this.directory != null) {
            command.setDirectory(this.directory);
        }
        if (this.gitDir != null) {
            command.setGitDir(this.gitDir);
        }
        return command.call().getRepository();
    }

    private FetchResult fetch(Repository clonedRepo, URIish u) throws URISyntaxException, TransportException, IOException, GitAPIException {
        RemoteConfig config = new RemoteConfig(clonedRepo.getConfig(), this.remote);
        config.addURI(u);
        boolean fetchAll = this.fetchType == FETCH_TYPE.ALL_BRANCHES || this.fetchType == FETCH_TYPE.MIRROR;
        config.setFetchRefSpecs(this.calculateRefSpecs(this.fetchType, config.getName()));
        config.setMirror(this.fetchType == FETCH_TYPE.MIRROR);
        if (this.tagOption != null) {
            config.setTagOpt(this.tagOption);
        }
        config.update(clonedRepo.getConfig());
        clonedRepo.getConfig().save();
        FetchCommand command = new FetchCommand(clonedRepo);
        command.setRemote(this.remote);
        command.setProgressMonitor(this.monitor);
        if (this.tagOption != null) {
            command.setTagOpt(this.tagOption);
        } else {
            command.setTagOpt(fetchAll ? TagOpt.FETCH_TAGS : TagOpt.AUTO_FOLLOW);
        }
        command.setInitialBranch(this.branch);
        this.configure(command);
        return command.call();
    }

    private List<RefSpec> calculateRefSpecs(FETCH_TYPE type, String remoteName) {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (type == FETCH_TYPE.MIRROR) {
            specs.add(new RefSpec().setForceUpdate(true).setSourceDestination("refs/*", "refs/*"));
        } else {
            RefSpec heads = new RefSpec();
            heads = heads.setForceUpdate(true);
            String dst = (this.bare ? "refs/heads/" : "refs/remotes/" + remoteName + '/') + '*';
            heads = heads.setSourceDestination("refs/heads/*", dst);
            if (type == FETCH_TYPE.MULTIPLE_BRANCHES) {
                RefSpec tags = new RefSpec().setForceUpdate(true).setSourceDestination("refs/tags/*", "refs/tags/*");
                for (String selectedRef : this.branchesToClone) {
                    if (heads.matchSource(selectedRef)) {
                        specs.add(heads.expandFromSource(selectedRef));
                        continue;
                    }
                    if (!tags.matchSource(selectedRef)) continue;
                    specs.add(tags.expandFromSource(selectedRef));
                }
            } else {
                specs.add(heads);
            }
        }
        return specs;
    }

    private void checkout(Repository clonedRepo, FetchResult result) throws MissingObjectException, IncorrectObjectTypeException, IOException, GitAPIException {
        Ref foundBranch;
        Ref head = null;
        if (this.branch.equals("HEAD") && (foundBranch = this.findBranchToCheckout(result)) != null) {
            head = foundBranch;
        }
        if (head == null) {
            head = result.getAdvertisedRef(this.branch);
            if (head == null) {
                head = result.getAdvertisedRef("refs/heads/" + this.branch);
            }
            if (head == null) {
                head = result.getAdvertisedRef("refs/tags/" + this.branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return;
        }
        if (head.getName().startsWith("refs/heads/")) {
            RefUpdate newHead = clonedRepo.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            this.addMergeConfig(clonedRepo, head);
        }
        RevCommit commit = this.parseCommit(clonedRepo, head);
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = clonedRepo.updateRef("HEAD", detached);
        u.setNewObjectId(commit.getId());
        u.forceUpdate();
        if (!this.bare) {
            DirCache dc = clonedRepo.lockDirCache();
            DirCacheCheckout co = new DirCacheCheckout(clonedRepo, dc, commit.getTree());
            co.setProgressMonitor(this.monitor);
            co.checkout();
            if (this.cloneSubmodules) {
                this.cloneSubmodules(clonedRepo);
            }
        }
    }

    private void cloneSubmodules(Repository clonedRepo) throws IOException, GitAPIException {
        SubmoduleInitCommand init = new SubmoduleInitCommand(clonedRepo);
        Object submodules = init.call();
        if (submodules.isEmpty()) {
            return;
        }
        if (this.callback != null) {
            this.callback.initializedSubmodules((Collection<String>)submodules);
        }
        SubmoduleUpdateCommand update = new SubmoduleUpdateCommand(clonedRepo);
        this.configure(update);
        update.setProgressMonitor(this.monitor);
        update.setCallback(this.callback);
        if (!update.call().isEmpty()) {
            SubmoduleWalk walk = SubmoduleWalk.forIndex(clonedRepo);
            while (walk.next()) {
                Repository subRepo = walk.getRepository();
                Throwable throwable = null;
                try {
                    if (subRepo == null) continue;
                    this.cloneSubmodules(subRepo);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (subRepo == null) continue;
                    if (throwable != null) {
                        try {
                            subRepo.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    subRepo.close();
                }
            }
        }
    }

    private Ref findBranchToCheckout(FetchResult result) {
        ObjectId objectId;
        ObjectId headId;
        Ref idHEAD = result.getAdvertisedRef("HEAD");
        ObjectId objectId2 = headId = idHEAD != null ? idHEAD.getObjectId() : null;
        if (headId == null) {
            return null;
        }
        if (idHEAD != null && idHEAD.isSymbolic()) {
            return idHEAD.getTarget();
        }
        Ref master = result.getAdvertisedRef("refs/heads/master");
        ObjectId objectId3 = objectId = master != null ? master.getObjectId() : null;
        if (headId.equals(objectId)) {
            return master;
        }
        Ref foundBranch = null;
        for (Ref r : result.getAdvertisedRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/") || !headId.equals(r.getObjectId())) continue;
            foundBranch = r;
            break;
        }
        return foundBranch;
    }

    private void addMergeConfig(Repository clonedRepo, Ref head) throws IOException {
        String branchName = Repository.shortenRefName(head.getName());
        clonedRepo.getConfig().setString("branch", branchName, "remote", this.remote);
        clonedRepo.getConfig().setString("branch", branchName, "merge", head.getName());
        String autosetupRebase = clonedRepo.getConfig().getString("branch", null, "autosetuprebase");
        if ("always".equals(autosetupRebase) || "remote".equals(autosetupRebase)) {
            clonedRepo.getConfig().setEnum("branch", branchName, "rebase", BranchConfig.BranchRebaseMode.REBASE);
        }
        clonedRepo.getConfig().save();
    }

    private RevCommit parseCommit(Repository clonedRepo, Ref ref) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        try (RevWalk rw = new RevWalk(clonedRepo);){
            commit = rw.parseCommit(ref.getObjectId());
        }
        return commit;
    }

    public CloneCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public CloneCommand setDirectory(File directory) {
        CloneCommand.validateDirs(directory, this.gitDir, this.bare);
        this.directory = directory;
        return this;
    }

    public CloneCommand setGitDir(File gitDir) {
        CloneCommand.validateDirs(this.directory, gitDir, this.bare);
        this.gitDir = gitDir;
        return this;
    }

    public CloneCommand setBare(boolean bare) throws IllegalStateException {
        CloneCommand.validateDirs(this.directory, this.gitDir, bare);
        this.bare = bare;
        return this;
    }

    public CloneCommand setFs(FS fs) {
        this.fs = fs;
        return this;
    }

    public CloneCommand setRemote(String remote) {
        if (remote == null) {
            remote = "origin";
        }
        this.remote = remote;
        return this;
    }

    public CloneCommand setBranch(String branch) {
        if (branch == null) {
            branch = "HEAD";
        }
        this.branch = branch;
        return this;
    }

    public CloneCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public CloneCommand setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
        return this;
    }

    public CloneCommand setMirror(boolean mirror) {
        this.mirror = mirror;
        return this;
    }

    public CloneCommand setCloneSubmodules(boolean cloneSubmodules) {
        this.cloneSubmodules = cloneSubmodules;
        return this;
    }

    public CloneCommand setBranchesToClone(Collection<String> branchesToClone) {
        this.branchesToClone = branchesToClone;
        return this;
    }

    public CloneCommand setTagOption(TagOpt tagOption) {
        this.tagOption = tagOption;
        return this;
    }

    public CloneCommand setNoTags() {
        return this.setTagOption(TagOpt.NO_TAGS);
    }

    public CloneCommand setNoCheckout(boolean noCheckout) {
        this.noCheckout = noCheckout;
        return this;
    }

    public CloneCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    private static void validateDirs(File directory, File gitDir, boolean bare) throws IllegalStateException {
        if (directory != null) {
            if (directory.exists() && !directory.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedDirIsNoDirectory, directory));
            }
            if (gitDir != null && gitDir.exists() && !gitDir.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedGitDirIsNoDirectory, gitDir));
            }
            if (bare) {
                if (gitDir != null && !gitDir.equals(directory)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, gitDir, directory));
                }
            } else if (gitDir != null && gitDir.equals(directory)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, gitDir, directory));
            }
        }
    }

    private void cleanup() {
        try {
            if (this.directory != null) {
                if (!this.directoryExistsInitially) {
                    FileUtils.delete(this.directory, 13);
                } else {
                    this.deleteChildren(this.directory);
                }
            }
            if (this.gitDir != null) {
                if (!this.gitDirExistsInitially) {
                    FileUtils.delete(this.gitDir, 13);
                } else {
                    this.deleteChildren(this.gitDir);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteChildren(File file) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File child : files) {
            FileUtils.delete(child, 13);
        }
    }

    public static interface Callback {
        public void initializedSubmodules(Collection<String> var1);

        public void cloningSubmodule(String var1);

        public void checkingOut(AnyObjectId var1, String var2);
    }

    private static enum FETCH_TYPE {
        MULTIPLE_BRANCHES,
        ALL_BRANCHES,
        MIRROR;

    }
}

