/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.jgit.internal.storage.dfs.DfsObjDatabase;
import org.openrewrite.jgit.internal.storage.dfs.DfsOutputStream;
import org.openrewrite.jgit.internal.storage.dfs.DfsPackCompactor;
import org.openrewrite.jgit.internal.storage.dfs.DfsPackDescription;
import org.openrewrite.jgit.internal.storage.dfs.DfsReftable;
import org.openrewrite.jgit.internal.storage.dfs.DfsReftableDatabase;
import org.openrewrite.jgit.internal.storage.dfs.DfsReftableStack;
import org.openrewrite.jgit.internal.storage.io.BlockSource;
import org.openrewrite.jgit.internal.storage.pack.PackExt;
import org.openrewrite.jgit.internal.storage.reftable.ReftableBatchRefUpdate;
import org.openrewrite.jgit.internal.storage.reftable.ReftableCompactor;
import org.openrewrite.jgit.internal.storage.reftable.ReftableConfig;
import org.openrewrite.jgit.internal.storage.reftable.ReftableReader;
import org.openrewrite.jgit.internal.storage.reftable.ReftableWriter;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.transport.ReceiveCommand;

public class DfsReftableBatchRefUpdate
extends ReftableBatchRefUpdate {
    private static final int AVG_BYTES = 36;
    private final DfsReftableDatabase refdb;
    private final DfsObjDatabase odb;

    protected DfsReftableBatchRefUpdate(DfsReftableDatabase refdb, DfsObjDatabase odb) {
        super(refdb, refdb.reftableDatabase, refdb.getLock(), refdb.getRepository());
        this.refdb = refdb;
        this.odb = odb;
    }

    @Override
    protected void applyUpdates(List<Ref> newRefs, List<ReceiveCommand> pending) throws IOException {
        Set<DfsPackDescription> prune = Collections.emptySet();
        DfsPackDescription pack = this.odb.newPack(DfsObjDatabase.PackSource.INSERT);
        try (DfsOutputStream out = this.odb.writeFile(pack, PackExt.REFTABLE);){
            ReftableWriter.Stats stats;
            ReftableConfig cfg = DfsPackCompactor.configureReftable(this.refdb.getReftableConfig(), out);
            if (this.refdb.compactDuringCommit() && newRefs.size() * 36 <= cfg.getRefBlockSize() && this.canCompactTopOfStack(cfg)) {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                ReftableWriter rw = new ReftableWriter(cfg, tmp);
                this.write(rw, newRefs, pending);
                rw.finish();
                stats = this.compactTopOfStack(out, cfg, tmp.toByteArray());
                prune = this.toPruneTopOfStack();
            } else {
                ReftableWriter rw = new ReftableWriter(cfg, out);
                this.write(rw, newRefs, pending);
                rw.finish();
                stats = rw.getStats();
            }
            pack.addFileExt(PackExt.REFTABLE);
            pack.setReftableStats(stats);
        }
        this.odb.commitPack(Collections.singleton(pack), prune);
        this.odb.addReftable(pack, prune);
        this.refdb.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCompactTopOfStack(ReftableConfig cfg) throws IOException {
        this.refdb.getLock().lock();
        try {
            DfsReftableStack stack = this.refdb.stack();
            List<ReftableReader> readers = stack.readers();
            if (readers.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            int lastIdx = readers.size() - 1;
            DfsReftable last = stack.files().get(lastIdx);
            DfsPackDescription desc = last.getPackDescription();
            if (desc.getPackSource() != DfsObjDatabase.PackSource.INSERT || !this.packOnlyContainsReftable(desc)) {
                boolean bl = false;
                return bl;
            }
            ReftableReader table = readers.get(lastIdx);
            int bs = cfg.getRefBlockSize();
            boolean bl = table.size() <= (long)(3 * bs);
            return bl;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReftableWriter.Stats compactTopOfStack(OutputStream out, ReftableConfig cfg, byte[] newTable) throws IOException {
        this.refdb.getLock().lock();
        try {
            List<ReftableReader> stack = this.refdb.stack().readers();
            ReftableReader last = stack.get(stack.size() - 1);
            ArrayList<ReftableReader> tables = new ArrayList<ReftableReader>(2);
            tables.add(last);
            tables.add(new ReftableReader(BlockSource.from(newTable)));
            ReftableCompactor compactor = new ReftableCompactor(out);
            compactor.setConfig(cfg);
            compactor.setIncludeDeletes(true);
            compactor.addAll(tables);
            compactor.compact();
            ReftableWriter.Stats stats = compactor.getStats();
            return stats;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DfsPackDescription> toPruneTopOfStack() throws IOException {
        this.refdb.getLock().lock();
        try {
            List<DfsReftable> stack = this.refdb.stack().files();
            DfsReftable last = stack.get(stack.size() - 1);
            Set<DfsPackDescription> set = Collections.singleton(last.getPackDescription());
            return set;
        }
        finally {
            this.refdb.getLock().unlock();
        }
    }

    private boolean packOnlyContainsReftable(DfsPackDescription desc) {
        for (PackExt ext : PackExt.values()) {
            if (ext == PackExt.REFTABLE || !desc.hasFileExt(ext)) continue;
            return false;
        }
        return true;
    }
}

