/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.notes;

import java.io.IOException;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.notes.Note;
import org.openrewrite.jgit.notes.NoteMerger;
import org.openrewrite.jgit.util.io.UnionInputStream;

public class DefaultNoteMerger
implements NoteMerger {
    @Override
    public Note merge(Note base, Note ours, Note theirs, ObjectReader reader, ObjectInserter inserter) throws IOException {
        if (ours == null) {
            return theirs;
        }
        if (theirs == null) {
            return ours;
        }
        if (ours.getData().equals(theirs.getData())) {
            return ours;
        }
        ObjectLoader lo = reader.open(ours.getData());
        ObjectLoader lt = reader.open(theirs.getData());
        try (UnionInputStream union = new UnionInputStream(lo.openStream(), lt.openStream());){
            ObjectId noteData = inserter.insert(3, lo.getSize() + lt.getSize(), union);
            Note note = new Note(ours, noteData);
            return note;
        }
    }
}

