/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ops4j.pax.exam.karaf.container.internal.runner.CommandLineBuilder;
import org.ops4j.pax.exam.karaf.container.internal.runner.InternalRunner;
import org.ops4j.pax.exam.karaf.container.internal.runner.Runner;

public class KarafEmbeddedRunner
implements Runner {
    private InternalRunner runner = new InternalRunner();
    private List<Runnable> resetTasks;

    @Override
    public synchronized void exec(String[] environment, File base, String javaHome, String[] javaOpts, String[] javaEndorsedDirs, String[] javaExtDirs, String home, String data, String etc, String log, String[] karafOpts, String[] opts, String[] classpath, String main, String options, boolean security) {
        new Thread(() -> this.doMain(base, home, data, etc, log, karafOpts, opts, classpath, main, options), "KarafEmbeddedRunner").start();
    }

    private void doMain(File karafBase, String karafHome, String karafData, String karafEtc, String karafLog, String[] karafOpts, String[] opts, String[] classPath, String main, String options) {
        String cp = String.join((CharSequence)File.pathSeparator, classPath);
        this.resetTasks = new ArrayList<Runnable>();
        this.resetTasks.add(this.setSystemProperty("karaf.instances", karafHome + "/instances"));
        this.resetTasks.add(this.setSystemProperty("karaf.home", karafHome));
        this.resetTasks.add(this.setSystemProperty("karaf.base", karafBase.getAbsolutePath()));
        this.resetTasks.add(this.setSystemProperty("karaf.data", karafData));
        this.resetTasks.add(this.setSystemProperty("karaf.etc", karafEtc));
        this.resetTasks.add(this.setSystemProperty("karaf.log", karafLog));
        this.resetTasks.add(this.setSystemProperty("java.util.logging.config.file", karafEtc + "/java.util.logging.properties"));
        CommandLineBuilder commandLine = new CommandLineBuilder();
        commandLine.append(karafOpts).append(opts).append("-cp").append(cp).append(options);
        try {
            Properties configProps;
            Properties jreProps;
            URL[] bundleUrls;
            Thread thread;
            List<File> mainBundles;
            String[] arguments;
            block21: {
                arguments = commandLine.toArray();
                File mainBundlePath = new File(karafBase, "lib");
                mainBundles = this.searchMainBundle(mainBundlePath.listFiles());
                thread = Thread.currentThread();
                try {
                    thread.getContextClassLoader().loadClass("org.apache.karaf.specs.locator.OsgiLocator");
                }
                catch (ClassNotFoundException cnfe) {
                    File endorsed = new File(mainBundlePath, "endorsed");
                    if (!endorsed.exists()) break block21;
                    mainBundles.addAll(Optional.ofNullable(endorsed.listFiles((dir, name) -> name.endsWith(".jar"))).map(Stream::of).map(s -> s.collect(Collectors.toList())).orElseGet(Collections::emptyList));
                }
            }
            if (!mainBundles.isEmpty()) {
                String property;
                bundleUrls = (URL[])mainBundles.stream().map(it -> {
                    try {
                        return it.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).toArray(URL[]::new);
                File jrePropsFile = new File(karafBase, "etc/jre.properties");
                jreProps = this.loadProps(jrePropsFile);
                File configPropsFile = new File(karafBase, "etc/config.properties");
                configProps = this.loadProps(configPropsFile);
                if (!configProps.isEmpty() && (property = configProps.getProperty("org.osgi.framework.bootdelegation")) != null && !property.contains("com.intellij.rt.")) {
                    try (FileOutputStream outputStream = new FileOutputStream(configPropsFile);){
                        configProps.put("org.osgi.framework.bootdelegation", property + this.getCustomBootDelegation() + ",com.intellij.rt.*");
                        configProps.store(outputStream, "adding intellij in delegation");
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            } else {
                throw new RuntimeException("No Karaf main found");
            }
            MainClassLoader urlCl = new MainClassLoader(bundleUrls, (ClassLoader)new FilteringClassLoader(thread.getContextClassLoader(), this.findJre(jreProps, configProps)));
            this.resetTasks.add(() -> {
                try {
                    urlCl.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            thread.setContextClassLoader(urlCl);
            Class<?> mainClass = urlCl.loadClass(main);
            Constructor<?> constructor = mainClass.getConstructor(String[].class);
            constructor.setAccessible(true);
            Object karafInstance = constructor.newInstance(new Object[]{arguments});
            Method method = mainClass.getMethod("launch", null);
            method.invoke(karafInstance, (Object[])null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Runnable setSystemProperty(String key, String value) {
        String old = System.getProperty(key);
        System.setProperty(key, value);
        return () -> {
            if (old == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, value);
            }
        };
    }

    private Properties loadProps(File file) {
        Properties props = new Properties();
        if (file.exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                props.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return props;
    }

    private List<File> searchMainBundle(File[] files) {
        ArrayList<File> mainBundles = new ArrayList<File>();
        if (files == null) {
            return mainBundles;
        }
        for (File file : files) {
            if (file.isDirectory() && this.isBoot(file)) {
                mainBundles.addAll(this.searchMainBundle(file.listFiles()));
                continue;
            }
            if (this.isBoot(file.getParentFile())) {
                if (!file.getName().endsWith(".jar")) continue;
                mainBundles.add(file);
                continue;
            }
            if (!file.getName().startsWith("karaf") || !file.getName().endsWith(".jar")) continue;
            mainBundles.add(file);
        }
        return mainBundles;
    }

    private boolean isBoot(File file) {
        return file != null && file.getName().equals("boot");
    }

    private Collection<String> findJre(Properties jreProps, Properties configProps) {
        List exclusions = this.getForcedOsgiPackages().collect(Collectors.toList());
        return Stream.concat(this.findJreProp(jreProps).stream(), this.toVersions(this.resolveProperty(configProps, "org.osgi.framework.bootdelegation", "")).stream().filter(it -> !it.startsWith("org.apache.karaf."))).filter(it -> exclusions.stream().noneMatch(it::startsWith)).collect(Collectors.toList());
    }

    private Collection<String> findJreProp(Properties jreProps) {
        String key;
        if (jreProps.isEmpty()) {
            return this.getEnforcedParentPackages().collect(Collectors.toList());
        }
        String version = System.getProperty("java.version", "1.8");
        if (version.startsWith("1.8")) {
            key = "jre-1.8";
        } else {
            int sep = 0;
            if (version.indexOf(46) > 0) {
                sep = version.indexOf(".");
            }
            if (version.indexOf(45) > 0) {
                sep = version.indexOf(45);
            }
            try {
                key = "jre-" + Integer.parseInt(version.substring(0, sep));
            }
            catch (NumberFormatException nfe) {
                key = "jre-1.8";
            }
        }
        return Stream.concat(this.getEnforcedParentPackages(), this.toVersions(this.resolveProperty(jreProps, key, null)).stream()).collect(Collectors.toList());
    }

    private String resolveProperty(Properties configProps, String key, String defaultValue) {
        String value = configProps.getProperty(key, defaultValue);
        if (value != null && value.startsWith("${") && value.endsWith("}")) {
            return this.resolveProperty(configProps, value.substring("${".length(), value.length() - "}".length()), defaultValue);
        }
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    private Stream<String> getEnforcedParentPackages() {
        return Stream.concat(Stream.of("java."), this.getCustomJvmPackages());
    }

    private String getCustomBootDelegation() {
        return System.getProperty(this.getClass().getName() + ".customBootDelegation", "");
    }

    private Stream<String> getCustomJvmPackages() {
        Collection<String> config = this.toVersions(System.getProperty(this.getClass().getName() + ".customJvmPackages"));
        if (config.isEmpty()) {
            return Stream.of("com.intellij.rt.");
        }
        return config.stream();
    }

    private Stream<String> getForcedOsgiPackages() {
        Collection<String> config = this.toVersions(System.getProperty(this.getClass().getName() + ".forcedOSGiPackages"));
        if (config.isEmpty()) {
            return Stream.empty();
        }
        return config.stream();
    }

    private Collection<String> toVersions(String property) {
        return property == null ? Collections.emptyList() : (Collection)Stream.of(property.split(",")).map(String::trim).map(it -> {
            int sep = it.indexOf(";");
            return sep > 0 ? it.substring(0, sep) : it;
        }).map(it -> it.endsWith("*") ? it.substring(0, it.length() - 1) : it).collect(Collectors.toList());
    }

    @Override
    public synchronized void shutdown() {
        this.runner.shutdown();
        if (this.resetTasks != null) {
            this.resetTasks.forEach(Runnable::run);
            this.resetTasks.clear();
        }
    }

    private static class FilteringClassLoader
    extends ClassLoader {
        private final Collection<String> packages;

        public FilteringClassLoader(ClassLoader contextClassLoader, Collection<String> packages) {
            super(contextClassLoader);
            this.packages = packages;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name != null) {
                if (this.packages.stream().noneMatch(name::startsWith)) {
                    throw new ClassNotFoundException(name);
                }
            }
            return super.loadClass(name, resolve);
        }

        static {
            FilteringClassLoader.registerAsParallelCapable();
        }
    }

    private static class MainClassLoader
    extends URLClassLoader {
        public MainClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        static {
            MainClassLoader.registerAsParallelCapable();
        }
    }
}

